/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class MarginWidget
extends JPanel {
    String[] str = new String[]{"0", "8", "16", "24", "32"};
    boolean mInternal;
    JComboBox<String> combo = new JComboBox<String>(this.str);
    private static final String COMBO = "combo";
    private static final String TEXT = "text";
    ColorSet mColorSet;
    ArrayList<ActionListener> mCallbacks = new ArrayList();
    JLabel label = new JLabel("0");
    CardLayout layout;
    JButton button;
    BasicComboBoxUI ui = new BasicComboBoxUI(){

        @Override
        protected JButton createArrowButton() {
            Color background = MarginWidget.this.mColorSet.getInspectorBackgroundColor();
            Color shadow = MarginWidget.this.mColorSet.getInspectorStrokeColor();
            Color darkShadow = MarginWidget.this.mColorSet.getInspectorStrokeColor();
            Color highlight = MarginWidget.this.mColorSet.getSubduedFrames();
            MarginWidget.this.button = new BasicArrowButton(5, background, shadow, darkShadow, highlight);
            MarginWidget.this.button.setForeground(Color.RED);
            MarginWidget.this.button.setBorder(new MatteBorder(0, 1, 0, 0, MarginWidget.this.mColorSet.getInspectorStrokeColor()));
            return MarginWidget.this.button;
        }
    };

    @Override
    public void setToolTipText(String text) {
        this.combo.setToolTipText(text);
    }

    public void showUI(Show show) {
        if (this.combo.getEditor().getEditorComponent().hasFocus()) {
            return;
        }
        switch (show) {
            case IN_WIDGET: {
                this.layout.show(this, COMBO);
                this.label.setText((String)this.combo.getSelectedItem());
                break;
            }
            case OUT_WIDGET: {
                if (this.combo.isPopupVisible()) break;
                this.layout.show(this, TEXT);
                break;
            }
            case OUT_PANEL: {
                this.layout.show(this, TEXT);
            }
        }
        this.label.setText((String)this.combo.getSelectedItem());
    }

    public MarginWidget(int alignment, ColorSet colorSet) {
        super(new CardLayout());
        this.mColorSet = colorSet;
        this.layout = (CardLayout)this.getLayout();
        this.combo.setEditable(true);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(42, 23));
        this.setBackground(null);
        this.label.setBackground(null);
        this.label.setOpaque(false);
        this.label.setHorizontalAlignment(alignment);
        this.combo.setBorder(new LineBorder(this.mColorSet.getInspectorStrokeColor()));
        this.label.setForeground(this.mColorSet.getInspectorStrokeColor());
        this.combo.setAlignmentX(0.0f);
        this.combo.addActionListener(e -> {
            if (this.mInternal) {
                return;
            }
            this.label.setText((String)this.combo.getSelectedItem());
            for (ActionListener cb : this.mCallbacks) {
                cb.actionPerformed(e);
            }
        });
        this.add((Component)this.label, TEXT);
        this.add(this.combo, COMBO);
        this.combo.setUI(this.ui);
        this.combo.setEditor(new BasicComboBoxEditor(){

            @Override
            public Component getEditorComponent() {
                return super.getEditorComponent();
            }
        });
        this.combo.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MarginWidget.this.showUI(Show.OUT_PANEL);
            }
        });
        this.combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ((JLabel)ret).setBorder(new LineBorder(MarginWidget.this.mColorSet.getSubduedFrames(), 1));
                return ret;
            }
        });
    }

    public void setMargin(int margin) {
        this.mInternal = true;
        String marginText = String.valueOf(margin);
        this.combo.setSelectedItem(marginText);
        this.label.setText(marginText);
        this.mInternal = false;
    }

    public int getMargin() {
        try {
            return Integer.parseInt(this.label.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.mCallbacks.add(actionListener);
    }

    public static enum Show {
        IN_WIDGET,
        OUT_WIDGET,
        OUT_PANEL;

    }
}

