/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.menu;

import com.android.tools.idea.uibuilder.model.NlComponent;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionBar {
    private final List<NlComponent> myItems;
    private final List<NlComponent> myOverflowItems;
    private final Rectangle myItemBounds;
    private final Rectangle myOverflowItemBounds;

    ActionBar(@NotNull NlComponent group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/handlers/menu/ActionBar", "<init>"));
        }
        this.myItems = new ArrayList<NlComponent>();
        this.myOverflowItems = new ArrayList<NlComponent>();
        this.addToItemsOrOverflowItems(group);
        this.myItems.sort((item1, item2) -> Integer.compare(item1.x, item2.x));
        this.myOverflowItems.sort((item1, item2) -> Integer.compare(item1.y, item2.y));
        this.myItemBounds = ActionBar.getBounds(this.myItems);
        this.myOverflowItemBounds = ActionBar.getBounds(this.myOverflowItems);
    }

    private void addToItemsOrOverflowItems(@NotNull NlComponent group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/handlers/menu/ActionBar", "addToItemsOrOverflowItems"));
        }
        group.getChildren().stream().filter(item -> item.w != -1 && item.h != -1).forEach(item -> {
            if (item.viewInfo == null) {
                this.addToItemsOrOverflowItems((NlComponent)item);
                return;
            }
            switch (item.viewInfo.getViewType()) {
                case ACTION_BAR_MENU: {
                    this.myItems.add((NlComponent)item);
                    break;
                }
                case ACTION_BAR_OVERFLOW_MENU: {
                    this.myOverflowItems.add((NlComponent)item);
                    break;
                }
            }
        });
    }

    @Nullable
    private static Rectangle getBounds(@NotNull List<NlComponent> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/uibuilder/handlers/menu/ActionBar", "getBounds"));
        }
        if (items.isEmpty()) {
            return null;
        }
        NlComponent firstItem = items.get(0);
        Rectangle bounds = new Rectangle(firstItem.x, firstItem.y, firstItem.w, firstItem.h);
        items.subList(1, items.size()).forEach(item -> bounds.add(new Rectangle(item.x, item.y, item.w, item.h)));
        return bounds;
    }

    @NotNull
    List<NlComponent> getItems() {
        List<NlComponent> list = this.myItems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/menu/ActionBar", "getItems"));
        }
        return list;
    }

    @NotNull
    List<NlComponent> getOverflowItems() {
        List<NlComponent> list = this.myOverflowItems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/menu/ActionBar", "getOverflowItems"));
        }
        return list;
    }

    @Nullable
    Rectangle getItemBounds() {
        return this.myItemBounds;
    }

    @Nullable
    Rectangle getOverflowItemBounds() {
        return this.myOverflowItemBounds;
    }

    boolean contains(int x, int y) {
        return this.myItemBounds.contains(x, y) || this.myOverflowItemBounds.contains(x, y);
    }
}

