/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layeredimage;

import com.android.tools.idea.uibuilder.layeredimage.EmptyVirtualFile;
import com.android.tools.idea.uibuilder.layeredimage.LayeredImageEditor;
import com.android.utils.SdkUtils;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LayeredImageEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String EDITOR_TYPE_ID = "layeredimageeditor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/layeredimage/LayeredImageEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/layeredimage/LayeredImageEditorProvider", "accept"));
        }
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".psd");
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/layeredimage/LayeredImageEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/layeredimage/LayeredImageEditorProvider", "createEditor"));
        }
        FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider("images");
        assert (provider != null);
        FileEditor editor = provider.createEditor(project, (VirtualFile)new EmptyVirtualFile(file));
        LayeredImageEditor layeredImageEditor = new LayeredImageEditor(project, file, editor);
        if (layeredImageEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/layeredimage/LayeredImageEditorProvider", "createEditor"));
        }
        return layeredImageEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (EDITOR_TYPE_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/layeredimage/LayeredImageEditorProvider", "getEditorTypeId"));
        }
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/layeredimage/LayeredImageEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

