/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layeredimage;

import com.android.tools.idea.uibuilder.editor.NlAbstractWindowManager;
import com.android.tools.idea.uibuilder.layeredimage.LayeredImageEditor;
import com.android.tools.idea.uibuilder.layeredimage.LayeredImageEditorPanel;
import com.android.tools.idea.uibuilder.layeredimage.LayersPanel;
import com.android.tools.pixelprobe.Image;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayersManager
extends NlAbstractWindowManager {
    private LayersPanel myLayersPanel;

    public LayersManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "<init>"));
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "<init>"));
        }
        super(project, fileEditorManager);
    }

    @NotNull
    public static LayersManager get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "get"));
        }
        LayersManager layersManager = (LayersManager)((Object)project.getComponent(LayersManager.class));
        if (layersManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "get"));
        }
        return layersManager;
    }

    protected void initToolWindow() {
        this.initToolWindow("Image Layers", AllIcons.Toolwindows.ToolWindowChanges);
    }

    @Override
    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        super.updateToolWindow(designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
            if (this.myLayersPanel != null) {
                this.myLayersPanel.setImage(null);
            }
        } else {
            if (this.myLayersPanel == null) {
                this.myLayersPanel = new LayersPanel();
                Disposer.register((Disposable)this, () -> this.myLayersPanel.dispose());
                this.createWindowContent(this.myLayersPanel, this.myLayersPanel, null);
            }
            this.myLayersPanel.setImage(LayersManager.getImage(designer));
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    @Override
    public Object getToolWindowContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "getToolWindowContent"));
        }
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty((Object)this.getComponentName());
        return toolWindow != null ? toolWindow.getContent() : this.myLayersPanel;
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.LEFT;
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "createContent"));
        }
        if (!(designer instanceof LayeredImageEditorPanel)) {
            return null;
        }
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty((Object)this.getComponentName());
        if (toolWindow != null) {
            return toolWindow;
        }
        LayersPanel layersPanel = new LayersPanel();
        layersPanel.setImage(LayersManager.getImage(designer));
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String value = propertiesComponent.getValue(this.myEditorModeKey);
        ToolWindowAnchor anchor = value == null ? this.getAnchor() : (value.equals("ToolWindow") ? null : ToolWindowAnchor.fromText((String)value));
        ThreeComponentsSplitter contentSplitter = designer.getContentSplitter();
        if (contentSplitter.getInnerComponent() == null) {
            return null;
        }
        return new LightToolWindow((LightToolWindowContent)layersPanel, "Image Layers", AllIcons.Toolwindows.ToolWindowPalette, (JComponent)layersPanel, (JComponent)layersPanel, contentSplitter, anchor, (LightToolWindowManager)this, this.myProject, propertiesComponent, this.getVisibilityKeyName(designer), 200, null);
    }

    @NotNull
    public String getComponentName() {
        if ("LayeredImageEditor-LayersManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "getComponentName"));
        }
        return "LayeredImageEditor-LayersManager";
    }

    @Override
    @Nullable
    protected DesignerEditorPanelFacade getDesigner(@Nullable FileEditor editor) {
        if (editor instanceof LayeredImageEditor) {
            return ((LayeredImageEditor)editor).getComponent();
        }
        return null;
    }

    @Nullable
    private static Image getImage(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "getImage"));
        }
        if (designer instanceof LayeredImageEditorPanel) {
            return ((LayeredImageEditorPanel)designer).getImage();
        }
        return null;
    }

    private String getVisibilityKeyName(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/layeredimage/LayersManager", "getVisibilityKeyName"));
        }
        return this.getComponentName() + "-" + designer.getClass().getSimpleName();
    }
}

