/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layeredimage;

import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.android.tools.pixelprobe.util.Images;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

class Utilities {
    private Utilities() {
    }

    @NotNull
    static Image loadImage(@NotNull VirtualFile file) throws IOException {
        Image image;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/layeredimage/Utilities", "loadImage"));
        }
        try (InputStream in = file.getInputStream();){
            Image image2 = PixelProbe.probe((InputStream)in, (Decoder.Options)Decoder.Options.LAYER_METADATA_ONLY);
            image = image2;
        }
        if (image == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/layeredimage/Utilities", "loadImage"));
        }
        return image;
    }

    @NotNull
    static BufferedImage getDisplayableImage(@NotNull Image image) throws IOException {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/uibuilder/layeredimage/Utilities", "getDisplayableImage"));
        }
        BufferedImage bufferedImage = image.getMergedImage();
        if (bufferedImage == null) {
            throw new IOException("Unable to extract flattened bitmap");
        }
        if (!Images.isColorSpace_sRGB((BufferedImage)bufferedImage)) {
            BufferedImage bufferedImage2 = Images.copyTo_sRGB((BufferedImage)bufferedImage);
            if (bufferedImage2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/layeredimage/Utilities", "getDisplayableImage"));
            }
            return bufferedImage2;
        }
        BufferedImage bufferedImage3 = bufferedImage;
        if (bufferedImage3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/layeredimage/Utilities", "getDisplayableImage"));
        }
        return bufferedImage3;
    }
}

