/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.backgroundremove;

import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class HistoryManager<T> {
    private static final int DEFAULT_MAX_HISTORY = 10;
    private final ArrayDeque<T> myUndoStack = new ArrayDeque(10);
    private final ArrayDeque<T> myRedoStack = new ArrayDeque(10);
    private int myMaxHistory = 10;

    public void setOriginalImage(@NotNull T firstObject) {
        if (firstObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstObject", "com/android/tools/idea/uibuilder/mockup/backgroundremove/HistoryManager", "setOriginalImage"));
        }
        this.myUndoStack.clear();
        this.myUndoStack.addLast(firstObject);
    }

    public void setMaxHistory(int maxHistory) {
        this.myMaxHistory = maxHistory;
    }

    public void pushUndo(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/android/tools/idea/uibuilder/mockup/backgroundremove/HistoryManager", "pushUndo"));
        }
        if (!this.myRedoStack.isEmpty()) {
            this.myRedoStack.clear();
        }
        this.myUndoStack.addLast(object);
        if (this.myUndoStack.size() > this.myMaxHistory) {
            this.myUndoStack.removeFirst();
        }
    }

    public T undo() {
        if (this.canUndo()) {
            if (this.myUndoStack.size() == 1) {
                return this.myUndoStack.getLast();
            }
            T poppedObject = this.myUndoStack.removeLast();
            this.myRedoStack.addLast(poppedObject);
        }
        return this.getCurrentObject();
    }

    public T getCurrentObject() {
        return this.myUndoStack.peekLast();
    }

    public T redo() {
        if (!this.myRedoStack.isEmpty()) {
            this.myUndoStack.addLast(this.myRedoStack.removeLast());
        }
        return this.getCurrentObject();
    }

    public boolean canUndo() {
        return this.myUndoStack.size() > 1;
    }

    public boolean canRedo() {
        return !this.myRedoStack.isEmpty();
    }
}

