/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlOldPalettePanel
extends JPanel
implements ToolContent<DesignSurface>,
ConfigurationListener,
ResourceNotificationManager.ResourceChangeListener,
LafManagerListener,
DataProvider {
    private static final Insets INSETS = JBUI.insets((int)0, (int)6);
    private static final int ICON_SPACER = 4;
    private final Project myProject;
    private final JTree myPaletteTree;
    private final IconPreviewFactory myIconFactory;
    private final NlPaletteModel myModel;
    private final Set<String> myMissingLibraries;
    private final DnDManager myDndManager;
    private final DnDSource myDndSource;
    private DesignSurface myDesignSurface;
    private Mode myMode;
    private BufferedImage myLastDragImage;
    private Configuration myConfiguration;
    private Runnable myCloseCallback;

    public NlOldPalettePanel(@NotNull Project project, @Nullable DesignSurface designSurface) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "<init>"));
        }
        this.myProject = project;
        this.myPaletteTree = new PaletteTree();
        this.myPaletteTree.setName("Palette Tree");
        this.myIconFactory = new IconPreviewFactory();
        Disposer.register((Disposable)this, (Disposable)this.myIconFactory);
        this.myModel = NlPaletteModel.get(project);
        this.myMissingLibraries = new HashSet<String>();
        this.myMode = Mode.ICON_AND_TEXT;
        this.myDndManager = DnDManager.getInstance();
        this.myDndSource = new PaletteDnDSource();
        this.myDndManager.registerSource(this.myDndSource, (JComponent)this.myPaletteTree);
        this.initTree();
        JScrollPane palettePane = ScrollPaneFactory.createScrollPane((Component)this.myPaletteTree, (int)20, (int)31);
        palettePane.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)palettePane, "Center");
        this.setToolContext(designSurface);
    }

    @NotNull
    public JComponent getComponent() {
        NlOldPalettePanel nlOldPalettePanel = this;
        if (nlOldPalettePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "getComponent"));
        }
        return nlOldPalettePanel;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        JTree jTree = this.myPaletteTree;
        if (jTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "getFocusedComponent"));
        }
        return jTree;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new ToggleModeAction(this, Mode.ICON_AND_TEXT));
        actions.add((AnAction)new ToggleModeAction(this, Mode.PREVIEW));
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "getGearActions"));
        }
        return arrayList;
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "getAdditionalActions"));
        }
        return list;
    }

    public void registerCloseAutoHideWindow(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "registerCloseAutoHideWindow"));
        }
        this.myCloseCallback = runnable;
    }

    public boolean supportsFiltering() {
        return false;
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "setFilter"));
        }
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        Module prevModule = null;
        if (this.myConfiguration != null) {
            prevModule = this.myConfiguration.getModule();
            this.myConfiguration.removeListener(this);
        }
        Module newModule = null;
        DesignSurface designSurface2 = this.myDesignSurface = designSurface != null && designSurface.getLayoutType().isSupportedByDesigner() ? designSurface : null;
        if (this.myDesignSurface != null) {
            this.updateConfiguration();
            if (this.myConfiguration != null) {
                newModule = this.myConfiguration.getModule();
                this.myConfiguration.addListener(this);
            }
            this.initItems();
            this.checkForNewMissingDependencies();
            this.repaint();
        }
        if (prevModule != newModule) {
            ResourceNotificationManager manager;
            AndroidFacet facet;
            if (prevModule != null && (facet = AndroidFacet.getInstance(prevModule)) != null) {
                manager = ResourceNotificationManager.getInstance(this.myProject);
                manager.removeListener(this, facet, null, null);
            }
            if (newModule != null) {
                facet = AndroidFacet.getInstance(newModule);
                if (facet != null) {
                    manager = ResourceNotificationManager.getInstance(this.myProject);
                    manager.addListener(this, facet, null, null);
                }
                this.myIconFactory.dropCache();
            }
        }
    }

    private void updateColorsAfterColorThemeChange(boolean doUpdate) {
        LafManager manager = LafManager.getInstance();
        if (doUpdate) {
            manager.addLafManagerListener((LafManagerListener)this);
        } else {
            manager.removeLafManagerListener((LafManagerListener)this);
        }
    }

    private void setColors() {
        Color background;
        Color foreground;
        Configuration configuration = null;
        if (this.myDesignSurface != null) {
            configuration = this.myDesignSurface.getConfiguration();
        }
        ResourceResolver resolver = null;
        if (configuration != null) {
            resolver = configuration.getResourceResolver();
        }
        if (resolver == null || this.myMode != Mode.PREVIEW) {
            foreground = UIUtil.getTreeForeground();
            background = UIUtil.getTreeBackground();
        } else {
            ResourceValue textForeground;
            ResourceValue windowBackground = resolver.findItemInTheme("colorBackground", true);
            background = ResourceHelper.resolveColor((RenderResources)resolver, windowBackground, this.myProject);
            if (background == null) {
                background = UIUtil.getTreeBackground();
            }
            if ((foreground = ResourceHelper.resolveColor((RenderResources)resolver, textForeground = resolver.findItemInTheme("colorForeground", true), this.myProject)) == null) {
                foreground = UIUtil.getTreeForeground();
            }
            if (Math.abs(ImageUtils.getBrightness(background.getRGB()) - ImageUtils.getBrightness(foreground.getRGB())) < 64) {
                foreground = ImageUtils.getBrightness(background.getRGB()) < 128 ? JBColor.WHITE : JBColor.BLACK;
            }
        }
        this.myPaletteTree.setBackground(background);
        this.myPaletteTree.setForeground(foreground);
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new ActionHandler();
        }
        return null;
    }

    @NotNull
    public Mode getMode() {
        Mode mode = this.myMode;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "getMode"));
        }
        return mode;
    }

    public void setMode(@NotNull Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "setMode"));
        }
        this.myMode = mode;
        this.setColors();
        this.invalidateUI();
    }

    private void updateConfiguration() {
        this.myConfiguration = null;
        if (this.myDesignSurface == null) {
            return;
        }
        Configuration designConfiguration = this.myDesignSurface.getConfiguration();
        if (designConfiguration == null) {
            return;
        }
        State designState = designConfiguration.getDeviceState();
        Configuration configuration = designConfiguration.clone();
        Device device = configuration.getDevice();
        if (device == null) {
            return;
        }
        Density override = null;
        int monitorResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        for (Density density : Density.values()) {
            if (density.getDpiValue() <= 0 || override != null && Math.abs(density.getDpiValue() - monitorResolution) >= Math.abs(override.getDpiValue() - monitorResolution)) continue;
            override = density;
        }
        if (override != null) {
            device = new Device.Builder(device).build();
            for (State state : device.getAllStates()) {
                Screen screen = state.getHardware().getScreen();
                screen.setXDimension((int)((double)(screen.getXDimension() * override.getDpiValue()) / screen.getXdpi()));
                screen.setYDimension((int)((double)(screen.getYDimension() * override.getDpiValue()) / screen.getYdpi()));
                screen.setXdpi((double)override.getDpiValue());
                screen.setYdpi((double)override.getDpiValue());
                screen.setPixelDensity(override);
            }
            configuration.setDevice(device, false);
            if (designState != null) {
                configuration.setDeviceStateName(designState.getName());
            }
            this.myConfiguration = configuration;
        }
    }

    private void invalidateUI() {
        IJSwingUtilities.updateComponentTreeUI((Component)this.myPaletteTree);
    }

    private void initTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.myPaletteTree.setModel(treeModel);
        this.myPaletteTree.setRowHeight(0);
        this.myPaletteTree.getSelectionModel().setSelectionMode(1);
        this.myPaletteTree.setRootVisible(false);
        this.myPaletteTree.setShowsRootHandles(false);
        this.myPaletteTree.setBorder(new EmptyBorder(INSETS));
        this.myPaletteTree.setToggleClickCount(2);
        ToolTipManager.sharedInstance().registerComponent(this.myPaletteTree);
        TreeUtil.installActions((JTree)this.myPaletteTree);
        this.createCellRenderer(this.myPaletteTree);
        this.myPaletteTree.setSelectionRow(0);
        new PaletteSpeedSearch(this.myPaletteTree);
        this.updateColorsAfterColorThemeChange(true);
        this.enableClickToLoadMissingDependency();
    }

    private void initItems() {
        if (this.myDesignSurface == null || this.myPaletteTree.getRowCount() > 0) {
            return;
        }
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
            if (this.myDesignSurface == null) {
                return;
            }
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myPaletteTree.getModel().getRoot();
            NlOldPalettePanel.addItems(this.myModel.getPalette(this.myDesignSurface.getLayoutType()).getItems(), root);
            this.checkForNewMissingDependencies();
            NlOldPalettePanel.expandAll(this.myPaletteTree, root);
        });
    }

    private static void expandAll(@NotNull JTree tree, @NotNull DefaultMutableTreeNode rootNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "expandAll"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "expandAll"));
        }
        TreePath rootPath = new TreePath(rootNode);
        tree.expandPath(rootPath);
        TreeNode child = rootNode.getLastChild();
        while (child != null) {
            tree.expandPath(rootPath.pathByAddingChild(child));
            child = rootNode.getChildBefore(child);
        }
    }

    private void createCellRenderer(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "createCellRenderer"));
        }
        ColoredTreeCellRenderer renderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$1", "customizeCellRenderer"));
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object content = node.getUserObject();
                if (content instanceof Palette.Item) {
                    Palette.Item item = (Palette.Item)content;
                    BufferedImage image = null;
                    if (!NlOldPalettePanel.this.needsLibraryLoad(item) && NlOldPalettePanel.this.myMode == Mode.PREVIEW && NlOldPalettePanel.this.myConfiguration != null) {
                        image = NlOldPalettePanel.this.myIconFactory.getImage(item, NlOldPalettePanel.this.myConfiguration, NlOldPalettePanel.getScale(item));
                    }
                    if (image != null) {
                        this.setIcon((Icon)new JBImageIcon(image));
                        this.setToolTipText(item.getTitle());
                    } else if (NlOldPalettePanel.this.needsLibraryLoad(item)) {
                        Icon icon = item.getIcon();
                        Icon download = AllIcons.Actions.Download;
                        int factor = SystemInfo.isAppleJvm ? 2 : 1;
                        image = UIUtil.createImage((int)(factor * (download.getIconWidth() + icon.getIconWidth() + 4)), (int)(factor * icon.getIconHeight()), (int)2);
                        Graphics2D g2 = (Graphics2D)image.getGraphics();
                        g2.scale(factor, factor);
                        icon.paintIcon(this.myTree, g2, 0, 0);
                        download.paintIcon(this.myTree, g2, icon.getIconWidth() + 4, 0);
                        g2.dispose();
                        this.append(item.getTitle());
                        this.setIcon((Icon)new JBImageIcon((Image)ImageUtils.convertToRetinaIgnoringFailures(image)));
                    } else {
                        this.append(item.getTitle());
                        this.setIcon(item.getIcon());
                    }
                } else if (content instanceof Palette.Group) {
                    Palette.Group group = (Palette.Group)content;
                    this.append(group.getName());
                    this.setIcon(AllIcons.Nodes.Folder);
                }
            }
        };
        renderer.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
        tree.setCellRenderer((TreeCellRenderer)renderer);
    }

    private static double getScale(@NotNull Palette.Item item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "getScale"));
        }
        double scale = item.getPreviewScale();
        if (scale <= 0.1 || scale > 5.0) {
            scale = 1.0;
        }
        return scale;
    }

    private boolean needsLibraryLoad(@Nullable Palette.BaseItem item) {
        if (!(item instanceof Palette.Item)) {
            return false;
        }
        Palette.Item paletteItem = (Palette.Item)item;
        return this.myMissingLibraries.contains(paletteItem.getGradleCoordinateId());
    }

    private static void addItems(@NotNull List<Palette.BaseItem> items, @NotNull DefaultMutableTreeNode rootNode) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "addItems"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "addItems"));
        }
        for (Palette.BaseItem item : items) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(item);
            if (item instanceof Palette.Group) {
                Palette.Group group = (Palette.Group)item;
                NlOldPalettePanel.addItems(group.getItems(), node);
            }
            rootNode.add(node);
        }
    }

    private void enableClickToLoadMissingDependency() {
        this.myPaletteTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Palette.BaseItem object = NlOldPalettePanel.getItemForPath(NlOldPalettePanel.this.myPaletteTree.getPathForLocation(event.getX(), event.getY()));
                if (NlOldPalettePanel.this.needsLibraryLoad(object)) {
                    Palette.Item item = (Palette.Item)object;
                    String coordinate = item.getGradleCoordinateId();
                    assert (coordinate != null);
                    Module module = NlOldPalettePanel.this.getModule();
                    assert (module != null);
                    GradleDependencyManager manager = GradleDependencyManager.getInstance(NlOldPalettePanel.this.myProject);
                    manager.ensureLibraryIsIncluded(module, NlOldPalettePanel.toGradleCoordinates(Collections.singletonList(coordinate)), null);
                }
            }
        });
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$3", "syncSucceeded"));
                }
                if (NlOldPalettePanel.this.checkForNewMissingDependencies()) {
                    NlOldPalettePanel.this.repaint();
                }
            }
        }, (Disposable)this);
    }

    private boolean checkForNewMissingDependencies() {
        Palette palette;
        List<GradleCoordinate> dependencies;
        GradleDependencyManager manager;
        Module module = this.getModule();
        List<Object> missing = Collections.emptyList();
        if (module != null && (missing = NlOldPalettePanel.fromGradleCoordinates((manager = GradleDependencyManager.getInstance(this.myProject)).findMissingDependencies(module, dependencies = NlOldPalettePanel.toGradleCoordinates((palette = this.myModel.getPalette(this.myDesignSurface.getLayoutType())).getGradleCoordinateIds())))).size() == this.myMissingLibraries.size() && this.myMissingLibraries.containsAll(missing)) {
            return false;
        }
        this.myMissingLibraries.clear();
        this.myMissingLibraries.addAll(missing);
        return true;
    }

    @NotNull
    private static List<GradleCoordinate> toGradleCoordinates(@NotNull Collection<String> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "toGradleCoordinates"));
        }
        if (dependencies.isEmpty()) {
            List<GradleCoordinate> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "toGradleCoordinates"));
            }
            return list;
        }
        ArrayList coordinates = Lists.newArrayList();
        for (String dependency : dependencies) {
            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)(dependency + ":+"));
            if (coordinate == null) continue;
            coordinates.add(coordinate);
        }
        ArrayList arrayList = coordinates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "toGradleCoordinates"));
        }
        return arrayList;
    }

    @NotNull
    private static List<String> fromGradleCoordinates(@NotNull Collection<GradleCoordinate> coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "fromGradleCoordinates"));
        }
        if (coordinates.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "fromGradleCoordinates"));
            }
            return list;
        }
        ArrayList dependencies = Lists.newArrayList();
        for (GradleCoordinate coordinate : coordinates) {
            String dependency = coordinate.getId();
            if (dependency == null) continue;
            dependencies.add(dependency);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "fromGradleCoordinates"));
        }
        return arrayList;
    }

    @Nullable
    private Module getModule() {
        Configuration configuration = this.myDesignSurface != null && this.myDesignSurface.getLayoutType().isSupportedByDesigner() ? this.myDesignSurface.getConfiguration() : null;
        return configuration != null ? configuration.getModule() : null;
    }

    @Nullable
    private static Palette.BaseItem getItemForPath(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return (Palette.BaseItem)node.getUserObject();
    }

    @Override
    public boolean changed(int flags) {
        this.updateConfiguration();
        this.setColors();
        this.repaint();
        return true;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reasons) {
        if (reasons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reasons", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel", "resourcesChanged"));
        }
        for (ResourceNotificationManager.Reason reason : reasons) {
            if (reason == ResourceNotificationManager.Reason.CONFIGURATION_CHANGED) continue;
            this.myIconFactory.dropCache();
            return;
        }
    }

    public void lookAndFeelChanged(LafManager source) {
        this.setColors();
    }

    public void dispose() {
        this.setToolContext(null);
        this.myDndManager.unregisterSource(this.myDndSource, (JComponent)this.myPaletteTree);
        ToolTipManager.sharedInstance().unregisterComponent(this.myPaletteTree);
        this.updateColorsAfterColorThemeChange(false);
    }

    private class ActionHandler
    implements DeleteProvider,
    CutProvider,
    CopyProvider,
    PasteProvider {
        private ActionHandler() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "performCopy"));
            }
            TreePath path = NlOldPalettePanel.this.myPaletteTree.getSelectionPath();
            Palette.BaseItem content = NlOldPalettePanel.getItemForPath(path);
            if (content instanceof Palette.Item && !NlOldPalettePanel.this.needsLibraryLoad(content)) {
                Palette.Item item = (Palette.Item)content;
                DnDTransferComponent component = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
                CopyPasteManager.getInstance().setContents((Transferable)new ItemTransferable(new DnDTransferItem(component)));
            }
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "isCopyEnabled"));
            }
            return true;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "isCopyVisible"));
            }
            return true;
        }

        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "performCut"));
            }
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "isCutEnabled"));
            }
            return false;
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "isCutVisible"));
            }
            return false;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "deleteElement"));
            }
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "canDeleteElement"));
            }
            return false;
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "performPaste"));
            }
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "isPastePossible"));
            }
            return false;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ActionHandler", "isPasteEnabled"));
            }
            return false;
        }
    }

    private static final class PaletteSpeedSearch
    extends TreeSpeedSearch {
        PaletteSpeedSearch(@NotNull JTree tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$PaletteSpeedSearch", "<init>"));
            }
            super(tree);
        }

        protected boolean isMatchingElement(Object element, String pattern) {
            if (pattern == null) {
                return false;
            }
            TreePath path = (TreePath)element;
            Palette.BaseItem content = NlOldPalettePanel.getItemForPath(path);
            return content instanceof Palette.Item && this.compare(((Palette.Item)content).getTitle(), pattern);
        }
    }

    private class PaletteDnDSource
    implements DnDSource {
        private PaletteDnDSource() {
        }

        public boolean canStartDragging(DnDAction action, Point dragOrigin) {
            Palette.BaseItem content = NlOldPalettePanel.getItemForPath(NlOldPalettePanel.this.myPaletteTree.getPathForLocation(dragOrigin.x, dragOrigin.y));
            return content instanceof Palette.Item && !NlOldPalettePanel.this.needsLibraryLoad(content);
        }

        public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
            TreePath path = NlOldPalettePanel.this.myPaletteTree.getClosestPathForLocation(dragOrigin.x, dragOrigin.y);
            Palette.BaseItem content = NlOldPalettePanel.getItemForPath(path);
            assert (content instanceof Palette.Item);
            Palette.Item item = (Palette.Item)content;
            Dimension size = null;
            if (NlOldPalettePanel.this.myDesignSurface != null) {
                BufferedImage image;
                ScreenView screenView = NlOldPalettePanel.this.myDesignSurface.getCurrentScreenView();
                BufferedImage bufferedImage = image = screenView != null ? NlOldPalettePanel.this.myIconFactory.renderDragImage(item, screenView) : null;
                if (image != null) {
                    size = new Dimension(image.getWidth(), image.getHeight());
                    NlOldPalettePanel.this.myLastDragImage = image;
                }
            }
            if (size == null) {
                Rectangle bounds = NlOldPalettePanel.this.myPaletteTree.getPathBounds(path);
                Dimension dimension = size = bounds != null ? bounds.getSize() : new Dimension(200, 100);
                if (NlOldPalettePanel.this.myDesignSurface != null) {
                    double scale = NlOldPalettePanel.this.myDesignSurface.getScale();
                    size.setSize(size.getWidth() / scale, size.getHeight() / scale);
                }
            }
            if (NlOldPalettePanel.this.myCloseCallback != null) {
                NlOldPalettePanel.this.myCloseCallback.run();
            }
            DnDTransferComponent component = new DnDTransferComponent(item.getTagName(), item.getXml(), size.width, size.height);
            return new DnDDragStartBean((Object)new ItemTransferable(new DnDTransferItem(component)));
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
            TreePath path = NlOldPalettePanel.this.myPaletteTree.getClosestPathForLocation(dragOrigin.x, dragOrigin.y);
            BufferedImage image = null;
            if (NlOldPalettePanel.this.myLastDragImage != null && NlOldPalettePanel.this.myDesignSurface != null) {
                double scale = NlOldPalettePanel.this.myDesignSurface.getScale();
                image = ImageUtils.scale(NlOldPalettePanel.this.myLastDragImage, scale);
                NlOldPalettePanel.this.myLastDragImage = null;
            }
            if (image == null) {
                int row = NlOldPalettePanel.this.myPaletteTree.getRowForPath(path);
                Component comp = NlOldPalettePanel.this.myPaletteTree.getCellRenderer().getTreeCellRendererComponent(NlOldPalettePanel.this.myPaletteTree, path.getLastPathComponent(), false, true, true, row, false);
                comp.setForeground(NlOldPalettePanel.this.myPaletteTree.getForeground());
                comp.setBackground(NlOldPalettePanel.this.myPaletteTree.getBackground());
                comp.setFont(NlOldPalettePanel.this.myPaletteTree.getFont());
                comp.setSize(comp.getPreferredSize());
                image = new BufferedImage(comp.getWidth(), comp.getHeight(), 2);
                Graphics2D g2 = (Graphics2D)image.getGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
                comp.paint(g2);
                g2.dispose();
            }
            return Pair.pair((Object)image, (Object)new Point(-image.getWidth() / 2, -image.getHeight() / 2));
        }

        public void dragDropEnd() {
            NlOldPalettePanel.this.myPaletteTree.clearSelection();
        }

        public void dropActionChanged(int gestureModifiers) {
        }
    }

    private class PaletteTree
    extends DnDAwareTree {
        private PaletteTree() {
        }

        public void paintComponent(Graphics g) {
            if (NlOldPalettePanel.this.myMode == Mode.PREVIEW && NlOldPalettePanel.this.myDesignSurface != null && NlOldPalettePanel.this.myConfiguration != null && NlOldPalettePanel.this.myIconFactory.load(NlOldPalettePanel.this.myConfiguration, NlOldPalettePanel.this.myModel.getPalette(NlOldPalettePanel.this.myDesignSurface.getLayoutType()), false)) {
                NlOldPalettePanel.this.invalidateUI();
                return;
            }
            super.paintComponent(g);
        }
    }

    private static class ToggleModeAction
    extends ToggleAction {
        private final NlOldPalettePanel myPalette;
        private final Mode myMode;

        private ToggleModeAction(@NotNull NlOldPalettePanel palette, @NotNull Mode mode) {
            if (palette == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "palette", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ToggleModeAction", "<init>"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$ToggleModeAction", "<init>"));
            }
            super(mode.getMenuText());
            this.myPalette = palette;
            this.myMode = mode;
        }

        public boolean isSelected(AnActionEvent event) {
            return this.myMode == this.myPalette.getMode();
        }

        public void setSelected(AnActionEvent event, boolean unused) {
            this.myPalette.setMode(this.myMode);
        }
    }

    public static enum Mode {
        ICON_AND_TEXT("Show Icon and Text"),
        PREVIEW("Show Preview");

        private final String myMenuText;

        private Mode(String menuText) {
            this.myMenuText = menuText;
        }

        @NotNull
        public String getMenuText() {
            String string = this.myMenuText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlOldPalettePanel$Mode", "getMenuText"));
            }
            return string;
        }
    }
}

