/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.target.AnchorTarget;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class ConstraintComponentUtilities {
    protected static final HashMap<String, String> ourReciprocalAttributes = new HashMap();
    protected static final HashMap<String, String> ourMapMarginAttributes;
    protected static final HashMap<String, AnchorTarget.Type> ourMapSideToOriginAnchors;
    protected static final HashMap<String, AnchorTarget.Type> ourMapSideToTargetAnchors;
    protected static final ArrayList<String> ourLeftAttributes;
    protected static final ArrayList<String> ourTopAttributes;
    protected static final ArrayList<String> ourRightAttributes;
    protected static final ArrayList<String> ourBottomAttributes;
    protected static final ArrayList<String> ourBaselineAttributes;
    protected static final ArrayList<String> ourMarginAttributes;
    protected static final ArrayList<String> ourHorizontalAttributes;
    protected static final ArrayList<String> ourVerticalAttributes;
    protected static final ArrayList<String> ourCreatorAttributes;

    public static AnchorTarget getOriginAnchor(Scene scene, NlComponent targetComponent, String attribute) {
        AnchorTarget.Type type = ourMapSideToOriginAnchors.get(attribute);
        SceneComponent component = scene.getSceneComponent(targetComponent);
        if (component != null) {
            return component.getAnchorTarget(type);
        }
        return null;
    }

    public static AnchorTarget getTargetAnchor(Scene scene, NlComponent targetComponent, String attribute) {
        AnchorTarget.Type type = ourMapSideToTargetAnchors.get(attribute);
        SceneComponent component = scene.getSceneComponent(targetComponent);
        if (component != null) {
            return component.getAnchorTarget(type);
        }
        return null;
    }

    private static boolean hasConstraints(NlComponent component, String uri, ArrayList<String> constraints) {
        int count = constraints.size();
        for (int i = 0; i < count; ++i) {
            if (component.getLiveAttribute(uri, constraints.get(i)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHorizontalConstraints(NlComponent component) {
        return ConstraintComponentUtilities.hasConstraints(component, "http://schemas.android.com/apk/res-auto", ourHorizontalAttributes);
    }

    public static boolean hasVerticalConstraints(NlComponent component) {
        return ConstraintComponentUtilities.hasConstraints(component, "http://schemas.android.com/apk/res-auto", ourVerticalAttributes);
    }

    public static int getDpValue(@NotNull NlComponent component, String value) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/ConstraintComponentUtilities", "getDpValue"));
        }
        if (value != null && (resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value, configuration);
            return px == null ? 0 : (int)(0.5f + (float)px.intValue() / ((float)configuration.getDensity().getDpiValue() / 160.0f));
        }
        return 0;
    }

    public static int getGuidelineMode(SceneComponent component) {
        NlComponent nlComponent = component.getNlComponent();
        String begin = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        if (begin != null) {
            return 0;
        }
        if (end != null) {
            return 1;
        }
        return 16;
    }

    public static void clearAttributes(SceneComponent component) {
        final AttributesTransaction transaction = component.getNlComponent().startAttributeTransaction();
        ConstraintComponentUtilities.clearAllAttributes(component, transaction);
        transaction.apply();
        NlModel nlModel = component.getNlComponent().getModel();
        Project project = nlModel.getProject();
        XmlFile file = nlModel.getFile();
        String label = "Cleared all constraints";
        WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/scene/ConstraintComponentUtilities$1", "run"));
                }
                transaction.commit();
            }
        };
        action.execute();
    }

    public static void setDpAttribute(String uri, String attribute, AttributesTransaction transaction, int value) {
        String position = String.format("%ddp", value);
        transaction.setAttribute(uri, attribute, position);
    }

    public static void clearAttributes(String uri, ArrayList<String> attributes, AttributesTransaction transaction) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute(uri, attribute, null);
        }
    }

    public static void clearConnections(NlComponent component, ArrayList<String> attributes, AttributesTransaction transaction) {
        float dpiFactor;
        NlComponent parent;
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", attribute, null);
        }
        if (attributes == ourLeftAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourRightAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourTopAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else if (attributes == ourBottomAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        }
        if (!ConstraintComponentUtilities.hasHorizontalConstraints(component)) {
            int offsetX = 0;
            parent = component.getParent();
            if (parent != null) {
                offsetX = component.x - parent.x;
                dpiFactor = (float)component.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                offsetX = (int)(0.5f + (float)offsetX / dpiFactor);
            }
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, offsetX);
        }
        if (!ConstraintComponentUtilities.hasVerticalConstraints(component)) {
            int offsetY = 0;
            parent = component.getParent();
            if (parent != null) {
                offsetY = component.y - parent.y;
                dpiFactor = (float)component.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                offsetY = (int)(0.5f + (float)offsetY / dpiFactor);
            }
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, offsetY);
        }
    }

    private static void clearAllAttributes(SceneComponent component, AttributesTransaction transaction) {
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourLeftAttributes, transaction);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourTopAttributes, transaction);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourRightAttributes, transaction);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourBottomAttributes, transaction);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/tools", ourCreatorAttributes, transaction);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res/android", ourMarginAttributes, transaction);
        ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, component.getOffsetParentX());
        ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, component.getOffsetParentY());
    }

    public static void updateOnDelete(NlComponent component, String targetId) {
        AttributesTransaction transaction = null;
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourLeftAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourTopAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourRightAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourBottomAttributes, transaction, targetId);
        if ((transaction = ConstraintComponentUtilities.updateOnDelete(component, ourBaselineAttributes, transaction, targetId)) != null) {
            transaction.apply();
            NlModel nlModel = component.getModel();
            Project project = nlModel.getProject();
            XmlFile file = nlModel.getFile();
            String label = "Remove constraints pointing to a deleted component";
            final AttributesTransaction finalTransaction = transaction;
            WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/scene/ConstraintComponentUtilities$2", "run"));
                    }
                    finalTransaction.commit();
                }
            };
            action.execute();
        }
    }

    public static AttributesTransaction updateOnDelete(NlComponent component, ArrayList<String> attributes, AttributesTransaction transaction, String targetId) {
        if (ConstraintComponentUtilities.isConnectedTo(component, attributes, targetId)) {
            if (transaction == null) {
                transaction = component.startAttributeTransaction();
            }
            ConstraintComponentUtilities.clearConnections(component, attributes, transaction);
        }
        return transaction;
    }

    public static boolean isConnectedTo(NlComponent component, ArrayList<String> attributes, String targetId) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            String target = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", attribute);
            if ((target = NlComponent.extractId(target)) == null || !target.equalsIgnoreCase(targetId)) continue;
            return true;
        }
        return false;
    }

    public static void ensureHorizontalPosition(NlComponent component, AttributesTransaction transaction) {
        if (ConstraintComponentUtilities.hasHorizontalConstraints(component)) {
            return;
        }
        int dx = component.x - (component.getParent() != null ? component.getParent().x : 0);
        if (dx > 0) {
            float dipValue = (float)component.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
            String position = String.format("%ddp", (int)(0.5f + (float)dx / dipValue));
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", position);
        }
    }

    public static void ensureVerticalPosition(NlComponent component, AttributesTransaction transaction) {
        if (ConstraintComponentUtilities.hasVerticalConstraints(component)) {
            return;
        }
        int dy = component.y - (component.getParent() != null ? component.getParent().y : 0);
        if (dy > 0) {
            float dipValue = (float)component.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
            String position = String.format("%ddp", (int)(0.5f + (float)dy / dipValue));
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", position);
        }
    }

    static {
        ourReciprocalAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf");
        ourReciprocalAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintLeft_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf");
        ourReciprocalAttributes.put("layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintTop_toBottomOf", "layout_constraintTop_toTopOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf");
        ourMapMarginAttributes = new HashMap();
        ourMapMarginAttributes.put("layout_constraintLeft_toLeftOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintLeft_toRightOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintRight_toLeftOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintRight_toRightOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintTop_toTopOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintTop_toBottomOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintBottom_toTopOf", "layout_marginBottom");
        ourMapMarginAttributes.put("layout_constraintBottom_toBottomOf", "layout_marginBottom");
        ourMapSideToOriginAnchors = new HashMap();
        ourMapSideToOriginAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourMapSideToOriginAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.LEFT);
        ourMapSideToOriginAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.RIGHT);
        ourMapSideToOriginAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourMapSideToOriginAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourMapSideToOriginAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.TOP);
        ourMapSideToOriginAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToOriginAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToOriginAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourMapSideToTargetAnchors = new HashMap();
        ourMapSideToTargetAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourMapSideToTargetAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.RIGHT);
        ourMapSideToTargetAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.LEFT);
        ourMapSideToTargetAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourMapSideToTargetAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourMapSideToTargetAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToTargetAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.TOP);
        ourMapSideToTargetAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToTargetAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourLeftAttributes = new ArrayList();
        ourLeftAttributes.add("layout_constraintLeft_toLeftOf");
        ourLeftAttributes.add("layout_constraintLeft_toRightOf");
        ourTopAttributes = new ArrayList();
        ourTopAttributes.add("layout_constraintTop_toTopOf");
        ourTopAttributes.add("layout_constraintTop_toBottomOf");
        ourRightAttributes = new ArrayList();
        ourRightAttributes.add("layout_constraintRight_toLeftOf");
        ourRightAttributes.add("layout_constraintRight_toRightOf");
        ourBottomAttributes = new ArrayList();
        ourBottomAttributes.add("layout_constraintBottom_toTopOf");
        ourBottomAttributes.add("layout_constraintBottom_toBottomOf");
        ourBaselineAttributes = new ArrayList();
        ourBaselineAttributes.add("layout_constraintBaseline_toBaselineOf");
        ourMarginAttributes = new ArrayList();
        ourMarginAttributes.add("layout_margin");
        ourMarginAttributes.add("layout_marginLeft");
        ourMarginAttributes.add("layout_marginRight");
        ourMarginAttributes.add("layout_marginTop");
        ourMarginAttributes.add("layout_marginBottom");
        ourHorizontalAttributes = new ArrayList();
        ourHorizontalAttributes.add("layout_constraintLeft_toLeftOf");
        ourHorizontalAttributes.add("layout_constraintLeft_toRightOf");
        ourHorizontalAttributes.add("layout_constraintRight_toLeftOf");
        ourHorizontalAttributes.add("layout_constraintRight_toRightOf");
        ourVerticalAttributes = new ArrayList();
        ourVerticalAttributes.add("layout_constraintTop_toTopOf");
        ourVerticalAttributes.add("layout_constraintTop_toBottomOf");
        ourVerticalAttributes.add("layout_constraintBottom_toTopOf");
        ourVerticalAttributes.add("layout_constraintBottom_toBottomOf");
        ourVerticalAttributes.add("layout_constraintBaseline_toBaselineOf");
        ourCreatorAttributes = new ArrayList();
        ourCreatorAttributes.add("layout_constraintLeft_creator");
        ourCreatorAttributes.add("layout_constraintTop_creator");
        ourCreatorAttributes.add("layout_constraintRight_creator");
        ourCreatorAttributes.add("layout_constraintBottom_creator");
        ourCreatorAttributes.add("layout_constraintBaseline_creator");
        ourCreatorAttributes.add("layout_constraintCenter_creator");
        ourCreatorAttributes.add("layout_constraintCenterX_creator");
        ourCreatorAttributes.add("layout_constraintCenterY_creator");
    }
}

