/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.rendering.errors.ui.RenderErrorPanel;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.analytics.NlUsageTrackerManager;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.lint.LintAnnotationsModel;
import com.android.tools.idea.uibuilder.lint.LintNotificationPanel;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.surface.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.ConstraintsLayer;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.InteractionManager;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.MockupLayer;
import com.android.tools.idea.uibuilder.surface.PanZoomListener;
import com.android.tools.idea.uibuilder.surface.SceneLayer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.surface.SelectionLayer;
import com.android.tools.idea.uibuilder.surface.WarningLayer;
import com.android.tools.idea.uibuilder.surface.ZoomType;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignSurface
extends EditorDesignSurface
implements Disposable,
DataProvider {
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 100;
    private static final String PROPERTY_ERROR_PANEL_SPLITTER = DesignSurface.class.getCanonicalName() + ".error.panel.split";
    private static final RenderErrorModel STILL_BUILDING_ERROR_MODEL = new RenderErrorModel((Collection<RenderErrorModel.Issue>)ImmutableList.of((Object)RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.INFORMATION).setSummary("The project is still building").setHtmlContent(new HtmlBuilder().add("The project is still building and the current preview might be inaccurate.").newline().add("The preview will automatically refresh once the build finishes.")).build()));
    private final Project myProject;
    private final JBSplitter myErrorPanelSplitter;
    private final boolean myInPreview;
    private boolean myRenderHasProblems;
    private boolean myStackVertically;
    private boolean myIsCanvasResizing;
    private boolean myMockupVisible;
    private MockupEditor myMockupEditor;
    private boolean myZoomFitted;
    private WeakReference<JBPopup> myLintTooltipPopup;
    @NotNull
    private static ScreenMode ourDefaultScreenMode = ScreenMode.loadDefault();
    @NotNull
    private ScreenMode myScreenMode;
    @Nullable
    private ScreenView myScreenView;
    @Nullable
    private ScreenView myBlueprintView;
    private int myScreenX;
    private int myScreenY;
    private double myScale;
    @NotNull
    private final JScrollPane myScrollPane;
    private final MyLayeredPane myLayeredPane;
    private boolean myDeviceFrames;
    private final List<Layer> myLayers;
    private final InteractionManager myInteractionManager;
    private final GlassPane myGlassPane;
    private final RenderErrorPanel myErrorPanel;
    private List<DesignSurfaceListener> myListeners;
    private List<PanZoomListener> myZoomListeners;
    private boolean myCentered;
    private final NlActionManager myActionManager;
    private float mySavedErrorPanelProportion;
    @NotNull
    private WeakReference<FileEditor> myFileEditorDelegate;
    private final SelectionListener mySelectionListener;
    private final ModelListener myModelListener;
    private final Object myErrorQueueLock;
    private MergingUpdateQueue myErrorQueue;
    private final List<ProgressIndicator> myProgressIndicators;
    private final MyProgressPanel myProgressPanel;

    public DesignSurface(@NotNull Project project, boolean inPreview) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/surface/DesignSurface", "<init>"));
        }
        super(new BorderLayout());
        this.myIsCanvasResizing = false;
        this.myZoomFitted = true;
        this.myLintTooltipPopup = new WeakReference<Object>(null);
        this.myScreenMode = ourDefaultScreenMode;
        this.myScreenX = 70;
        this.myScreenY = 70;
        this.myScale = 1.0;
        this.myDeviceFrames = false;
        this.myLayers = Lists.newArrayList();
        this.myActionManager = new NlActionManager(this);
        this.myFileEditorDelegate = new WeakReference<Object>(null);
        this.mySelectionListener = new SelectionListener(){

            @Override
            public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/surface/DesignSurface$2", "selectionChanged"));
                }
                if (selection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/uibuilder/surface/DesignSurface$2", "selectionChanged"));
                }
                if (DesignSurface.this.myScreenView != null) {
                    DesignSurface.this.notifySelectionListeners(selection);
                } else {
                    DesignSurface.this.notifySelectionListeners(Collections.emptyList());
                }
            }
        };
        this.myModelListener = new ModelListener(){

            @Override
            public void modelChanged(@NotNull NlModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/surface/DesignSurface$3", "modelChanged"));
                }
                model.render();
            }

            @Override
            public void modelRendered(@NotNull NlModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/surface/DesignSurface$3", "modelRendered"));
                }
                if (DesignSurface.this.myScreenView != null) {
                    DesignSurface.this.updateErrorDisplay(DesignSurface.this.myScreenView.getResult());
                    DesignSurface.this.repaint();
                    DesignSurface.this.positionScreens();
                }
            }

            @Override
            public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/surface/DesignSurface$3", "modelChangedOnLayout"));
                }
                DesignSurface.this.repaint();
            }
        };
        this.myErrorQueueLock = new Object();
        this.myProgressIndicators = new ArrayList<ProgressIndicator>();
        this.myProject = project;
        this.myInPreview = inPreview;
        this.setOpaque(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myInteractionManager = new InteractionManager(this);
        this.myLayeredPane = new MyLayeredPane();
        this.myLayeredPane.setBounds(0, 0, 100, 100);
        this.myGlassPane = new GlassPane();
        this.myLayeredPane.add((Component)this.myGlassPane, JLayeredPane.DRAG_LAYER);
        this.myProgressPanel = new MyProgressPanel();
        this.myProgressPanel.setName("Layout Editor Progress Panel");
        this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.setViewportView(this.myLayeredPane);
        this.myScrollPane.setBorder(null);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.getHorizontalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myErrorPanel = new RenderErrorPanel();
        Disposer.register((Disposable)this, (Disposable)this.myErrorPanel);
        this.myErrorPanel.setName("Layout Editor Error Panel");
        this.myErrorPanelSplitter = new JBSplitter(true, 0.75f, 0.5f, 1.0f);
        this.myErrorPanelSplitter.setAndLoadSplitterProportionKey(PROPERTY_ERROR_PANEL_SPLITTER);
        this.myErrorPanelSplitter.setHonorComponentsMinimumSize(true);
        this.myErrorPanelSplitter.setFirstComponent((JComponent)this.myScrollPane);
        this.myErrorPanelSplitter.setSecondComponent((JComponent)this.myErrorPanel);
        this.mySavedErrorPanelProportion = this.myErrorPanelSplitter.getProportion();
        this.myErrorPanel.setMinimizeListener(isMinimized -> {
            NlUsageTracker tracker = NlUsageTrackerManager.getInstance(this);
            if (isMinimized) {
                tracker.logAction(LayoutEditorEvent.LayoutEditorEventType.MINIMIZE_ERROR_PANEL);
                this.mySavedErrorPanelProportion = this.myErrorPanelSplitter.getProportion();
                this.myErrorPanelSplitter.setProportion(1.0f);
            } else {
                tracker.logAction(LayoutEditorEvent.LayoutEditorEventType.RESTORE_ERROR_PANEL);
                this.myErrorPanelSplitter.setProportion(this.mySavedErrorPanelProportion);
            }
            this.updateErrorPanelSplitterUi(isMinimized);
        });
        this.updateErrorPanelSplitterUi(this.myErrorPanel.isMinimized());
        this.add((Component)this.myErrorPanelSplitter);
        this.myScrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (DesignSurface.this.isShowing() && DesignSurface.this.getWidth() > 0 && DesignSurface.this.getHeight() > 0 && DesignSurface.this.myZoomFitted) {
                    DesignSurface.this.zoomToFit();
                } else {
                    DesignSurface.this.positionScreens();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.myInteractionManager.registerListeners();
        this.myActionManager.registerActions(this.myLayeredPane);
    }

    private void updateErrorPanelSplitterUi(boolean isMinimized) {
        boolean showDivider = this.myErrorPanel.isVisible() && !isMinimized;
        this.myErrorPanelSplitter.setShowDividerIcon(showDivider);
        this.myErrorPanelSplitter.setShowDividerControls(showDivider);
        this.myErrorPanelSplitter.setResizeEnabled(showDivider);
        if (isMinimized) {
            this.myErrorPanelSplitter.setProportion(1.0f);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getProject"));
        }
        return project;
    }

    public boolean isPreviewSurface() {
        return this.myInPreview;
    }

    @NotNull
    public NlLayoutType getLayoutType() {
        if (this.myScreenView == null) {
            NlLayoutType nlLayoutType = NlLayoutType.UNKNOWN;
            if (nlLayoutType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getLayoutType"));
            }
            return nlLayoutType;
        }
        NlLayoutType nlLayoutType = NlLayoutType.typeOf(this.myScreenView.getModel().getFile());
        if (nlLayoutType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getLayoutType"));
        }
        return nlLayoutType;
    }

    @NotNull
    public NlActionManager getActionManager() {
        NlActionManager nlActionManager = this.myActionManager;
        if (nlActionManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getActionManager"));
        }
        return nlActionManager;
    }

    public void setCentered(boolean centered) {
        this.myCentered = centered;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @NotNull
    public ScreenMode getScreenMode() {
        ScreenMode screenMode = this.myScreenMode;
        if (screenMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getScreenMode"));
        }
        return screenMode;
    }

    public void setScreenMode(@NotNull ScreenMode screenMode, boolean setAsDefault) {
        if (screenMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenMode", "com/android/tools/idea/uibuilder/surface/DesignSurface", "setScreenMode"));
        }
        if (setAsDefault && ourDefaultScreenMode != screenMode) {
            ourDefaultScreenMode = screenMode;
            ScreenMode.saveDefault(screenMode);
        }
        if (screenMode != this.myScreenMode) {
            boolean adjustZoom = screenMode == ScreenMode.BOTH || this.myScreenMode == ScreenMode.BOTH;
            this.myScreenMode = screenMode;
            if (this.myScreenView != null) {
                NlModel model = this.myScreenView.getModel();
                this.setModel(null);
                this.setModel(model);
                if (adjustZoom) {
                    this.zoomToFit();
                }
            }
        }
    }

    public void setModel(@Nullable NlModel model) {
        if (model == null && this.myScreenView == null) {
            return;
        }
        List<Object> selectionBefore = Collections.emptyList();
        List<NlComponent> selectionAfter = Collections.emptyList();
        if (this.myScreenView != null) {
            this.myScreenView.getModel().removeListener(this.myModelListener);
            SelectionModel selectionModel = this.myScreenView.getSelectionModel();
            selectionBefore = selectionModel.getSelection();
            selectionModel.removeListener(this.mySelectionListener);
            this.myScreenView = null;
        }
        this.myLayers.clear();
        if (model != null) {
            this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.NORMAL, model);
            this.myScreenView.getModel().addListener(this.myModelListener);
            this.updateErrorDisplay(this.myScreenView.getResult());
            this.myLayeredPane.setPreferredSize(this.myScreenView.getPreferredSize());
            NlLayoutType layoutType = this.myScreenView.getModel().getType();
            if (layoutType.equals((Object)NlLayoutType.MENU) || layoutType.equals((Object)NlLayoutType.PREFERENCE_SCREEN)) {
                this.myScreenMode = ScreenMode.SCREEN_ONLY;
            }
            this.myScreenView.setType(this.myScreenMode.getScreenViewType());
            this.addLayers(model);
            this.positionScreens();
            SelectionModel selectionModel = model.getSelectionModel();
            selectionModel.addListener(this.mySelectionListener);
            selectionAfter = selectionModel.getSelection();
            if (this.myInteractionManager.isListening() && !this.getLayoutType().isSupportedByDesigner()) {
                this.myInteractionManager.unregisterListeners();
            } else if (!this.myInteractionManager.isListening() && this.getLayoutType().isSupportedByDesigner()) {
                this.myInteractionManager.registerListeners();
            }
        } else {
            this.myScreenView = null;
            this.myBlueprintView = null;
        }
        this.repaint();
        if (!selectionBefore.equals(selectionAfter)) {
            this.notifySelectionListeners(selectionAfter);
        }
        this.notifyScreenViewChanged();
    }

    private void addLayers(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/surface/DesignSurface", "addLayers"));
        }
        assert (this.myScreenView != null);
        switch (this.myScreenMode) {
            case SCREEN_ONLY: {
                this.addScreenLayers();
                break;
            }
            case BLUEPRINT_ONLY: {
                this.addBlueprintLayers(this.myScreenView);
                break;
            }
            case BOTH: {
                this.myBlueprintView = new ScreenView(this, ScreenView.ScreenViewType.BLUEPRINT, model);
                this.myBlueprintView.setLocation(this.myScreenX + this.myScreenView.getPreferredSize().width + 10, this.myScreenY);
                this.addScreenLayers();
                this.addBlueprintLayers(this.myBlueprintView);
                break;
            }
            default: {
                assert (false) : this.myScreenMode;
                break;
            }
        }
    }

    private void addScreenLayers() {
        assert (this.myScreenView != null);
        this.myLayers.add(new ScreenViewLayer(this.myScreenView));
        this.myLayers.add(new SelectionLayer(this.myScreenView));
        if (this.myScreenView.getModel().getType().isLayout()) {
            this.myLayers.add(new ConstraintsLayer(this, this.myScreenView, true));
        }
        this.myLayers.add(new SceneLayer(this.myScreenView, false));
        this.myLayers.add(new WarningLayer(this.myScreenView));
        if (this.getLayoutType().isSupportedByDesigner()) {
            this.myLayers.add(new CanvasResizeLayer(this, this.myScreenView));
        }
    }

    private void addBlueprintLayers(@NotNull ScreenView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/surface/DesignSurface", "addBlueprintLayers"));
        }
        this.myLayers.add(new SelectionLayer(view));
        this.myLayers.add(new MockupLayer(view));
        this.myLayers.add(new CanvasResizeLayer(this, view));
        this.myLayers.add(new SceneLayer(view, true));
    }

    public void dispose() {
    }

    @Nullable
    public Dimension updateScrolledAreaSize() {
        if (this.myScreenView == null) {
            return null;
        }
        Dimension size = this.myScreenView.getSize();
        Dimension dimension = new Dimension(size.width + 100, size.height + 100);
        if (this.myScreenMode == ScreenMode.BOTH) {
            if (this.isStackVertically()) {
                dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)size.height + 10.0);
            } else {
                dimension.setSize(dimension.getWidth() + (double)size.width + 10.0, dimension.getHeight());
            }
        }
        this.myLayeredPane.setBounds(0, 0, dimension.width, dimension.height);
        this.myLayeredPane.setPreferredSize(dimension);
        this.myScrollPane.revalidate();
        this.myProgressPanel.setBounds(this.myScreenX, this.myScreenY, size.width, size.height);
        return dimension;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGlassPane;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.isFocusOwner()) {
            graphics.setColor(UIUtil.getFocusedBoundsColor());
            graphics.drawRect(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    @Nullable
    public ScreenView getCurrentScreenView() {
        return this.myScreenView;
    }

    @Nullable
    public ScreenView getScreenView(int x, int y) {
        if (this.myBlueprintView != null && x >= this.myBlueprintView.getX() && y >= this.myBlueprintView.getY()) {
            return this.myBlueprintView;
        }
        return this.myScreenView;
    }

    @Nullable
    private ScreenView getHoverScreenView(int x, int y) {
        if (this.myBlueprintView != null && x >= this.myBlueprintView.getX() && x <= this.myBlueprintView.getX() + this.myBlueprintView.getSize().width && y >= this.myBlueprintView.getY() && y <= this.myBlueprintView.getY() + this.myBlueprintView.getSize().height) {
            return this.myBlueprintView;
        }
        if (this.myScreenView != null && x >= this.myScreenView.getX() && x <= this.myScreenView.getX() + this.myScreenView.getSize().width && y >= this.myScreenView.getY() && y <= this.myScreenView.getY() + this.myScreenView.getSize().height) {
            return this.myScreenView;
        }
        return null;
    }

    public void startDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            ConstraintsLayer constraintsLayer;
            if (layer instanceof ConstraintsLayer && !(constraintsLayer = (ConstraintsLayer)layer).isShowOnHover()) {
                constraintsLayer.setShowOnHover(true);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer) || (sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(true);
            this.repaint();
        }
    }

    public void stopDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            ConstraintsLayer constraintsLayer;
            if (layer instanceof ConstraintsLayer && (constraintsLayer = (ConstraintsLayer)layer).isShowOnHover()) {
                constraintsLayer.setShowOnHover(false);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer) || (sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(false);
            this.repaint();
        }
    }

    @Nullable
    public ScreenView getBlueprintView() {
        return this.myBlueprintView;
    }

    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        if (this.myScreenMode == ScreenMode.BOTH && this.myScreenView != null && this.myBlueprintView != null) {
            if (this.isStackVertically()) {
                dimension.setSize(this.myScreenView.getSize().getWidth(), this.myScreenView.getSize().getHeight() + this.myBlueprintView.getSize().getHeight());
            } else {
                dimension.setSize(this.myScreenView.getSize().getWidth() + this.myBlueprintView.getSize().getWidth(), this.myScreenView.getSize().getHeight());
            }
        } else if (this.getCurrentScreenView() != null) {
            dimension.setSize(this.getCurrentScreenView().getSize().getWidth(), this.getCurrentScreenView().getSize().getHeight());
        }
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getContentSize"));
        }
        return dimension2;
    }

    public void hover(int x, int y) {
        ScreenView current = this.getHoverScreenView(x, y);
        for (Layer layer : this.myLayers) {
            boolean show;
            if (layer instanceof ConstraintsLayer) {
                ConstraintsLayer constraintsLayer = (ConstraintsLayer)layer;
                show = false;
                if (constraintsLayer.getScreenView() == current) {
                    show = true;
                }
                if (constraintsLayer.isShowOnHover() == show) continue;
                constraintsLayer.setShowOnHover(show);
                this.repaint();
                continue;
            }
            if (layer instanceof SceneLayer) {
                SceneLayer sceneLayer = (SceneLayer)layer;
                show = false;
                if (sceneLayer.getScreenView() == current) {
                    show = true;
                }
                if (sceneLayer.isShowOnHover() == show) continue;
                sceneLayer.setShowOnHover(show);
                this.repaint();
                continue;
            }
            if (!(layer instanceof CanvasResizeLayer) || !((CanvasResizeLayer)layer).changeHovering(x, y)) continue;
            this.repaint();
        }
        if (this.myErrorPanel.isVisible() && this.myRenderHasProblems) {
            return;
        }
        if (AndroidEditorSettings.getInstance().getGlobalState().isShowLint()) {
            LintAnnotationsModel lintModel;
            ScreenView currentScreenView = this.getCurrentScreenView();
            LintAnnotationsModel lintAnnotationsModel = lintModel = currentScreenView != null ? currentScreenView.getModel().getLintAnnotationsModel() : null;
            if (lintModel != null) {
                for (Layer layer : this.myLayers) {
                    String tooltip = layer.getTooltip(x, y);
                    if (tooltip == null) continue;
                    JBPopup lintPopup = (JBPopup)this.myLintTooltipPopup.get();
                    if (lintPopup != null && lintPopup.isVisible()) break;
                    NlUsageTrackerManager.getInstance(this).logAction(LayoutEditorEvent.LayoutEditorEventType.LINT_TOOLTIP);
                    LintNotificationPanel lintPanel = new LintNotificationPanel(this.getCurrentScreenView(), lintModel);
                    lintPanel.selectIssueAtPoint(Coordinates.getAndroidX(this.getCurrentScreenView(), x), Coordinates.getAndroidY(this.getCurrentScreenView(), y));
                    Point point = new Point(x, y);
                    SwingUtilities.convertPointToScreen(point, this);
                    this.myLintTooltipPopup = new WeakReference<JBPopup>(lintPanel.showInScreenPosition(this.myProject, this, point));
                    break;
                }
            }
        }
    }

    public void resetHover() {
        if (this.myRenderHasProblems) {
            return;
        }
        this.myErrorPanel.setVisible(false);
    }

    public void zoom(@NotNull ZoomType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/surface/DesignSurface", "zoom"));
        }
        this.myZoomFitted = false;
        switch (type) {
            case IN: {
                double currentScale = this.myScale;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    currentScale *= 2.0;
                }
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomIn(current) / 100.0;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    scale /= 2.0;
                }
                this.setScale(scale);
                this.repaint();
                break;
            }
            case OUT: {
                double currentScale = this.myScale;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    currentScale *= 2.0;
                }
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomOut(current) / 100.0;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    scale /= 2.0;
                }
                this.setScale(scale);
                this.repaint();
                break;
            }
            case ACTUAL: {
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    this.setScale(0.5);
                } else {
                    this.setScale(1.0);
                }
                this.repaint();
                break;
            }
            case FIT: 
            case FIT_INTO: {
                this.myZoomFitted = true;
                if (this.myScreenView == null) {
                    return;
                }
                int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
                int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
                Dimension preferredSize = this.myScreenView.getPreferredSize();
                int requiredWidth = preferredSize.width;
                int requiredHeight = preferredSize.height;
                availableWidth -= 120;
                availableHeight -= 120;
                if (this.myScreenMode == ScreenMode.BOTH) {
                    if (DesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, preferredSize)) {
                        requiredHeight *= 2;
                        requiredHeight += 10;
                    } else {
                        requiredWidth *= 2;
                        requiredWidth += 10;
                    }
                }
                double scaleX = (double)availableWidth / (double)requiredWidth;
                double scaleY = (double)availableHeight / (double)requiredHeight;
                double scale = Math.min(scaleX, scaleY);
                if (type == ZoomType.FIT_INTO) {
                    double min = SystemInfo.isMac && UIUtil.isRetina() ? 0.5 : 1.0;
                    scale = Math.min(min, scale);
                }
                this.setScale(scale);
                this.repaint();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + (Object)((Object)type));
            }
        }
    }

    public void zoomActual() {
        this.zoom(ZoomType.ACTUAL);
    }

    public void zoomIn() {
        this.zoom(ZoomType.IN);
    }

    public void zoomOut() {
        this.zoom(ZoomType.OUT);
    }

    public void zoomToFit() {
        this.zoom(ZoomType.FIT);
    }

    public boolean isZoomFitted() {
        return this.myZoomFitted;
    }

    private static boolean isVerticalScreenConfig(int availableWidth, int availableHeight, @NotNull Dimension preferredSize) {
        boolean stackVertically;
        if (preferredSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferredSize", "com/android/tools/idea/uibuilder/surface/DesignSurface", "isVerticalScreenConfig"));
        }
        boolean bl = stackVertically = preferredSize.width > preferredSize.height;
        if (availableWidth > 10 && availableHeight > 3 * availableWidth / 2) {
            stackVertically = true;
        }
        return stackVertically;
    }

    public double getScale() {
        return this.myScale;
    }

    @Override
    public Configuration getConfiguration() {
        return this.myScreenView != null ? this.myScreenView.getConfiguration() : null;
    }

    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        JScrollBar horizontalScrollBar = this.myScrollPane.getHorizontalScrollBar();
        JScrollBar verticalScrollBar = this.myScrollPane.getVerticalScrollBar();
        p.setLocation(Math.max(horizontalScrollBar.getMinimum(), p.x), Math.max(verticalScrollBar.getMinimum(), p.y));
        p.setLocation(Math.min(horizontalScrollBar.getMaximum() - horizontalScrollBar.getVisibleAmount(), p.x), Math.min(verticalScrollBar.getMaximum() - verticalScrollBar.getVisibleAmount(), p.y));
        this.myScrollPane.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.myScrollPane.getViewport().getViewPosition();
    }

    private void setScale(double scale) {
        Point viewPosition = this.myScrollPane.getViewport().getViewPosition();
        Dimension oldSize = this.myScrollPane.getViewport().getViewSize();
        double normalizedX = ((double)viewPosition.x + (double)this.myScrollPane.getWidth() / 2.0) / oldSize.getWidth();
        double normalizedY = ((double)viewPosition.y + (double)this.myScrollPane.getHeight() / 2.0) / oldSize.getHeight();
        if (scale < 0.0) {
            scale = -1.0;
        } else if (Math.abs(scale - 1.0) < 1.0E-4) {
            scale = 1.0;
        } else if (scale < 0.01) {
            scale = 0.01;
        } else if (scale > 10.0) {
            scale = 10.0;
        }
        this.myScale = scale;
        this.positionScreens();
        Dimension newSize = this.updateScrolledAreaSize();
        if (newSize != null) {
            viewPosition.setLocation(normalizedX * newSize.getWidth() - (double)this.myScrollPane.getWidth() / 2.0, normalizedY * newSize.getHeight() - (double)this.myScrollPane.getHeight() / 2.0);
            this.myScrollPane.getViewport().setViewPosition(viewPosition);
        }
        this.notifyScaleChanged();
    }

    private void notifyScaleChanged() {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.zoomChanged(this);
            }
        }
    }

    private void notifyPanningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.panningChanged(adjustmentEvent);
            }
        }
    }

    private void positionScreens() {
        if (this.myScreenView == null) {
            return;
        }
        Dimension screenViewSize = this.myScreenView.getSize();
        int availableWidth = this.myScrollPane.getWidth();
        int availableHeight = this.myScrollPane.getHeight();
        this.myStackVertically = DesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, screenViewSize);
        if (!this.myIsCanvasResizing) {
            if (this.myCentered && availableWidth > 10 && availableHeight > 10) {
                int requiredWidth = screenViewSize.width;
                if (this.myScreenMode == ScreenMode.BOTH && !this.myStackVertically) {
                    requiredWidth += 10;
                    requiredWidth += screenViewSize.width;
                }
                this.myScreenX = Math.max((availableWidth - requiredWidth) / 2, 70);
                int requiredHeight = screenViewSize.height;
                if (this.myScreenMode == ScreenMode.BOTH && this.myStackVertically) {
                    requiredHeight += 10;
                    requiredHeight += screenViewSize.height;
                }
                this.myScreenY = Math.max((availableHeight - requiredHeight) / 2, 70);
            } else if (this.myDeviceFrames) {
                this.myScreenX = 120;
                this.myScreenY = 120;
            } else {
                this.myScreenX = 70;
                this.myScreenY = 70;
            }
        }
        this.myScreenView.setLocation(this.myScreenX, this.myScreenY);
        if (this.myBlueprintView != null) {
            if (this.myStackVertically) {
                this.myBlueprintView.setLocation(this.myScreenX, this.myScreenY + screenViewSize.height + 10);
            } else {
                this.myBlueprintView.setLocation(this.myScreenX + screenViewSize.width + 10, this.myScreenY);
            }
        }
        if (this.myScreenView != null && this.myScreenView.getScene() != null) {
            Scene scene = this.myScreenView.getScene();
            scene.needsRebuildList();
        }
        if (this.myBlueprintView != null && this.myBlueprintView.getScene() != null) {
            Scene scene = this.myBlueprintView.getScene();
            scene.needsRebuildList();
        }
    }

    public boolean isStackVertically() {
        return this.myStackVertically;
    }

    public void toggleDeviceFrames() {
        this.myDeviceFrames = !this.myDeviceFrames;
        this.positionScreens();
        this.repaint();
    }

    @NotNull
    public JComponent getLayeredPane() {
        MyLayeredPane myLayeredPane = this.myLayeredPane;
        if (myLayeredPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getLayeredPane"));
        }
        return myLayeredPane;
    }

    private void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/surface/DesignSurface", "notifySelectionListeners"));
        }
        if (this.myListeners != null) {
            ArrayList listeners = Lists.newArrayList(this.myListeners);
            for (DesignSurfaceListener listener : listeners) {
                listener.componentSelectionChanged(this, newSelection);
            }
        }
    }

    private void notifyScreenViewChanged() {
        NlModel model;
        ScreenView screenView = this.myScreenView;
        NlModel nlModel = model = this.myScreenView != null ? this.myScreenView.getModel() : null;
        if (this.myListeners != null) {
            ArrayList listeners = Lists.newArrayList(this.myListeners);
            for (DesignSurfaceListener listener : listeners) {
                listener.modelChanged(this, model);
                listener.screenChanged(this, screenView);
            }
        }
    }

    void notifyActivateComponent(@NotNull NlComponent component) {
        block2: {
            DesignSurfaceListener listener;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/surface/DesignSurface", "notifyActivateComponent"));
            }
            if (this.myListeners == null) break block2;
            ArrayList listeners = Lists.newArrayList(this.myListeners);
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext() && !(listener = (DesignSurfaceListener)iterator.next()).activatePreferredEditor(this, component)) {
            }
        }
    }

    public void addListener(@NotNull DesignSurfaceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/surface/DesignSurface", "addListener"));
        }
        if (this.myListeners == null) {
            this.myListeners = Lists.newArrayList();
        } else {
            this.myListeners.remove(listener);
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull DesignSurfaceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/surface/DesignSurface", "removeListener"));
        }
        if (this.myListeners != null) {
            this.myListeners.remove(listener);
        }
    }

    public void addPanZoomListener(PanZoomListener listener) {
        if (this.myZoomListeners == null) {
            this.myZoomListeners = Lists.newArrayList();
        } else {
            this.myZoomListeners.remove(listener);
        }
        this.myZoomListeners.add(listener);
    }

    public void removePanZoomListener(PanZoomListener listener) {
        if (this.myZoomListeners != null) {
            this.myZoomListeners.remove(listener);
        }
    }

    public void activate() {
        if (this.myScreenView != null) {
            this.myScreenView.getModel().activate();
        }
    }

    public void deactivate() {
        if (this.myScreenView != null) {
            this.myScreenView.getModel().deactivate();
        }
        this.myInteractionManager.cancelInteraction();
    }

    public void setFileEditorDelegate(@Nullable FileEditor fileEditor) {
        this.myFileEditorDelegate = new WeakReference<FileEditor>(fileEditor);
    }

    public void updateErrorDisplay(@Nullable RenderResult result) {
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        boolean bl = this.myRenderHasProblems = result != null && result.getLogger().hasProblems();
        if (this.myRenderHasProblems) {
            this.updateErrors(result);
        } else {
            this.setShowErrorPanel(false);
        }
    }

    public void setShowErrorPanel(boolean show) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myErrorPanel.setVisible(show);
            this.updateErrorPanelSplitterUi(this.myErrorPanel.isMinimized());
            this.revalidate();
            this.repaint();
        });
    }

    private void updateErrors(@Nullable RenderResult result) {
        assert (result != null && result.getLogger().hasProblems());
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                RenderResult result;
                RenderResult renderResult = result = DesignSurface.this.myScreenView != null ? DesignSurface.this.myScreenView.getResult() : null;
                if (result == null) {
                    return;
                }
                RenderErrorModel model = BuildSettings.getInstance(DesignSurface.this.myProject).getBuildMode() != null && result.getLogger().hasErrors() ? STILL_BUILDING_ERROR_MODEL : RenderErrorModelFactory.createErrorModel(result, DataManager.getInstance().getDataContext((Component)DesignSurface.this.myErrorPanel));
                DesignSurface.this.myErrorPanel.setModel(model);
                DesignSurface.this.setShowErrorPanel(model.getSize() != 0);
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private MergingUpdateQueue getErrorQueue() {
        Object object = this.myErrorQueueLock;
        // MONITORENTER : object
        if (this.myErrorQueue == null) {
            this.myErrorQueue = new MergingUpdateQueue("android.error.computation", 200, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myErrorQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getErrorQueue"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/uibuilder/surface/DesignSurface", "registerIndicator"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.add(indicator);
            this.myProgressPanel.showProgressIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/uibuilder/surface/DesignSurface", "unregisterIndicator"));
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.size() == 0) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    @Override
    public void requestRender(boolean invalidateModel) {
        ScreenView screenView = this.getCurrentScreenView();
        if (screenView != null) {
            if (invalidateModel) {
                screenView.getModel().notifyModified(NlModel.ChangeType.REQUEST_RENDER);
            } else {
                screenView.getModel().requestRender();
            }
        }
    }

    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface", "getScrollPane"));
        }
        return jScrollPane;
    }

    @Override
    public void requestRender() {
        this.requestRender(true);
    }

    public void setMockupVisible(boolean mockupVisible) {
        this.myMockupVisible = mockupVisible;
        this.repaint();
    }

    public boolean isMockupVisible() {
        return this.myMockupVisible;
    }

    public void setMockupEditor(@Nullable MockupEditor mockupEditor) {
        this.myMockupEditor = mockupEditor;
    }

    @Nullable
    public MockupEditor getMockupEditor() {
        return this.myMockupEditor;
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditorDelegate.get();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new DesignSurfaceActionHandler(this);
        }
        return null;
    }

    @VisibleForTesting
    RenderErrorModel getErrorModel() {
        return this.myErrorPanel.getModel();
    }

    private class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setVisible(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon = this.getProgressIcon();
                this.add((Component)icon, "Center");
                if (this.myProgressVisible) {
                    icon.setVisible(true);
                    icon.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                boolean hasResult = DesignSurface.this.myScreenView != null && DesignSurface.this.myScreenView.getResult() != null;
                this.setSmallIcon(hasResult);
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon.setVisible(true);
                }
                icon.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon = this.getProgressIcon();
                icon.setVisible(false);
                icon.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.setBackground((Color)JBColor.RED);
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon = this.getProgressIcon();
            Dimension size = icon.getPreferredSize();
            if (this.mySmall) {
                icon.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            AsyncProcessIcon asyncProcessIcon = this.getProgressIcon(this.mySmall);
            if (asyncProcessIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyProgressPanel", "getProgressIcon"));
            }
            return asyncProcessIcon;
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)DesignSurface.this, (Disposable)this.mySmallProgressIcon);
                }
                AsyncProcessIcon asyncProcessIcon = this.mySmallProgressIcon;
                if (asyncProcessIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyProgressPanel", "getProgressIcon"));
                }
                return asyncProcessIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)DesignSurface.this, (Disposable)this.myLargeProgressIcon);
            }
            AsyncProcessIcon asyncProcessIcon = this.myLargeProgressIcon;
            if (asyncProcessIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyProgressPanel", "getProgressIcon"));
            }
            return asyncProcessIcon;
        }
    }

    private static class GlassPane
    extends JComponent {
        private static final long EVENT_FLAGS = 56L;

        public GlassPane() {
            this.enableEvents(56L);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.enableEvents(56L);
            } else {
                this.disableEvents(56L);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent event) {
            if (!event.isConsumed()) {
                super.processKeyEvent(event);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            if (event.getID() == 501) {
                this.requestFocusInWindow();
            }
            super.processMouseEvent(event);
        }
    }

    private class MyLayeredPane
    extends JLayeredPane
    implements Magnificator,
    DataProvider {
        public MyLayeredPane() {
            this.setOpaque(true);
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, this);
        }

        public Point magnify(double scale, Point at) {
            DesignSurface.this.setScale(scale * DesignSurface.this.myScale);
            DesignSurface.this.repaint();
            return new Point((int)((double)at.x * scale), (int)((double)at.y * scale));
        }

        @Override
        protected void paintComponent(@NotNull Graphics graphics) {
            if (graphics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyLayeredPane", "paintComponent"));
            }
            super.paintComponent(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            int tlx = DesignSurface.this.myScrollPane.getHorizontalScrollBar().getValue();
            int tly = DesignSurface.this.myScrollPane.getVerticalScrollBar().getValue();
            this.paintBackground(g2d, tlx, tly);
            if (DesignSurface.this.myScreenView == null) {
                return;
            }
            Composite oldComposite = g2d.getComposite();
            RenderResult result = DesignSurface.this.myScreenView.getResult();
            boolean paintedFrame = false;
            if (DesignSurface.this.myDeviceFrames && result != null && result.hasImage()) {
                Configuration configuration = DesignSurface.this.myScreenView.getConfiguration();
                Device device = configuration.getDevice();
                State deviceState = configuration.getDeviceState();
                DeviceArtPainter painter = DeviceArtPainter.getInstance();
                if (device != null && painter.hasDeviceFrame(device) && deviceState != null) {
                    paintedFrame = true;
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
                    painter.paintFrame(g2d, device, deviceState.getOrientation(), true, DesignSurface.this.myScreenX, DesignSurface.this.myScreenY, (int)(DesignSurface.this.myScale * (double)result.getRenderedImage().getHeight()));
                }
            }
            g2d.setComposite(oldComposite);
            for (Layer layer : DesignSurface.this.myLayers) {
                if (layer.isHidden()) continue;
                layer.paint(g2d);
            }
            if (!DesignSurface.this.getLayoutType().isSupportedByDesigner()) {
                return;
            }
            if (paintedFrame) {
                g2d.setComposite(AlphaComposite.getInstance(3, 0.9f));
            } else {
                this.paintBoundsRectangle(g2d);
            }
            List<Layer> layers = DesignSurface.this.myInteractionManager.getLayers();
            if (layers != null) {
                for (Layer layer : layers) {
                    if (layer.isHidden()) continue;
                    layer.paint(g2d);
                }
            }
        }

        private void paintBackground(@NotNull Graphics2D graphics, int lx, int ly) {
            if (graphics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyLayeredPane", "paintBackground"));
            }
            int width = DesignSurface.this.myScrollPane.getWidth();
            int height = DesignSurface.this.myScrollPane.getHeight();
            graphics.setColor((Color)NlConstants.DESIGN_SURFACE_BG);
            graphics.fillRect(lx, ly, width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintRulers(@NotNull Graphics2D g, int scrolledX, int scrolledY) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyLayeredPane", "paintRulers"));
            }
            if (DesignSurface.this.myScale < 0.0) {
                return;
            }
            Graphics2D graphics = (Graphics2D)g.create();
            try {
                int firstVisibleTickY;
                int firstVisibleTickX;
                int width = DesignSurface.this.myScrollPane.getWidth();
                int height = DesignSurface.this.myScrollPane.getHeight();
                graphics.setColor((Color)NlConstants.RULER_BG);
                graphics.fillRect(scrolledX, scrolledY, width, 20);
                graphics.fillRect(scrolledX, scrolledY + 20, 20, height - 20);
                graphics.setColor((Color)NlConstants.RULER_TICK_COLOR);
                graphics.setStroke(NlConstants.SOLID_STROKE);
                graphics.setFont(NlConstants.RULER_TEXT_FONT);
                int minorTickDistance = Math.max((int)Math.round((double)NlConstants.RULER_TICK_DISTANCE * DesignSurface.this.myScale), 1);
                int tickIncrement = minorTickDistance > 2 ? 1 : 2;
                int labelWidth = NlConstants.RULER_TEXT_FONT.getStringBounds((String)"0000", (FontRenderContext)graphics.getFontRenderContext()).getBounds().width;
                boolean displayText = labelWidth < minorTickDistance * 10;
                int i = firstVisibleTickX = scrolledX / minorTickDistance - Math.min(DesignSurface.this.myScreenX / minorTickDistance, 10);
                while (i * minorTickDistance < width + scrolledX) {
                    if (i != -10) {
                        int tickPosition = i * minorTickDistance + DesignSurface.this.myScreenX;
                        boolean majorTick = i >= 0 && i % 10 == 0;
                        graphics.drawLine(tickPosition, scrolledY, tickPosition, scrolledY + (majorTick ? 19 : 6));
                        if (displayText && majorTick) {
                            graphics.setColor((Color)NlConstants.RULER_TEXT_COLOR);
                            graphics.drawString(Integer.toString(i * 10), tickPosition + 2, scrolledY + 19);
                            graphics.setColor((Color)NlConstants.RULER_TICK_COLOR);
                        }
                    }
                    i += tickIncrement;
                }
                graphics.rotate(-1.5707963267948966);
                int i2 = firstVisibleTickY = scrolledY / minorTickDistance - Math.min(DesignSurface.this.myScreenY / minorTickDistance, 10);
                while (i2 * minorTickDistance < height + scrolledY) {
                    if (i2 != -10) {
                        int tickPosition = i2 * minorTickDistance + DesignSurface.this.myScreenY;
                        boolean majorTick = i2 >= 0 && i2 % 10 == 0;
                        graphics.drawLine(-tickPosition, scrolledX, -tickPosition, scrolledX + (majorTick ? 19 : 6));
                        if (displayText && majorTick) {
                            graphics.setColor((Color)NlConstants.RULER_TEXT_COLOR);
                            graphics.drawString(Integer.toString(i2 * 10), -tickPosition + 2, scrolledX + 19);
                            graphics.setColor((Color)NlConstants.RULER_TICK_COLOR);
                        }
                    }
                    i2 += tickIncrement;
                }
            }
            finally {
                graphics.dispose();
            }
        }

        private void paintBoundsRectangle(Graphics2D g2d) {
            if (DesignSurface.this.myScreenView == null) {
                return;
            }
            g2d.setColor((Color)NlConstants.BOUNDS_RECT_COLOR);
            int x = DesignSurface.this.myScreenX;
            int y = DesignSurface.this.myScreenY;
            Dimension size = DesignSurface.this.myScreenView.getSize();
            Stroke prevStroke = g2d.getStroke();
            g2d.setStroke(NlConstants.DASHED_STROKE);
            Shape screenShape = DesignSurface.this.myScreenView.getScreenShape();
            if (screenShape == null) {
                g2d.drawLine(x - 1, y - 20, x - 1, y + size.height + 20);
                g2d.drawLine(x - 20, y - 1, x + size.width + 20, y - 1);
                g2d.drawLine(x + size.width, y - 20, x + size.width, y + size.height + 20);
                g2d.drawLine(x - 20, y + size.height, x + size.width + 20, y + size.height);
            } else {
                g2d.draw(screenShape);
            }
            g2d.setStroke(prevStroke);
        }

        @Override
        protected void paintChildren(@NotNull Graphics graphics) {
            if (graphics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyLayeredPane", "paintChildren"));
            }
            super.paintChildren(graphics);
            if (DesignSurface.this.getLayoutType().isSupportedByDesigner()) {
                Graphics2D g2d = (Graphics2D)graphics;
                int tlx = DesignSurface.this.myScrollPane.getHorizontalScrollBar().getValue();
                int tly = DesignSurface.this.myScrollPane.getVerticalScrollBar().getValue();
                this.paintRulers(g2d, tlx, tly);
            }
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            SelectionModel selectionModel;
            NlComponent primary;
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && DesignSurface.this.myScreenView != null && (primary = (selectionModel = DesignSurface.this.myScreenView.getSelectionModel()).getPrimary()) != null) {
                return primary.getTag();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && DesignSurface.this.myScreenView != null) {
                selectionModel = DesignSurface.this.myScreenView.getSelectionModel();
                List<NlComponent> selection = selectionModel.getSelection();
                ArrayList list = Lists.newArrayListWithCapacity((int)selection.size());
                for (NlComponent component : selection) {
                    list.add(component.getTag());
                }
                return list.toArray(XmlTag.EMPTY);
            }
            return null;
        }
    }

    private static class MyScrollBar
    extends JBScrollBar
    implements IdeGlassPane.TopComponent {
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
            super(orientation);
            this.setOpaque(false);
        }

        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed((MouseEvent)e, (JScrollBar)((Object)this));
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
            this.setOpaque(false);
        }

        public int getUnitIncrement(int direction) {
            return 5;
        }

        public int getBlockIncrement(int direction) {
            return 1;
        }
    }

    private static class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setOpaque(true);
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.setupCorners();
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            MyScrollBar myScrollBar = new MyScrollBar(1);
            if (myScrollBar == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyScrollPane", "createVerticalScrollBar"));
            }
            return myScrollBar;
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            MyScrollBar myScrollBar = new MyScrollBar(0);
            if (myScrollBar == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$MyScrollPane", "createHorizontalScrollBar"));
            }
            return myScrollBar;
        }

        protected boolean isOverlaidScrollbar(@Nullable JScrollBar scrollbar) {
            ScrollBarUI vsbUI = scrollbar == null ? null : scrollbar.getUI();
            return vsbUI instanceof ButtonlessScrollBarUI && !((ButtonlessScrollBarUI)vsbUI).alwaysShowTrack();
        }
    }

    public static enum ScreenMode {
        SCREEN_ONLY(ScreenView.ScreenViewType.NORMAL),
        BLUEPRINT_ONLY(ScreenView.ScreenViewType.BLUEPRINT),
        BOTH(ScreenView.ScreenViewType.NORMAL);

        private final ScreenView.ScreenViewType myScreenViewType;
        private static final String SCREEN_MODE_PROPERTY = "NlScreenMode";

        private ScreenMode(ScreenView.ScreenViewType screenViewType) {
            if (screenViewType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenViewType", "com/android/tools/idea/uibuilder/surface/DesignSurface$ScreenMode", "<init>"));
            }
            this.myScreenViewType = screenViewType;
        }

        @NotNull
        public ScreenMode next() {
            ScreenMode[] values = ScreenMode.values();
            ScreenMode screenMode = values[(this.ordinal() + 1) % values.length];
            if (screenMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$ScreenMode", "next"));
            }
            return screenMode;
        }

        @NotNull
        private ScreenView.ScreenViewType getScreenViewType() {
            ScreenView.ScreenViewType screenViewType = this.myScreenViewType;
            if (screenViewType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$ScreenMode", "getScreenViewType"));
            }
            return screenViewType;
        }

        @NotNull
        public static ScreenMode loadDefault() {
            String modeName = PropertiesComponent.getInstance().getValue(SCREEN_MODE_PROPERTY);
            for (ScreenMode mode : ScreenMode.values()) {
                if (!mode.name().equals(modeName)) continue;
                ScreenMode screenMode = mode;
                if (screenMode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$ScreenMode", "loadDefault"));
                }
                return screenMode;
            }
            ScreenMode screenMode = BOTH;
            if (screenMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/DesignSurface$ScreenMode", "loadDefault"));
            }
            return screenMode;
        }

        public static void saveDefault(@NotNull ScreenMode mode) {
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/uibuilder/surface/DesignSurface$ScreenMode", "saveDefault"));
            }
            PropertiesComponent.getInstance().setValue(SCREEN_MODE_PROPERTY, mode.name());
        }
    }
}

