/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOp;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidVirtualDevice
extends InstallableComponent {
    public static final Logger LOG = Logger.getInstance(AndroidVirtualDevice.class);
    private static final String DEFAULT_DEVICE_ID = "Nexus 5X";
    private static final IdDisplay ID_ADDON_GOOGLE_API_IMG = IdDisplay.create((String)"google_apis", (String)"Google APIs");
    private static final IdDisplay ID_VENDOR_GOOGLE = IdDisplay.create((String)"google", (String)"Google Inc.");
    private static final Storage DEFAULT_RAM_SIZE = new Storage(1536L, Storage.Unit.MiB);
    private static final Storage DEFAULT_HEAP_SIZE = new Storage(256L, Storage.Unit.MiB);
    private static final Set<String> ENABLED_HARDWARE = ImmutableSet.of((Object)"hw.accelerometer", (Object)"hw.audioInput", (Object)"hw.battery", (Object)"hw.gps", (Object)"hw.keyboard", (Object)"hw.sensors.orientation", (Object[])new String[]{"hw.sensors.proximity", "hw.sdCard", "hw.gpu.enabled"});
    private static final Set<String> DISABLED_HARDWARE = ImmutableSet.of((Object)"hw.dPad", (Object)"hw.mainKeys", (Object)"hw.trackBall", (Object)"snapshot.present");
    private ProgressStep myProgressStep;
    @Nullable
    private final AndroidVersion myLatestVersion;

    public AndroidVirtualDevice(@NotNull ScopedStateStore store, @NotNull Map<String, RemotePackage> remotePackages, boolean installUpdates, @NotNull FileOp fop) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "<init>"));
        }
        if (remotePackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePackages", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "<init>"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "<init>"));
        }
        super(store, "Android Virtual Device", "A preconfigured and optimized Android Virtual Device for app testing on the emulator. (Recommended)", installUpdates, fop);
        RemotePackage latestInfo = InstallComponentsPath.findLatestPlatform(remotePackages);
        this.myLatestVersion = latestInfo != null ? ((DetailsTypes.PlatformDetailsType)latestInfo.getTypeDetails()).getAndroidVersion() : null;
    }

    @NotNull
    private static Device getDevice(@NotNull File sdkPath) throws WizardException {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getDevice"));
        }
        List<Device> devices = DeviceManagerConnection.getDeviceManagerConnection(sdkPath).getDevices();
        for (Device device : devices) {
            if (!Objects.equal((Object)device.getId(), (Object)DEFAULT_DEVICE_ID)) continue;
            Device device2 = device;
            if (device2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getDevice"));
            }
            return device2;
        }
        throw new WizardException(String.format("No device definition with \"%s\" ID found", DEFAULT_DEVICE_ID));
    }

    private SystemImageDescription getSystemImageDescription(AndroidSdkHandler sdkHandler) throws WizardException {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        Collection systemImages = sdkHandler.getSystemImageManager((ProgressIndicator)progress).lookup(ID_ADDON_GOOGLE_API_IMG, this.myLatestVersion, ID_VENDOR_GOOGLE);
        if (systemImages.isEmpty()) {
            throw new WizardException("Missing system image required for an AVD setup");
        }
        return new SystemImageDescription((ISystemImage)systemImages.iterator().next());
    }

    @Nullable
    @VisibleForTesting
    AvdInfo createAvd(@NotNull AvdManagerConnection connection, @NotNull AndroidSdkHandler sdkHandler) throws WizardException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "createAvd"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "createAvd"));
        }
        Device d = AndroidVirtualDevice.getDevice(sdkHandler.getLocation());
        SystemImageDescription systemImageDescription = this.getSystemImageDescription(sdkHandler);
        String cardSize = AvdOptionsModel.toIniString(AvdWizardUtils.DEFAULT_INTERNAL_STORAGE, false);
        File hardwareSkinPath = AvdWizardUtils.resolveSkinPath(d.getDefaultHardware().getSkinFile(), systemImageDescription, this.myFileOp);
        String displayName = String.format("%1$s %2$s %3$s", d.getDisplayName(), systemImageDescription.getVersion(), systemImageDescription.getAbiType());
        displayName = connection.uniquifyDisplayName(displayName);
        String internalName = AvdWizardUtils.cleanAvdName(connection, displayName, true);
        Abi abi = Abi.getEnum((String)systemImageDescription.getAbiType());
        boolean useRanchu = AvdManagerConnection.doesSystemImageSupportQemu2(systemImageDescription, this.myFileOp);
        boolean supportsSmp = abi != null && abi.supportsMultipleCpuCores() && AvdWizardUtils.getMaxCpuCores() > 1;
        Map<String, String> settings = AndroidVirtualDevice.getAvdSettings(internalName, d);
        settings.put("avd.ini.displayname", displayName);
        if (useRanchu) {
            settings.put("hw.cpu.ncore", String.valueOf(supportsSmp ? AvdWizardUtils.getMaxCpuCores() : 1));
        }
        return connection.createOrUpdateAvd(null, internalName, d, systemImageDescription, ScreenOrientation.PORTRAIT, false, cardSize, hardwareSkinPath, settings, false);
    }

    private static Map<String, String> getAvdSettings(@NotNull String internalName, @NotNull Device device) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getAvdSettings"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getAvdSettings"));
        }
        HashMap result = Maps.newHashMap();
        result.put("hw.gpu.mode", GpuMode.AUTO.getGpuSetting());
        for (String key : ENABLED_HARDWARE) {
            result.put(key, "yes");
        }
        for (String key : DISABLED_HARDWARE) {
            result.put(key, "no");
        }
        for (String key : ImmutableSet.of((Object)"hw.camera.back", (Object)"hw.camera.front")) {
            result.put(key, "emulated");
        }
        result.put("hw.device.name", device.getDisplayName());
        result.put("hw.device.manufacturer", device.getManufacturer());
        result.put("runtime.network.latency", AvdWizardUtils.DEFAULT_NETWORK_LATENCY.getAsParameter());
        result.put("runtime.network.speed", AvdWizardUtils.DEFAULT_NETWORK_SPEED.getAsParameter());
        result.put("AvdId", internalName);
        result.put("hw.lcd.density", String.valueOf(Density.XXHIGH.getDpiValue()));
        AndroidVirtualDevice.setStorageSizeKey(result, "hw.ramSize", DEFAULT_RAM_SIZE, true);
        AndroidVirtualDevice.setStorageSizeKey(result, "vm.heapSize", DEFAULT_HEAP_SIZE, true);
        AndroidVirtualDevice.setStorageSizeKey(result, "disk.dataPartition.size", AvdWizardUtils.DEFAULT_INTERNAL_STORAGE, false);
        return result;
    }

    private static void setStorageSizeKey(Map<String, String> result, String key, Storage size, boolean convertToMb) {
        result.put(key, AvdOptionsModel.toIniString(size, convertToMb));
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        ArrayList result = Lists.newArrayList();
        if (this.myLatestVersion != null) {
            result.add(DetailsTypes.getAddonPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.myLatestVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG));
            result.add(DetailsTypes.getSysImgPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.myLatestVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG, (String)"x86"));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getRequiredSdkPackages"));
        }
        return arrayList;
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "init"));
        }
        this.myProgressStep = progressStep;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "configure"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "configure"));
        }
        this.myProgressStep.getProgressIndicator().setIndeterminate(true);
        this.myProgressStep.getProgressIndicator().setText("Creating Android virtual device");
        installContext.print("Creating Android virtual device\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        try {
            AvdInfo avd = this.createAvd(AvdManagerConnection.getAvdManagerConnection(sdkHandler), sdkHandler);
            if (avd == null) {
                throw new WizardException("Unable to create Android virtual device");
            }
            String successMessage = String.format("Android virtual device %s was successfully created\n", avd.getName());
            installContext.print(successMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        catch (WizardException e) {
            LOG.error((Throwable)e);
            String failureMessage = String.format("Unable to create a virtual device: %s\n", e.getMessage());
            installContext.print(failureMessage, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @Override
    protected boolean isSelectedByDefault() {
        SystemImageDescription desired;
        if (this.mySdkHandler == null) {
            return false;
        }
        try {
            desired = this.getSystemImageDescription(this.mySdkHandler);
        }
        catch (WizardException e) {
            return false;
        }
        AvdManagerConnection connection = AvdManagerConnection.getAvdManagerConnection(this.mySdkHandler);
        List<AvdInfo> avds = connection.getAvds(false);
        for (AvdInfo avd : avds) {
            if (!avd.getAbiType().equals(desired.getAbiType()) || !avd.getAndroidVersion().equals((Object)desired.getVersion())) continue;
            return false;
        }
        return true;
    }
}

