/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.npw.importing.ImportUIUtil;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsOperation
extends InstallOperation<File, File> {
    @NotNull
    private final ComponentInstaller myComponentInstaller;
    @NotNull
    private Collection<? extends InstallableComponent> myComponents;

    public InstallComponentsOperation(@NotNull InstallContext context, @NotNull Collection<? extends InstallableComponent> components, @NotNull ComponentInstaller componentInstaller, double progressRatio) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "<init>"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "<init>"));
        }
        if (componentInstaller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentInstaller", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "<init>"));
        }
        super(context, progressRatio);
        this.myComponentInstaller = componentInstaller;
        this.myComponents = components;
    }

    @Nullable
    private static String getRetryMessage(Collection<RemotePackage> packages) {
        if (!packages.isEmpty()) {
            ArrayList descriptions = Lists.newArrayList();
            for (RemotePackage p : packages) {
                descriptions.add(p.getDisplayName());
            }
            return ImportUIUtil.formatElementListString(descriptions, "The following SDK component was not installed: %s", "The following SDK components were not installed: %1$s and %2$s", "%1$s and %2$s more SDK components were not installed");
        }
        return null;
    }

    @Override
    @NotNull
    protected File perform(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator, @NotNull File sdkLocation) throws WizardException {
        List<RemotePackage> packages;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "perform"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "perform"));
        }
        indicator.setText("Checking for updated SDK components");
        try {
            packages = this.myComponentInstaller.getPackagesToInstall(this.myComponents);
        }
        catch (SdkQuickfixUtils.PackageResolutionException e) {
            throw new WizardException("Failed to determine required packages", e);
        }
        while (!packages.isEmpty()) {
            SdkManagerProgressIndicatorIntegration logger = new SdkManagerProgressIndicatorIntegration(indicator, this.myContext);
            this.myComponentInstaller.installPackages(packages, (ProgressIndicator)logger);
            try {
                packages = this.myComponentInstaller.getPackagesToInstall(this.myComponents);
            }
            catch (SdkQuickfixUtils.PackageResolutionException e) {
                throw new WizardException("Failed to determine required packages", e);
            }
            String message = InstallComponentsOperation.getRetryMessage(packages);
            if (message == null) continue;
            this.promptToRetry(message, logger.getErrors(), null);
        }
        this.myContext.print("Android SDK is up to date.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.setFraction(1.0);
        File file = sdkLocation;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "perform"));
        }
        return file;
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "cleanup"));
        }
    }
}

