/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUsagesTargetProvider
implements UsageTargetProvider {
    public UsageTarget[] getTargets(Editor editor, PsiFile file) {
        UsageTarget[] usageTargetArray;
        if (editor == null || file == null) {
            return UsageTarget.EMPTY_ARRAY;
        }
        XmlTag tag = AndroidUsagesTargetProvider.findValueResourceTagInContext(editor, file, false);
        if (tag != null) {
            UsageTarget[] usageTargetArray2 = new UsageTarget[1];
            usageTargetArray = usageTargetArray2;
            usageTargetArray2[0] = new PsiElement2UsageTargetAdapter((PsiElement)tag);
        } else {
            usageTargetArray = UsageTarget.EMPTY_ARRAY;
        }
        return usageTargetArray;
    }

    public UsageTarget[] getTargets(PsiElement psiElement) {
        return UsageTarget.EMPTY_ARRAY;
    }

    @Nullable
    public static XmlTag findValueResourceTagInContext(@NotNull Editor editor, @NotNull PsiFile file, boolean rename) {
        XmlTag rootTag;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/android/AndroidUsagesTargetProvider", "findValueResourceTagInContext"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/AndroidUsagesTargetProvider", "findValueResourceTagInContext"));
        }
        if (!(file instanceof XmlFile)) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        if (!AndroidResourceUtil.isInResourceSubdirectory(file, ResourceFolderType.VALUES.getName())) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (!rename && element instanceof XmlToken && XmlTokenType.XML_DATA_CHARACTERS.equals(((XmlToken)element).getTokenType())) {
            return null;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (element instanceof XmlToken && XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN.equals(((XmlToken)element).getTokenType()) && tag != null) {
            String parentValue;
            XmlAttribute parentAttribute = tag.getAttribute("parent");
            String string = parentValue = parentAttribute != null ? parentAttribute.getValue() : null;
            if (parentValue != null && parentValue.equals(element.getText())) {
                return null;
            }
        }
        if ((rootTag = ((XmlFile)file).getRootTag()) == null || !"resources".equals(rootTag.getName())) {
            return null;
        }
        return tag;
    }
}

