/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import org.jetbrains.android.inspections.RangeAllowedValues;
import org.jetbrains.android.inspections.ResourceTypeInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SizeConstraint
extends RangeAllowedValues {
    final long exact;
    final long min;
    final long max;
    final long multiple;

    public SizeConstraint(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/android/inspections/SizeConstraint", "<init>"));
        }
        PsiAnnotationMemberValue exactValue = annotation.findAttributeValue("value");
        PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("min");
        PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("max");
        PsiAnnotationMemberValue multipleValue = annotation.findDeclaredAttributeValue("multiple");
        this.exact = ResourceTypeInspection.getLongValue((PsiElement)exactValue, -1L);
        this.min = ResourceTypeInspection.getLongValue((PsiElement)fromValue, Long.MIN_VALUE);
        this.max = ResourceTypeInspection.getLongValue((PsiElement)toValue, Long.MAX_VALUE);
        this.multiple = ResourceTypeInspection.getLongValue((PsiElement)multipleValue, 1L);
    }

    SizeConstraint(long exact, long min, long max, long multiple) {
        this.exact = exact;
        this.min = min;
        this.max = max;
        this.multiple = multiple;
    }

    public String toString() {
        return this.describe(null);
    }

    @Override
    public ResourceTypeInspection.InspectionResult isValid(@NotNull PsiExpression argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/SizeConstraint", "isValid"));
        }
        Number size = this.guessSize(argument);
        if (size == null) {
            return ResourceTypeInspection.InspectionResult.uncertain();
        }
        int actual = size.intValue();
        if (this.exact != -1L ? this.exact != (long)actual : (long)actual < this.min || (long)actual > this.max || (long)actual % this.multiple != 0L) {
            return ResourceTypeInspection.InspectionResult.invalid(argument);
        }
        return ResourceTypeInspection.InspectionResult.valid();
    }

    @Override
    protected Number guessSize(@NotNull PsiExpression argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/SizeConstraint", "guessSize"));
        }
        if (argument instanceof PsiNewExpression) {
            PsiNewExpression pne = (PsiNewExpression)argument;
            PsiArrayInitializerExpression initializer = pne.getArrayInitializer();
            if (initializer != null) {
                return initializer.getInitializers().length;
            }
            PsiExpression[] dimensions = pne.getArrayDimensions();
            if (dimensions.length > 0) {
                PsiExpression dimension = dimensions[0];
                return super.guessSize(dimension);
            }
        } else if (argument instanceof PsiLiteral) {
            PsiLiteral literal = (PsiLiteral)argument;
            Object o = literal.getValue();
            if (o instanceof String) {
                return ((String)o).length();
            }
        } else if (argument instanceof PsiBinaryExpression) {
            Object v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)argument, (boolean)false);
            if (v instanceof String) {
                return ((String)v).length();
            }
        } else if (argument instanceof PsiReferenceExpression) {
            PsiLocalVariable variable;
            PsiExpression initializer;
            PsiReferenceExpression ref = (PsiReferenceExpression)argument;
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                PsiExpression initializer2 = field.getInitializer();
                if (initializer2 != null) {
                    return this.guessSize(initializer2);
                }
            } else if (resolved instanceof PsiLocalVariable && (initializer = (variable = (PsiLocalVariable)resolved).getInitializer()) != null) {
                return this.guessSize(initializer);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String describe(@Nullable PsiExpression argument) {
        Number actual;
        StringBuilder sb = new StringBuilder(20);
        if (argument != null && argument.getType() != null && argument.getType().getCanonicalText().equals("java.lang.String")) {
            sb.append("Length");
        } else {
            sb.append("Size");
        }
        sb.append(" must be");
        if (this.exact != -1L) {
            sb.append(" exactly ");
            sb.append(Long.toString(this.exact));
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/SizeConstraint", "describe"));
            }
            return string;
        }
        boolean continued = true;
        if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
            sb.append(" at least ");
            sb.append(Long.toString(this.min));
            sb.append(" and at most ");
            sb.append(Long.toString(this.max));
        } else if (this.min != Long.MIN_VALUE) {
            sb.append(" at least ");
            sb.append(Long.toString(this.min));
        } else if (this.max != Long.MAX_VALUE) {
            sb.append(" at most ");
            sb.append(Long.toString(this.max));
        } else {
            continued = false;
        }
        if (this.multiple != 1L) {
            if (continued) {
                sb.append(" and");
            }
            sb.append(" a multiple of ");
            sb.append(Long.toString(this.multiple));
        }
        if (argument != null && (actual = this.guessSize(argument)) != null) {
            sb.append(" (was ").append(Integer.toString(actual.intValue())).append(')');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/SizeConstraint", "describe"));
        }
        return string;
    }

    @Override
    public ResourceTypeInspection.InspectionResult contains(@NotNull RangeAllowedValues other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/SizeConstraint", "contains"));
        }
        if (other instanceof SizeConstraint) {
            SizeConstraint otherRange = (SizeConstraint)other;
            if (this.exact != -1L && otherRange.exact != -1L) {
                return this.exact == otherRange.exact ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            if (this.multiple != 1L && (otherRange.exact != -1L ? otherRange.exact % this.multiple != 0L : otherRange.multiple % this.multiple != 0L)) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            if (otherRange.exact != -1L) {
                return otherRange.exact >= this.min && otherRange.exact <= this.max ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            return otherRange.min >= this.min && otherRange.max <= this.max ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalidWithoutNode();
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }
}

