/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.heroku.cloud.HerokuDeploymentConfiguration;
import com.intellij.javaee.heroku.cloud.HerokuDeploymentNameEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.DeploymentNameConfiguration;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class HerokuDeploymentEditor
extends SettingsEditor<HerokuDeploymentConfiguration> {
    private JPanel myMainPanel;
    private JPanel myDeploymentNamePanel;
    private JTextField myDebugPortField;
    private JTextField myHostField;
    private HerokuDeploymentNameEditor myDeploymentNameEditor;

    public HerokuDeploymentEditor() {
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this, (Disposable)this.getDeploymentNameEditor());
    }

    protected void resetEditorFrom(@NotNull HerokuDeploymentConfiguration settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javaee/heroku/cloud/HerokuDeploymentEditor", "resetEditorFrom"));
        }
        this.myDeploymentNameEditor.resetEditorFrom((DeploymentNameConfiguration)settings);
        Integer debugPort = settings.getDebugPort();
        String port = debugPort != null ? String.valueOf(debugPort) : "";
        String host = StringUtil.notNullize((String)settings.getHost());
        this.myDebugPortField.setText(port);
        this.myHostField.setText(host);
    }

    protected void applyEditorTo(@NotNull HerokuDeploymentConfiguration settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javaee/heroku/cloud/HerokuDeploymentEditor", "applyEditorTo"));
        }
        this.myDeploymentNameEditor.applyEditorTo((DeploymentNameConfiguration)settings);
        settings.setDebugPort(this.parsePort());
        settings.setHost(this.myHostField.getText());
    }

    private void createUIComponents() {
        this.myDeploymentNamePanel = (JPanel)this.getDeploymentNameEditor().getComponent();
    }

    private HerokuDeploymentNameEditor getDeploymentNameEditor() {
        if (this.myDeploymentNameEditor == null) {
            this.myDeploymentNameEditor = new HerokuDeploymentNameEditor();
        }
        return this.myDeploymentNameEditor;
    }

    private Integer parsePort() throws RuntimeConfigurationException {
        String debugPort = this.myDebugPortField.getText();
        if (StringUtil.isEmpty((String)debugPort)) {
            return null;
        }
        try {
            return Integer.parseInt(debugPort);
        }
        catch (NumberFormatException e) {
            throw new RuntimeConfigurationException("Invalid port number");
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/heroku/cloud/HerokuDeploymentEditor", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this.myDeploymentNamePanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Debug Port: ");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDebugPortField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.myHostField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Debug Host: ");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

