/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.remove;

import java.io.IOException;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.remove.RemoveParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class RemoveCommand
extends AbstractCommand {
    private boolean deleteBeforeRemove;
    private boolean ignoreLocallyExistingFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(CommandRequest.REMOVE, clientEnvironment);
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        RemoveParser parser = new RemoveParser(eventSender, clientEnvironment.getCvsFileSystem());
        parser.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, FileStateRequestsProgressHandler.create(progressViewer, cvsFiles));
            return bl;
        }
        finally {
            parser.unregisterListeners(listenerRegistry);
        }
    }

    @Override
    protected void addRequestForFile(FileObject fileObject, Entry entry, boolean fileExists, Requests requests, IClientEnvironment clientEnvironment) {
        if (this.isDeleteBeforeRemove()) {
            try {
                clientEnvironment.getLocalFileWriter().removeLocalFile(fileObject, clientEnvironment.getCvsFileSystem(), clientEnvironment.getFileReadOnlyHandler());
            }
            catch (IOException ex) {
                BugLog.getInstance().showException(ex);
            }
            fileExists = false;
        }
        if (this.isIgnoreLocallyExistingFiles()) {
            fileExists = false;
        }
        super.addRequestForFile(fileObject, entry, fileExists, requests, clientEnvironment);
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("remove ");
        cvsCommandLine.append(this.getCvsArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(false);
        this.setDeleteBeforeRemove(false);
        this.setIgnoreLocallyExistingFiles(false);
    }

    private boolean isDeleteBeforeRemove() {
        return this.deleteBeforeRemove;
    }

    public void setDeleteBeforeRemove(boolean deleteBeforeRemove) {
        this.deleteBeforeRemove = deleteBeforeRemove;
    }

    private boolean isIgnoreLocallyExistingFiles() {
        return this.ignoreLocallyExistingFiles;
    }

    public void setIgnoreLocallyExistingFiles(boolean ignoreLocallyExistingFiles) {
        this.ignoreLocallyExistingFiles = ignoreLocallyExistingFiles;
    }

    private String getCvsArguments() {
        StringBuilder toReturn = new StringBuilder();
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isDeleteBeforeRemove()) {
            toReturn.append("-f ");
        }
        return toReturn.toString();
    }
}

