/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.idea.Main;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class BootstrapClassLoaderUtil
extends ClassUtilCore {
    private static final String PROPERTY_IGNORE_CLASSPATH = "ignore.classpath";
    private static final String PROPERTY_ALLOW_BOOTSTRAP_RESOURCES = "idea.allow.bootstrap.resources";
    private static final String PROPERTY_ADDITIONAL_CLASSPATH = "idea.additional.classpath";

    private BootstrapClassLoaderUtil() {
    }

    private static Logger getLogger() {
        return Logger.getInstance(BootstrapClassLoaderUtil.class);
    }

    @NotNull
    public static ClassLoader initClassLoader(boolean updatePlugins) throws MalformedURLException {
        PathManager.loadProperties();
        LinkedHashSet<URL> classpath = new LinkedHashSet<URL>();
        BootstrapClassLoaderUtil.addParentClasspath(classpath, false);
        BootstrapClassLoaderUtil.addIDEALibraries(classpath);
        BootstrapClassLoaderUtil.addAdditionalClassPath(classpath);
        BootstrapClassLoaderUtil.addParentClasspath(classpath, true);
        UrlClassLoader.Builder builder = UrlClassLoader.build().urls(BootstrapClassLoaderUtil.filterClassPath(new ArrayList<URL>(classpath))).allowLock().usePersistentClasspathIndexForLocalClassDirectories().useCache();
        if (Boolean.valueOf(System.getProperty(PROPERTY_ALLOW_BOOTSTRAP_RESOURCES, "true")).booleanValue()) {
            builder.allowBootstrapResources();
        }
        ClassLoaderUtil.addPlatformLoaderParentIfOnJdk9((UrlClassLoader.Builder)builder);
        UrlClassLoader newClassLoader = builder.get();
        if (updatePlugins && !BootstrapClassLoaderUtil.isLoadingOfExternalPluginsDisabled()) {
            try {
                StartupActionScriptManager.executeActionScript();
            }
            catch (IOException e) {
                Main.showMessage("Plugin Installation Error", e);
            }
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)newClassLoader);
        UrlClassLoader urlClassLoader = newClassLoader;
        if (urlClassLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BootstrapClassLoaderUtil", "initClassLoader"));
        }
        return urlClassLoader;
    }

    private static void addParentClasspath(Collection<URL> classpath, boolean ext) throws MalformedURLException {
        if (!SystemInfo.IS_AT_LEAST_JAVA9) {
            String[] extDirs = System.getProperty("java.ext.dirs", "").split(File.pathSeparator);
            if (ext && extDirs.length == 0) {
                return;
            }
            ArrayList<URLClassLoader> loaders = new ArrayList<URLClassLoader>(2);
            for (ClassLoader loader = BootstrapClassLoaderUtil.class.getClassLoader(); loader != null; loader = loader.getParent()) {
                if (loader instanceof URLClassLoader) {
                    loaders.add(0, (URLClassLoader)loader);
                    continue;
                }
                BootstrapClassLoaderUtil.getLogger().warn("Unknown class loader: " + loader.getClass().getName());
            }
            for (URLClassLoader loader : loaders) {
                URL[] urls;
                for (URL url : urls = loader.getURLs()) {
                    String path = BootstrapClassLoaderUtil.urlToPath(url);
                    boolean isExt = false;
                    for (String extDir : extDirs) {
                        if (!path.startsWith(extDir) || path.length() <= extDir.length() || path.charAt(extDir.length()) != File.separatorChar) continue;
                        isExt = true;
                        break;
                    }
                    if (isExt != ext) continue;
                    classpath.add(url);
                }
            }
        } else if (!ext) {
            BootstrapClassLoaderUtil.parseClassPathString(ManagementFactory.getRuntimeMXBean().getClassPath(), classpath);
        }
    }

    private static String urlToPath(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI().getSchemeSpecificPart()).getPath();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(url.toString());
        }
    }

    private static void addIDEALibraries(Collection<URL> classpath) throws MalformedURLException {
        Class<BootstrapClassLoaderUtil> aClass = BootstrapClassLoaderUtil.class;
        String selfRoot = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
        assert (selfRoot != null);
        URL selfRootUrl = new File(selfRoot).getAbsoluteFile().toURI().toURL();
        classpath.add(selfRootUrl);
        File libFolder = new File(PathManager.getLibPath());
        BootstrapClassLoaderUtil.addLibraries(classpath, libFolder, selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, new File(libFolder, "ext"), selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, new File(libFolder, "ant/lib"), selfRootUrl);
    }

    private static void addLibraries(Collection<URL> classPath, File fromDir, URL selfRootUrl) throws MalformedURLException {
        File[] files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            URL url;
            if (!FileUtil.isJarOrZip((File)file) || selfRootUrl.equals(url = file.toURI().toURL())) continue;
            classPath.add(url);
        }
    }

    private static void addAdditionalClassPath(Collection<URL> classpath) {
        BootstrapClassLoaderUtil.parseClassPathString(System.getProperty(PROPERTY_ADDITIONAL_CLASSPATH), classpath);
    }

    private static void parseClassPathString(String pathString, Collection<URL> classpath) {
        if (pathString != null && !pathString.isEmpty()) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(pathString, File.pathSeparator + ',', false);
                while (tokenizer.hasMoreTokens()) {
                    String pathItem = tokenizer.nextToken();
                    classpath.add(new File(pathItem).toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                BootstrapClassLoaderUtil.getLogger().error((Throwable)e);
            }
        }
    }

    private static List<URL> filterClassPath(List<URL> classpath) {
        String ignoreProperty = System.getProperty(PROPERTY_IGNORE_CLASSPATH);
        if (ignoreProperty != null) {
            Pattern pattern = Pattern.compile(ignoreProperty);
            Iterator<URL> i = classpath.iterator();
            while (i.hasNext()) {
                String url = i.next().toExternalForm();
                if (!pattern.matcher(url).matches()) continue;
                i.remove();
            }
        }
        return classpath;
    }
}

