/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.dombl.ModelNode;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLAnchorElementImpl;
import org.lobobrowser.html.domimpl.HTMLButtonElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLInputElementImpl;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.jsimpl.KeyboardEventImpl;
import org.lobobrowser.html.jsimpl.MouseEventImpl;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.mozilla.javascript.Function;

public class HtmlController {
    private static final Logger logger = Logger.getLogger(HtmlController.class.getName());
    private static final HtmlController instance;

    public static HtmlController getInstance() {
        return instance;
    }

    public boolean onEnterPressed(ModelNode node, InputEvent event) {
        HTMLInputElementImpl hie;
        if (node instanceof HTMLInputElementImpl && (hie = (HTMLInputElementImpl)node).isSubmittableWithEnterKey()) {
            hie.submitForm(null);
            return false;
        }
        return false;
    }

    public boolean onMouseClick(ModelNode node, MouseEvent event, RBlockViewport bodyLayout, int x, int y) {
        ModelNode parent;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onMouseClick(): node=" + node + ",class=" + node.getClass().getName());
        }
        if (node instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl uiDoc = (HTMLDocumentImpl)node;
            Function f = uiDoc.getOnclick();
            if (f != null && bodyLayout == null) {
                if (!Executor.executeFunction(uiDoc, f, null)) {
                    return false;
                }
            } else if (f == null && bodyLayout != null) {
                if (!bodyLayout.onMouseClick(event, x - bodyLayout.x, y - bodyLayout.y)) {
                    return false;
                }
            } else if (f != null && bodyLayout != null) {
                boolean result = Executor.executeFunction(uiDoc, f, null);
                result = bodyLayout.onMouseClick(event, x - bodyLayout.x, y - bodyLayout.y);
                if (!result) {
                    return result;
                }
            }
        } else {
            if (node instanceof HTMLAnchorElementImpl) {
                ((HTMLAnchorElementImpl)node).navigate();
                return false;
            }
            if (node instanceof HTMLButtonElementImpl) {
                HTMLButtonElementImpl button = (HTMLButtonElementImpl)node;
                String rawType = button.getAttribute("type");
                String type = rawType == null ? "submit" : rawType.trim().toLowerCase();
                if ("submit".equals(type)) {
                    String name = button.getName();
                    FormInput[] formInputs = name == null ? null : new FormInput[]{new FormInput(name, button.getValue())};
                    button.submitForm(formInputs);
                } else if ("reset".equals(type)) {
                    button.resetForm();
                }
                return false;
            }
            if (node instanceof HTMLAbstractUIElement) {
                MouseEventImpl jsEvent;
                HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
                Function f = uiElement.getOnclick();
                if (f != null && !Executor.executeFunction(uiElement, f, jsEvent = new MouseEventImpl("click", uiElement, event, x, y))) {
                    return false;
                }
                HtmlRendererContext rcontext = uiElement.getHtmlRendererContext();
                if (rcontext != null && !rcontext.onMouseClick(uiElement, event)) {
                    return false;
                }
            }
        }
        if ((parent = node.getParentModelNode()) == null) {
            return true;
        }
        return this.onMouseClick(parent, event, null, x, y);
    }

    public boolean onContextMenu(ModelNode node, MouseEvent event, int x, int y) {
        ModelNode parent;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onContextMenu(): node=" + node + ",class=" + node.getClass().getName());
        }
        if (node instanceof HTMLAbstractUIElement) {
            MouseEventImpl jsEvent;
            HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
            Function f = uiElement.getOncontextmenu();
            if (f != null && !Executor.executeFunction(uiElement, f, jsEvent = new MouseEventImpl("contextmenu", uiElement, event, x, y))) {
                return false;
            }
            HtmlRendererContext rcontext = uiElement.getHtmlRendererContext();
            if (rcontext != null && !rcontext.onContextMenu(uiElement, event)) {
                return false;
            }
        }
        if ((parent = node.getParentModelNode()) == null) {
            return true;
        }
        return this.onContextMenu(parent, event, x, y);
    }

    public void onMouseOver(ModelNode node, MouseEvent event, int x, int y, ModelNode limit) {
        while (node != null && node != limit) {
            Function f;
            if (node instanceof HTMLDocumentImpl) {
                HTMLDocumentImpl uiDoc = (HTMLDocumentImpl)node;
                f = uiDoc.getOnmouseover();
                Executor.executeFunction(uiDoc, f, null);
            } else if (node instanceof HTMLAbstractUIElement) {
                HtmlRendererContext rcontext;
                HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
                uiElement.setMouseOver(true);
                f = uiElement.getOnmouseover();
                if (f != null) {
                    MouseEventImpl jsEvent = new MouseEventImpl("mouseover", uiElement, event, x, y);
                    Executor.executeFunction(uiElement, f, jsEvent);
                }
                if ((rcontext = uiElement.getHtmlRendererContext()) != null) {
                    rcontext.onMouseOver(uiElement, event);
                }
            }
            node = node.getParentModelNode();
        }
    }

    public void onMouseOut(ModelNode node, MouseEvent event, int x, int y, ModelNode limit) {
        while (node != null && node != limit) {
            if (node instanceof HTMLAbstractUIElement) {
                HtmlRendererContext rcontext;
                HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
                uiElement.setMouseOver(false);
                Function f = uiElement.getOnmouseout();
                if (f != null) {
                    MouseEventImpl jsEvent = new MouseEventImpl("mouseout", uiElement, event, x, y);
                    Executor.executeFunction(uiElement, f, jsEvent);
                }
                if ((rcontext = uiElement.getHtmlRendererContext()) != null) {
                    rcontext.onMouseOut(uiElement, event);
                }
            }
            node = node.getParentModelNode();
        }
    }

    public boolean onDoubleClick(ModelNode node, MouseEvent event, RBlockViewport bodyLayout, int x, int y) {
        ModelNode parent;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onDoubleClick(): node=" + node + ",class=" + node.getClass().getName());
        }
        if (node instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl uiDoc = (HTMLDocumentImpl)node;
            Function f = uiDoc.getOndblclick();
            if (f != null && bodyLayout == null) {
                if (!Executor.executeFunction(uiDoc, f, null)) {
                    return false;
                }
            } else if (f == null && bodyLayout != null) {
                if (!bodyLayout.onDoubleClick(event, x - bodyLayout.x, y - bodyLayout.y)) {
                    return false;
                }
            } else if (f != null && bodyLayout != null) {
                boolean result = Executor.executeFunction(uiDoc, f, null);
                result = bodyLayout.onDoubleClick(event, x - bodyLayout.x, y - bodyLayout.y);
                if (!result) {
                    return result;
                }
            }
        } else if (node instanceof HTMLAbstractUIElement) {
            MouseEventImpl jsEvent;
            HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
            Function f = uiElement.getOndblclick();
            if (f != null && !Executor.executeFunction(uiElement, f, jsEvent = new MouseEventImpl("dblclick", uiElement, event, x, y))) {
                return false;
            }
            HtmlRendererContext rcontext = uiElement.getHtmlRendererContext();
            if (rcontext != null && !rcontext.onDoubleClick(uiElement, event)) {
                return false;
            }
        }
        if ((parent = node.getParentModelNode()) == null) {
            return true;
        }
        return this.onDoubleClick(parent, event, null, x, y);
    }

    public boolean onMouseDisarmed(ModelNode node, MouseEvent event) {
        if (node instanceof HTMLAnchorElementImpl) {
            ((HTMLAnchorElementImpl)node).getCurrentStyle().setOverlayColor(null);
            return false;
        }
        ModelNode parent = node.getParentModelNode();
        if (parent == null) {
            return true;
        }
        return this.onMouseDisarmed(parent, event);
    }

    public boolean onMouseDown(ModelNode node, MouseEvent event, RBlock block, int x, int y) {
        HTMLAbstractUIElement uiElement;
        Function f;
        boolean pass = true;
        if (node instanceof HTMLDocumentImpl) {
            if (block != null) {
                RBlockViewport bodyLayout = block.bodyLayout;
                int newX = 0;
                int newY = 0;
                HTMLDocumentImpl uiDoc = (HTMLDocumentImpl)node;
                Function f2 = uiDoc.getOnmousedown();
                if (f2 != null && bodyLayout == null) {
                    block.setArmedRenderable(null);
                    if (!Executor.executeFunction(uiDoc, f2, null)) {
                        return false;
                    }
                } else if (f2 == null && bodyLayout != null) {
                    newX = x - bodyLayout.x;
                    newY = y - bodyLayout.y;
                    if (bodyLayout.contains(newX, newY)) {
                        block.setArmedRenderable(bodyLayout);
                        if (!bodyLayout.onMousePressed(event, newX, newY)) {
                            return false;
                        }
                    } else {
                        block.setArmedRenderable(null);
                    }
                } else if (f2 != null && bodyLayout != null) {
                    boolean result = Executor.executeFunction(uiDoc, f2, null);
                    newX = x - bodyLayout.x;
                    newY = y - bodyLayout.y;
                    if (bodyLayout.contains(newX, newY)) {
                        block.setArmedRenderable(bodyLayout);
                        result = bodyLayout.onMousePressed(event, newX, newY);
                    } else {
                        block.setArmedRenderable(null);
                    }
                    if (!result) {
                        return result;
                    }
                }
            }
        } else if (node instanceof HTMLAbstractUIElement && (f = (uiElement = (HTMLAbstractUIElement)node).getOnmousedown()) != null) {
            MouseEventImpl jsEvent = new MouseEventImpl("mousedown", uiElement, event, x, y);
            pass = Executor.executeFunction(uiElement, f, jsEvent);
        }
        if (node instanceof HTMLAnchorElementImpl) {
            ((HTMLAnchorElementImpl)node).getCurrentStyle().setOverlayColor("#9090FF80");
            return false;
        }
        if (!pass) {
            return false;
        }
        ModelNode parent = node.getParentModelNode();
        if (parent == null) {
            return true;
        }
        return this.onMouseDown(parent, event, null, x, y);
    }

    public boolean onMouseUp(ModelNode node, MouseEvent event, RBlock block, int x, int y) {
        HTMLAbstractUIElement uiElement;
        Function f;
        boolean pass = true;
        if (node instanceof HTMLDocumentImpl) {
            if (block != null) {
                RBlockViewport bodyLayout = block.bodyLayout;
                int newX = 0;
                int newY = 0;
                HTMLDocumentImpl uiDoc = (HTMLDocumentImpl)node;
                Function f2 = uiDoc.getOnmouseup();
                if (f2 != null && bodyLayout == null) {
                    block.setArmedRenderable(null);
                    if (!Executor.executeFunction(uiDoc, f2, null)) {
                        return false;
                    }
                } else if (f2 == null && bodyLayout != null) {
                    newX = x - bodyLayout.x;
                    newY = y - bodyLayout.y;
                    if (bodyLayout.contains(newX, newY)) {
                        block.setArmedRenderable(bodyLayout);
                        if (!bodyLayout.onMouseReleased(event, newX, newY)) {
                            return false;
                        }
                    } else {
                        block.setArmedRenderable(null);
                    }
                } else if (f2 != null && bodyLayout != null) {
                    boolean result = Executor.executeFunction(uiDoc, f2, null);
                    newX = x - bodyLayout.x;
                    newY = y - bodyLayout.y;
                    if (bodyLayout.contains(newX, newY)) {
                        block.setArmedRenderable(bodyLayout);
                        result = bodyLayout.onMouseReleased(event, newX, newY);
                    } else {
                        block.setArmedRenderable(null);
                    }
                    if (!result) {
                        return result;
                    }
                }
            }
        } else if (node instanceof HTMLAbstractUIElement && (f = (uiElement = (HTMLAbstractUIElement)node).getOnmouseup()) != null) {
            MouseEventImpl jsEvent = new MouseEventImpl("mouseup", uiElement, event, x, y);
            pass = Executor.executeFunction(uiElement, f, jsEvent);
        }
        if (node instanceof HTMLAnchorElementImpl) {
            ((HTMLAnchorElementImpl)node).getCurrentStyle().setOverlayColor(null);
            return false;
        }
        if (!pass) {
            return false;
        }
        ModelNode parent = node.getParentModelNode();
        if (parent == null) {
            return true;
        }
        return this.onMouseUp(parent, event, null, x, y);
    }

    public boolean onPressed(ModelNode node, InputEvent event, int x, int y) {
        MouseEventImpl jsEvent;
        HTMLAbstractUIElement uiElement;
        Function f;
        if (node instanceof HTMLAbstractUIElement && (f = (uiElement = (HTMLAbstractUIElement)node).getOnclick()) != null && !Executor.executeFunction(uiElement, f, jsEvent = new MouseEventImpl("click", uiElement, event, x, y))) {
            return false;
        }
        if (node instanceof HTMLInputElementImpl) {
            HTMLInputElementImpl hie = (HTMLInputElementImpl)node;
            if (hie.isSubmitInput()) {
                String name = hie.getName();
                FormInput[] formInputs = name == null ? null : new FormInput[]{new FormInput(name, hie.getValue())};
                hie.submitForm(formInputs);
            } else if (hie.isImageInput()) {
                String name = hie.getName();
                String prefix = name == null ? "" : name + ".";
                FormInput[] extraFormInputs = new FormInput[]{new FormInput(prefix + "x", String.valueOf(x)), new FormInput(prefix + "y", String.valueOf(y))};
                hie.submitForm(extraFormInputs);
            } else if (hie.isResetInput()) {
                hie.resetForm();
            }
        }
        return false;
    }

    public boolean onChange(ModelNode node) {
        MouseEventImpl jsEvent;
        HTMLSelectElementImpl uiElement;
        Function f;
        if (node instanceof HTMLSelectElementImpl && (f = (uiElement = (HTMLSelectElementImpl)node).getOnchange()) != null && !Executor.executeFunction(uiElement, f, jsEvent = new MouseEventImpl("change", uiElement))) {
            return false;
        }
        return false;
    }

    public boolean onKeyDown(ModelNode node, KeyEvent event) {
        KeyboardEventImpl jsEvent;
        HTMLInputElementImpl uiElement;
        Function f;
        HTMLDocumentImpl uiDoc;
        if (node instanceof HTMLDocumentImpl ? !Executor.executeFunction(uiDoc = (HTMLDocumentImpl)node, f = uiDoc.getOnkeydown(), null) : node instanceof HTMLInputElementImpl && (f = (uiElement = (HTMLInputElementImpl)node).getOnkeydown()) != null && !Executor.executeFunction(uiElement, f, jsEvent = new KeyboardEventImpl("keydown", uiElement, event))) {
            return false;
        }
        return false;
    }

    public boolean onKeyPress(ModelNode node, KeyEvent event) {
        KeyboardEventImpl jsEvent;
        HTMLInputElementImpl uiElement;
        Function f;
        HTMLDocumentImpl uiDoc;
        if (node instanceof HTMLDocumentImpl ? !Executor.executeFunction(uiDoc = (HTMLDocumentImpl)node, f = uiDoc.getOnkeypress(), null) : node instanceof HTMLInputElementImpl && (f = (uiElement = (HTMLInputElementImpl)node).getOnkeypress()) != null && !Executor.executeFunction(uiElement, f, jsEvent = new KeyboardEventImpl("keypress", uiElement, event))) {
            return false;
        }
        return false;
    }

    public boolean onKeyUp(ModelNode node, KeyEvent event) {
        KeyboardEventImpl jsEvent;
        HTMLInputElementImpl uiElement;
        Function f;
        HTMLDocumentImpl uiDoc;
        if (node instanceof HTMLDocumentImpl ? !Executor.executeFunction(uiDoc = (HTMLDocumentImpl)node, f = uiDoc.getOnkeyup(), null) : node instanceof HTMLInputElementImpl && (f = (uiElement = (HTMLInputElementImpl)node).getOnkeyup()) != null && !Executor.executeFunction(uiElement, f, jsEvent = new KeyboardEventImpl("keyup", uiElement, event))) {
            return false;
        }
        return false;
    }

    static {
        logger.setLevel(Level.SEVERE);
        instance = new HtmlController();
    }
}

