/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.MappedCodePosition;
import com.intellij.javascript.trace.execution.code.StaticAnotherStatement;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticConditionalAlternate;
import com.intellij.javascript.trace.execution.code.StaticConditionalConsequent;
import com.intellij.javascript.trace.execution.code.StaticElementVisitor;
import com.intellij.javascript.trace.execution.code.StaticLogicalLeft;
import com.intellij.javascript.trace.execution.code.StaticLogicalRight;
import com.intellij.javascript.trace.execution.code.StaticReturn;
import com.intellij.javascript.trace.execution.code.StaticSwitch;
import com.intellij.javascript.trace.execution.code.StaticTest;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappedTraceVirtualFile
extends TraceVirtualFile {
    private static final Logger LOG = Logger.getInstance(MappedTraceVirtualFile.class);
    private final boolean myIsCoffeeScript;

    public MappedTraceVirtualFile(String url, String content, VirtualFile localFile, String streamId) {
        super(url, content, localFile, streamId);
        String extension = MappedTraceVirtualFile.getFileNameExtension(url);
        this.myIsCoffeeScript = "coffee".equals(extension);
        JavaScriptFileType fileType = extension != null ? FileTypeRegistry.getInstance().getFileTypeByExtension(extension) : JavaScriptFileType.INSTANCE;
        this.setFileType((FileType)fileType);
        if (fileType instanceof LanguageFileType && !JavaScriptFileType.INSTANCE.equals(fileType)) {
            this.setLanguage(((LanguageFileType)fileType).getLanguage());
        } else {
            this.setLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_6);
        }
        UsageTrigger.trigger((String)("spy.js.source.maps.use." + extension));
    }

    @Nullable
    private static String getFileNameExtension(String url) {
        String name = Utils.getFileNameWithExtension(url);
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1);
    }

    @Override
    @NotNull
    public TextRange getFunctionRange(@NotNull Editor editor, @NotNull RuntimeFunctionScope functionScope) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getFunctionRange"));
        }
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getFunctionRange"));
        }
        TextRange textRange = MappedTraceVirtualFile.findRange(editor, functionScope, (Function<PsiElement, PsiElement>)((Function)elementAtOffset -> {
            if (functionScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "lambda$getFunctionRange$1"));
            }
            if (functionScope.isProgram().booleanValue()) {
                return elementAtOffset.getContainingFile();
            }
            PsiElement function = PsiTreeUtil.findChildOfType((PsiElement)elementAtOffset.getParent(), JSFunction.class);
            return function != null ? function : PsiTreeUtil.findFirstParent((PsiElement)elementAtOffset, element -> element instanceof JSFunction);
        }));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getFunctionRange"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getStatementRange(final @NotNull Editor editor, @NotNull RuntimeFunctionScope functionScope, final @NotNull StaticCodeElement element) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getStatementRange"));
        }
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getStatementRange"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getStatementRange"));
        }
        if (this.myIsCoffeeScript && functionScope.getStatements().length == 1 && functionScope.isProgram().booleanValue()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getStatementRange"));
            }
            return textRange;
        }
        final TextRange[] range = new TextRange[]{TextRange.EMPTY_RANGE};
        StaticElementVisitor statementVisitor = new StaticElementVisitor(){

            @Override
            public void visit(StaticConditionalAlternate element2) {
                range[0] = MappedTraceVirtualFile.this.findLastExpressionRangeWithinBlockBeforeParentOfType(editor, element2, new Class[]{JSConditionalExpression.class, JSIfStatement.class});
            }

            @Override
            public void visit(StaticConditionalConsequent element2) {
                range[0] = MappedTraceVirtualFile.this.findLastExpressionRangeWithinBlockBeforeParentOfType(editor, element2, new Class[]{JSConditionalExpression.class, JSIfStatement.class});
            }

            @Override
            public void visit(StaticTest element2) {
                range[0] = MappedTraceVirtualFile.this.findLastExpressionRangeWithinBlockBeforeParentOfType(editor, element2, new Class[]{JSIfStatement.class, JSForStatement.class, JSDoWhileStatement.class, JSWhileStatement.class});
            }

            @Override
            public void visit(StaticSwitch element2) {
                range[0] = MappedTraceVirtualFile.this.findLastExpressionRangeWithinBlockBeforeParentOfType(editor, element2, new Class[]{JSSwitchStatement.class});
            }

            @Override
            public void visit(StaticLogicalLeft element2) {
                this.setLogicalExpressionPartRange();
            }

            @Override
            public void visit(StaticLogicalRight element2) {
                this.setLogicalExpressionPartRange();
            }

            @Override
            public void visit(StaticReturn element2) {
                this.setStandardStatementRange();
            }

            @Override
            public void visit(StaticAnotherStatement element2) {
                this.setStandardStatementRange();
            }

            private void setStandardStatementRange() {
                range[0] = MappedTraceVirtualFile.this.findParentWithinBlock(editor, element, (Condition<PsiElement>)element1 -> element1 instanceof JSStatement);
            }

            private void setLogicalExpressionPartRange() {
                range[0] = MappedTraceVirtualFile.this.findParentWithinBlock(editor, element, (Condition<PsiElement>)element12 -> {
                    PsiElement parent = element12.getParent();
                    if (parent == null) {
                        return false;
                    }
                    if (!(element12 instanceof JSExpression)) {
                        return false;
                    }
                    if (!(parent instanceof JSBinaryExpression)) {
                        return false;
                    }
                    JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
                    IElementType opType = binaryExpression.getOperationSign();
                    return JSTokenTypes.OROR == opType || JSTokenTypes.ANDAND == opType;
                });
            }
        };
        element.accept(statementVisitor);
        TextRange textRange = range[0];
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getStatementRange"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getReturnStatementRange(@NotNull Editor editor, @NotNull RuntimeReturnStatement returnStatement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getReturnStatementRange"));
        }
        if (returnStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getReturnStatementRange"));
        }
        TextRange returnRange = this.getReturnRange(editor, returnStatement, false);
        if (returnRange != TextRange.EMPTY_RANGE) {
            TextRange textRange = returnRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getReturnStatementRange"));
            }
            return textRange;
        }
        returnRange = this.getReturnRange(editor, returnStatement.getInReturnStatement(), true);
        if (returnRange != TextRange.EMPTY_RANGE) {
            TextRange textRange = returnRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getReturnStatementRange"));
            }
            return textRange;
        }
        TextRange textRange = this.getReturnRange(editor, returnStatement.getInReturnStatement(), false);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getReturnStatementRange"));
        }
        return textRange;
    }

    private TextRange findParentWithinBlock(Editor editor, CodeElement element, Condition<PsiElement> condition) {
        return MappedTraceVirtualFile.findRange(editor, element, (Function<PsiElement, PsiElement>)((Function)elementAtOffset -> MappedTraceVirtualFile.getFirstParent(elementAtOffset, condition, (Condition<PsiElement>)((Condition)element1 -> element1 instanceof JSBlockStatement || element1 instanceof JSFunction || this.myIsCoffeeScript && (element1 instanceof JSCatchBlock || element1 instanceof JSCaseClause)))));
    }

    private TextRange findLastExpressionRangeWithinBlockBeforeParentOfType(Editor editor, CodeElement element, Class ... classes) {
        return this.findParentWithinBlock(editor, element, (Condition<PsiElement>)((Condition)element1 -> (element1 instanceof JSExpression || this.myIsCoffeeScript && element1 instanceof JSExpressionStatement) && element1.getParent() != null && ContainerUtil.find((Object[])classes, aClass -> aClass.isAssignableFrom(element1.getParent().getClass())) != null));
    }

    private TextRange getReturnRange(Editor editor, RuntimeStatement returnStatement, boolean arrowFunction) {
        return this.findParentWithinBlock(editor, returnStatement, (Condition<PsiElement>)((Condition)element -> arrowFunction ? (element instanceof JSExpression || this.myIsCoffeeScript && element instanceof JSExpressionStatement) && element.getParent() != null && element.getParent() instanceof JSFunctionExpression : element instanceof JSReturnStatement || this.myIsCoffeeScript && element instanceof JSExpressionStatement));
    }

    @Override
    @NotNull
    public TextRange getParamRange(@NotNull Editor editor, @NotNull RuntimeFunctionArgument argument) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getParamRange"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getParamRange"));
        }
        TextRange textRange = MappedTraceVirtualFile.findRange(editor, argument, (Function<PsiElement, PsiElement>)((Function)elementAtOffset -> MappedTraceVirtualFile.getFirstParent(elementAtOffset, (Condition<PsiElement>)((Condition)element -> element instanceof JSParameter), (Condition<PsiElement>)((Condition)element -> element instanceof JSArgumentList))));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getParamRange"));
        }
        return textRange;
    }

    @Nullable
    private static PsiElement getFirstParent(@NotNull PsiElement start, @NotNull Condition<PsiElement> elementFinder, @NotNull Condition<PsiElement> limitChecker) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getFirstParent"));
        }
        if (elementFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFinder", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getFirstParent"));
        }
        if (limitChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limitChecker", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "getFirstParent"));
        }
        boolean[] foundMatch = new boolean[]{false};
        PsiElement foundElement = PsiTreeUtil.findFirstParent((PsiElement)start, element -> {
            if (elementFinder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFinder", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "lambda$getFirstParent$10"));
            }
            if (limitChecker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limitChecker", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "lambda$getFirstParent$10"));
            }
            boolean found = elementFinder.value(element);
            if (!found) {
                return limitChecker.value(element);
            }
            foundMatch[0] = true;
            return true;
        });
        return foundMatch[0] ? foundElement : null;
    }

    @NotNull
    private static TextRange findRange(@NotNull Editor editor, @NotNull CodeElement codeElement, @NotNull Function<PsiElement, PsiElement> psiElementLocator) {
        TextRange textRange;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "findRange"));
        }
        if (codeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeElement", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "findRange"));
        }
        if (psiElementLocator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementLocator", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "findRange"));
        }
        Project project = editor.getProject();
        if (project == null) {
            TextRange textRange2 = TextRange.EMPTY_RANGE;
            if (textRange2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "findRange"));
            }
            return textRange2;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            TextRange textRange3 = TextRange.EMPTY_RANGE;
            if (textRange3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "findRange"));
            }
            return textRange3;
        }
        Document document = editor.getDocument();
        CodeRange range = codeElement.getCodeRange();
        MappedCodePosition mappedCodePosition = range.getMappedCodePosition();
        if (mappedCodePosition == null) {
            TextRange textRange4 = TextRange.EMPTY_RANGE;
            if (textRange4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "findRange"));
            }
            return textRange4;
        }
        int rowStart = mappedCodePosition.getRow();
        int colStart = mappedCodePosition.getColumn();
        try {
            PsiElement elementAtOffset = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)(document.getLineStartOffset(rowStart - 1) + colStart));
            PsiElement psiElement = (PsiElement)psiElementLocator.fun((Object)elementAtOffset);
            textRange = psiElement == null ? TextRange.EMPTY_RANGE : psiElement.getTextRange();
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
            TextRange textRange5 = TextRange.EMPTY_RANGE;
            if (textRange5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "findRange"));
            }
            return textRange5;
        }
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile", "findRange"));
        }
        return textRange;
    }
}

