/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.view.RunConfigurationsListener;
import com.intellij.javaee.view.ServersConfigManager;
import com.intellij.javaee.view.ServersConfigManagerListener;
import com.intellij.javaee.view.tool.AppServerNode;
import com.intellij.javaee.view.tool.ArtifactSyncTrackerListener;
import com.intellij.javaee.view.tool.ServersDropTargetAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.TreeBuilderBase;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaeeServersViewContributor
extends RemoteServersViewContributor {
    public void setupAvailabilityListener(final @NotNull Project project, final @NotNull Runnable checkAvailability) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/view/JavaeeServersViewContributor", "setupAvailabilityListener"));
        }
        if (checkAvailability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkAvailability", "com/intellij/javaee/view/JavaeeServersViewContributor", "setupAvailabilityListener"));
        }
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunConfigurationsListener(){

            @Override
            protected void runConfigurationsChanged() {
                ApplicationManager.getApplication().invokeLater(checkAvailability, project.getDisposed());
            }
        });
    }

    public boolean canContribute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/view/JavaeeServersViewContributor", "canContribute"));
        }
        for (RunnerAndConfigurationSettings configuration : RunManager.getInstance((Project)project).getAllSettings()) {
            if (!(configuration.getConfiguration() instanceof CommonStrategy)) continue;
            return true;
        }
        return false;
    }

    public Object getData(@NotNull String dataId, @NotNull ServersToolWindowContent content) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/javaee/view/JavaeeServersViewContributor", "getData"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/javaee/view/JavaeeServersViewContributor", "getData"));
        }
        return null;
    }

    public void setupTree(final Project project, Tree tree, final TreeBuilderBase builder) {
        new DropTarget((Component)tree, new ServersDropTargetAdapter(tree, builder, project));
        final ServersConfigManager manager = ServersConfigManager.getInstance(project);
        manager.setListener(new ServersConfigManagerListener(){

            @Override
            public void serverProcessStateChanged(CommonStrategy server) {
                builder.queueUpdate();
            }

            @Override
            public void serverConnectStateChanged(CommonStrategy server) {
                builder.queueUpdate();
            }

            @Override
            public void serverDeploymentsQueued(CommonStrategy server) {
                builder.queueUpdate();
            }

            @Override
            public void deploymentStatusChangeNotified(CommonStrategy server, DeploymentModel model) {
                builder.queueUpdate();
            }
        });
        manager.getArtifactSyncTracker().setListener(new ArtifactSyncTrackerListener(){

            @Override
            public void artifactsUnsynced() {
                builder.queueUpdate();
            }
        });
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunConfigurationsListener(){

            @Override
            protected void runConfigurationsChanged() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    manager.getArtifactSyncTracker().updateServersList();
                    builder.queueUpdate();
                }, project.getDisposed());
            }
        });
    }

    @NotNull
    public List<AbstractTreeNode<?>> createServerNodes(Project project) {
        ArrayList result = new ArrayList();
        for (RunnerAndConfigurationSettings configuration : RunManager.getInstance((Project)project).getAllSettings()) {
            if (!(configuration.getConfiguration() instanceof CommonStrategy)) continue;
            result.add(new AppServerNode(project, configuration));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/JavaeeServersViewContributor", "createServerNodes"));
        }
        return arrayList;
    }
}

