/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

public class SimpleBinaryTransformation
extends BinaryTransformation {
    private final IElementType myOperator;

    public SimpleBinaryTransformation(@NotNull IElementType operatorType) {
        if (operatorType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operatorType", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/SimpleBinaryTransformation", "<init>"));
        }
        this.myOperator = operatorType;
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/SimpleBinaryTransformation", "apply"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/SimpleBinaryTransformation", "apply"));
        }
        GrExpression rhs = this.getRhs(methodCall);
        rhs = ParenthesesUtils.checkPrecedenceForBinaryOps(ParenthesesUtils.getPrecedence(rhs), this.myOperator, true) ? ParenthesesUtils.parenthesize(rhs) : rhs;
        GrInspectionUtil.replaceExpression(methodCall, String.format("%s %s %s", this.getLhs(methodCall).getText(), this.myOperator.toString(), rhs.getText()));
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/SimpleBinaryTransformation", "needParentheses"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/SimpleBinaryTransformation", "needParentheses"));
        }
        GrExpression rhs = this.getRhs(methodCall);
        int rhsPrecedence = ParenthesesUtils.getPrecedence(rhs);
        return ParenthesesUtils.checkPrecedenceForBinaryOps(rhsPrecedence, this.myOperator, true) || ParenthesesUtils.checkPrecedence(ParenthesesUtils.precedenceForBinaryOperator(this.myOperator), (GrExpression)methodCall);
    }
}

