/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public abstract class Transformation {
    public boolean couldApply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "couldApply"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "couldApply"));
        }
        return this.couldApplyInternal(methodCall, options) && (!options.withoutAdditionalParentheses() || !this.needParentheses(methodCall, options));
    }

    protected abstract boolean couldApplyInternal(@NotNull GrMethodCall var1, @NotNull ChangeToOperatorInspection.Options var2);

    protected abstract boolean needParentheses(@NotNull GrMethodCall var1, @NotNull ChangeToOperatorInspection.Options var2);

    public abstract void apply(@NotNull GrMethodCall var1, @NotNull ChangeToOperatorInspection.Options var2);

    @Nullable
    public static GrExpression getBase(@NotNull GrMethodCall callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "getBase"));
        }
        GrExpression expression = callExpression.getInvokedExpression();
        GrReferenceExpression invokedExpression = (GrReferenceExpression)expression;
        GrExpression qualifier = invokedExpression.getQualifierExpression();
        if (PsiUtilKt.isSuperExpression(qualifier)) {
            return null;
        }
        return qualifier;
    }

    public boolean checkArgumentsCount(@NotNull GrMethodCall callExpression, int count) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "checkArgumentsCount"));
        }
        if (callExpression.getNamedArguments().length != 0) {
            return false;
        }
        return callExpression.getExpressionArguments().length + callExpression.getClosureArguments().length == count;
    }

    @NotNull
    public GrExpression getArgument(@NotNull GrMethodCall callExpression, int index) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "getArgument"));
        }
        GrExpression[] expressionArguments = callExpression.getExpressionArguments();
        if (index < expressionArguments.length) {
            GrExpression grExpression = expressionArguments[index];
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "getArgument"));
            }
            return grExpression;
        }
        GrClosableBlock grClosableBlock = callExpression.getClosureArguments()[index - expressionArguments.length];
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "getArgument"));
        }
        return grClosableBlock;
    }
}

