/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.console.ConsoleRootType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.actions.GrExecuteCommandAction;

public final class GroovyConsoleRootType
extends ConsoleRootType {
    public static final AnAction EXECUTE_ACTION = new GrExecuteCommandAction();
    public static final String CONTENT_ID = "groovy_console";

    @NotNull
    public static GroovyConsoleRootType getInstance() {
        GroovyConsoleRootType groovyConsoleRootType = (GroovyConsoleRootType)GroovyConsoleRootType.findByClass(GroovyConsoleRootType.class);
        if (groovyConsoleRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "getInstance"));
        }
        return groovyConsoleRootType;
    }

    public GroovyConsoleRootType() {
        super("groovy", "Groovy consoles");
    }

    @NotNull
    public String getDefaultFileExtension() {
        if ("groovy" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "getDefaultFileExtension"));
        }
        return "groovy";
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "isIgnored"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "isIgnored"));
        }
        return !GroovyConsoleStateService.getInstance(project).isProjectConsole(element);
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "getContentPathName"));
        }
        assert (id == CONTENT_ID);
        if (CONTENT_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "getContentPathName"));
        }
        return CONTENT_ID;
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "substituteName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "substituteName"));
        }
        String name = file.getName();
        String moduleTitle = GroovyConsoleStateService.getInstance(project).getSelectedModuleTitle(file);
        return name.startsWith(CONTENT_ID) ? StringUtil.replace((String)name, (String)CONTENT_ID, (String)(moduleTitle == null ? "unknown" : moduleTitle)) : String.format("%s-%s", moduleTitle, name);
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "fileOpened"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType", "fileOpened"));
        }
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            EXECUTE_ACTION.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, fileEditor.getComponent());
        }
    }
}

