/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.CompoundStringExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.PrimaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class PathExpression {
    private static final TokenSet DOTS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSPREAD_DOT, GroovyTokenTypes.mOPTIONAL_DOT, GroovyTokenTypes.mMEMBER_POINTER, GroovyTokenTypes.mDOT});
    private static final TokenSet PATH_ELEMENT_START = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSPREAD_DOT, GroovyTokenTypes.mOPTIONAL_DOT, GroovyTokenTypes.mMEMBER_POINTER, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mDOT});

    public static boolean parse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parse"));
        }
        return PathExpression.parsePathExprQualifierForExprStatement(builder, parser) != Result.WRONG_WAY;
    }

    @NotNull
    public static Result parsePathExprQualifierForExprStatement(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parsePathExprQualifierForExprStatement"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parsePathExprQualifierForExprStatement"));
        }
        PsiBuilder.Marker marker = builder.mark();
        IElementType qualifierType = PrimaryExpression.parsePrimaryExpression(builder, parser);
        if (qualifierType != GroovyElementTypes.WRONGWAY) {
            Result result = PathExpression.parseAfterQualifier(builder, parser, marker, qualifierType);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parsePathExprQualifierForExprStatement"));
            }
            return result;
        }
        marker.drop();
        Result result = Result.WRONG_WAY;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parsePathExprQualifierForExprStatement"));
        }
        return result;
    }

    @NotNull
    private static Result parseAfterQualifier(@NotNull PsiBuilder builder, @NotNull GroovyParser parser, @NotNull PsiBuilder.Marker marker, @NotNull IElementType qualifierType) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        if (PathExpression.isPathElementStart(builder)) {
            if (PathExpression.isLParenthOrLCurlyAfterLiteral(builder, qualifierType)) {
                marker.rollbackTo();
                PsiBuilder.Marker newMarker = builder.mark();
                IElementType newQualifierType = PrimaryExpression.parsePrimaryExpression(builder, parser, true);
                assert (newQualifierType != GroovyElementTypes.WRONGWAY);
                Result result = PathExpression.parseAfterReference(builder, parser, newMarker);
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
                }
                return result;
            }
            Result result = PathExpression.parseAfterReference(builder, parser, marker);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
            }
            return result;
        }
        marker.drop();
        if (qualifierType == GroovyElementTypes.LITERAL) {
            Result result = Result.LITERAL;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
            }
            return result;
        }
        Result result = Result.INVOKED_EXPR;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        return result;
    }

    private static boolean isLParenthOrLCurlyAfterLiteral(@NotNull PsiBuilder builder, @NotNull IElementType qualifierType) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "isLParenthOrLCurlyAfterLiteral"));
        }
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "isLParenthOrLCurlyAfterLiteral"));
        }
        return qualifierType == GroovyElementTypes.LITERAL && (PathExpression.checkForLParenth(builder) || PathExpression.checkForLCurly(builder));
    }

    @NotNull
    private static Result pathElementParse(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @NotNull GroovyParser parser, @NotNull Result result) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        if (PathExpression.parseQualificationDot(builder)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            TypeArguments.parseTypeArguments(builder, true);
            GroovyElementType res = PathExpression.namePartParse(builder, parser);
            if (res != GroovyElementTypes.WRONGWAY) {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done((IElementType)res);
                Result result2 = PathExpression.parseAfterReference(builder, parser, newMarker);
                if (result2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
                }
                return result2;
            }
            builder.error(GroovyBundle.message("path.selector.expected", new Object[0]));
            marker.drop();
            Result result3 = result;
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
            }
            return result3;
        }
        if (PathExpression.checkForLParenth(builder)) {
            PrimaryExpression.methodCallArgsParse(builder, parser);
            Result result4 = PathExpression.parseAfterArguments(builder, marker, parser);
            if (result4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
            }
            return result4;
        }
        if (PathExpression.checkForLCurly(builder)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            PathExpression.appendedBlockParse(builder, parser);
            Result result5 = PathExpression.parseAfterArguments(builder, marker, parser);
            if (result5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
            }
            return result5;
        }
        if (PathExpression.checkForArrayAccess(builder)) {
            PathExpression.indexPropertyArgsParse(builder, parser);
            PsiBuilder.Marker newMarker = marker.precede();
            marker.done((IElementType)GroovyElementTypes.PATH_INDEX_PROPERTY);
            Result result6 = PathExpression.parseAfterReference(builder, parser, newMarker);
            if (result6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
            }
            return result6;
        }
        marker.drop();
        Result result7 = result;
        if (result7 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        return result7;
    }

    private static boolean parseQualificationDot(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseQualificationDot"));
        }
        return ParserUtils.getToken(builder, DOTS) || ParserUtils.getToken(builder, GroovyTokenTypes.mNLS, DOTS);
    }

    public static boolean isQualificationDotAhead(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "isQualificationDotAhead"));
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        boolean result = PathExpression.parseQualificationDot(builder);
        mark.rollbackTo();
        return result;
    }

    public static boolean isQualificationDot(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "isQualificationDot"));
        }
        return DOTS.contains(builder.getTokenType()) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, DOTS);
    }

    @NotNull
    private static Result parseAfterReference(@NotNull PsiBuilder builder, @NotNull GroovyParser parser, @NotNull PsiBuilder.Marker newMarker) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
        }
        if (newMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMarker", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
        }
        if (PathExpression.checkForLCurly(builder)) {
            PsiBuilder.Marker argsMarker = builder.mark();
            argsMarker.done((IElementType)GroovyElementTypes.ARGUMENTS);
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            Result result = PathExpression.pathElementParse(builder, newMarker, parser, Result.METHOD_CALL);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
            }
            return result;
        }
        Result result = PathExpression.pathElementParse(builder, newMarker, parser, Result.INVOKED_EXPR);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
        }
        return result;
    }

    @NotNull
    private static Result parseAfterArguments(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
        }
        if (PathExpression.checkForLCurly(builder)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            Result result = PathExpression.pathElementParse(builder, marker, parser, Result.METHOD_CALL);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
            }
            return result;
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)GroovyElementTypes.PATH_METHOD_CALL);
        Result result = PathExpression.pathElementParse(builder, newMarker, parser, Result.METHOD_CALL);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
        }
        return result;
    }

    private static boolean checkForLCurly(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "checkForLCurly"));
        }
        return ParserUtils.lookAhead(builder, GroovyTokenTypes.mLCURLY) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mLCURLY);
    }

    private static boolean checkForLParenth(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "checkForLParenth"));
        }
        return builder.getTokenType() == GroovyTokenTypes.mLPAREN;
    }

    public static boolean checkForArrayAccess(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "checkForArrayAccess"));
        }
        return builder.getTokenType() == GroovyTokenTypes.mLBRACK && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mCOLON) && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mNLS, GroovyTokenTypes.mCOLON);
    }

    @NotNull
    public static GroovyElementType namePartParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mAT);
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT) || ParserUtils.getToken(builder, GroovyTokenTypes.mSTRING_LITERAL) || ParserUtils.getToken(builder, GroovyTokenTypes.mGSTRING_LITERAL)) {
            GroovyElementType groovyElementType = GroovyElementTypes.REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        IElementType tokenType = builder.getTokenType();
        if (tokenType == GroovyTokenTypes.mGSTRING_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, null, GroovyElementTypes.GSTRING, GroovyBundle.message("string.end.expected", new Object[0]));
            GroovyElementType groovyElementType = result ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (tokenType == GroovyTokenTypes.mREGEX_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mREGEX_LITERAL, GroovyElementTypes.REGEX, GroovyBundle.message("regex.end.expected", new Object[0]));
            GroovyElementType groovyElementType = result ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL, GroovyElementTypes.REGEX, GroovyBundle.message("dollar.slash.end.expected", new Object[0]));
            GroovyElementType groovyElementType = result ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (tokenType == GroovyTokenTypes.mLCURLY) {
            OpenOrClosableBlock.parseOpenBlock(builder, parser);
            GroovyElementType groovyElementType = GroovyElementTypes.PATH_PROPERTY_REFERENCE;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (tokenType == GroovyTokenTypes.mLPAREN) {
            PrimaryExpression.parenthesizedExprParse(builder, parser);
            GroovyElementType groovyElementType = GroovyElementTypes.PATH_PROPERTY_REFERENCE;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (TokenSets.KEYWORDS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            GroovyElementType groovyElementType = GroovyElementTypes.REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        GroovyElementType groovyElementType = GroovyElementTypes.WRONGWAY;
        if (groovyElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
        }
        return groovyElementType;
    }

    @NotNull
    public static GroovyElementType indexPropertyArgsParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "indexPropertyArgsParse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "indexPropertyArgsParse"));
        }
        assert (builder.getTokenType() == GroovyTokenTypes.mLBRACK);
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mLBRACK);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ArgumentList.parseArgumentList(builder, GroovyTokenTypes.mRBRACK, parser);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
        marker.done((IElementType)GroovyElementTypes.ARGUMENTS);
        GroovyElementType groovyElementType = GroovyElementTypes.PATH_INDEX_PROPERTY;
        if (groovyElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "indexPropertyArgsParse"));
        }
        return groovyElementType;
    }

    @NotNull
    private static IElementType appendedBlockParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "appendedBlockParse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "appendedBlockParse"));
        }
        IElementType iElementType = OpenOrClosableBlock.parseClosableBlock(builder, parser);
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "appendedBlockParse"));
        }
        return iElementType;
    }

    private static boolean isPathElementStart(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "isPathElementStart"));
        }
        if (PATH_ELEMENT_START.contains(builder.getTokenType())) {
            return true;
        }
        PsiBuilder.Marker marker = builder.mark();
        try {
            boolean bl = ParserUtils.getToken(builder, GroovyTokenTypes.mNLS) && (ParserUtils.getToken(builder, TokenSets.DOTS) || ParserUtils.getToken(builder, GroovyTokenTypes.mLCURLY));
            return bl;
        }
        finally {
            marker.rollbackTo();
        }
    }

    public static enum Result {
        INVOKED_EXPR,
        METHOD_CALL,
        WRONG_WAY,
        LITERAL;

    }
}

