/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrRangeType
extends GrLiteralClassType {
    @Nullable
    private final PsiType myLeft;
    @Nullable
    private final PsiType myRight;
    private final PsiType myIterationType;
    private final String myQualifiedName;
    private final PsiType[] myParameters;

    public GrRangeType(LanguageLevel languageLevel, GlobalSearchScope scope, JavaPsiFacade facade, @Nullable PsiType left, @Nullable PsiType right) {
        super(languageLevel, scope, facade);
        this.myLeft = left;
        this.myRight = right;
        this.myIterationType = TypesUtil.boxPrimitiveType(TypesUtil.getLeastUpperBoundNullable(this.myLeft, this.myRight, this.getPsiManager()), this.getPsiManager(), scope);
        this.myQualifiedName = PsiType.INT.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(this.myIterationType)) ? "groovy.lang.IntRange" : "groovy.lang.Range";
        this.myParameters = this.inferParameters();
    }

    public GrRangeType(GlobalSearchScope scope, JavaPsiFacade facade, @Nullable PsiType left, @Nullable PsiType right) {
        this(LanguageLevel.JDK_1_5, scope, facade, left, right);
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrRangeType", "getJavaClassName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = StringUtil.getShortName((String)this.myQualifiedName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrRangeType", "getClassName"));
        }
        return string;
    }

    @NotNull
    public PsiType[] getParameters() {
        if (this.myParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrRangeType", "getParameters"));
        }
        return this.myParameters;
    }

    private PsiType[] inferParameters() {
        if (this.myIterationType == null) {
            return EMPTY_ARRAY;
        }
        PsiClass resolved = this.resolve();
        if (resolved == null || resolved.getTypeParameters().length == 0) {
            return EMPTY_ARRAY;
        }
        return new PsiType[]{this.myIterationType};
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/plugins/groovy/lang/psi/impl/GrRangeType", "setLanguageLevel"));
        }
        GrRangeType grRangeType = new GrRangeType(languageLevel, this.myScope, this.myFacade, this.myLeft, this.myRight);
        if (grRangeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrRangeType", "setLanguageLevel"));
        }
        return grRangeType;
    }

    @NotNull
    public String getInternalCanonicalText() {
        String string = "[" + (this.myLeft == null ? "null" : this.myLeft.getInternalCanonicalText()) + ".." + (this.myRight == null ? "null" : this.myRight.getInternalCanonicalText()) + "]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrRangeType", "getInternalCanonicalText"));
        }
        return string;
    }

    public boolean isValid() {
        return !(this.myLeft != null && !this.myLeft.isValid() || this.myRight != null && !this.myRight.isValid());
    }

    @Nullable
    public PsiType getIterationType() {
        return this.myIterationType;
    }

    @Nullable
    public PsiType getLeft() {
        return this.myLeft;
    }

    @Nullable
    public PsiType getRight() {
        return this.myRight;
    }
}

