/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.references;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CodeSetupPsiReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<PsiLiteral> ADD_FLOW_LOCATION = CodeSetupPsiReferenceContributor.createPattern("addFlowLocation");
    public static final PsiElementPattern.Capture<PsiLiteral> ADD_FLOW_LOCATION_PATTERN = CodeSetupPsiReferenceContributor.createPattern("addFlowLocationPattern");
    public static final PsiElementPattern.Capture<PsiLiteral> BASE_PATH = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiLiteral.class).with(SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION)).and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("setBasePath")).inClass("org.springframework.webflow.config.FlowDefinitionRegistryBuilder")));

    @NotNull
    private static PsiElementPattern.Capture<PsiLiteral> createPattern(String methodName) {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiLiteral.class).with(SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION)).and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(methodName)).inClass("org.springframework.webflow.config.FlowDefinitionRegistryBuilder")));
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor", "createPattern"));
        }
        return capture;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor", "registerReferenceProviders"));
        }
        PsiReferenceProvider flowLocationReferenceProvider = new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$1", "getReferencesByElement"));
                }
                String text = ElementManipulators.getValueText((PsiElement)element);
                SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)text).filter(item -> {
                    if (item.isDirectory()) {
                        return true;
                    }
                    PsiFile file = item.getContainingFile();
                    return JamCommonUtil.isPlainXmlFile((PsiElement)file) && WebflowDomModelManager.getInstance(item.getProject()).isWebflow((XmlFile)file);
                }).fromRoot(StringUtil.startsWithChar((CharSequence)text, (char)'/')).customDefaultPathEvaluator(CodeSetupPsiReferenceContributor.createBasePathEvaluator(element));
                PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(builder);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        };
        registrar.registerReferenceProvider(ADD_FLOW_LOCATION, flowLocationReferenceProvider, 100.0);
        registrar.registerReferenceProvider(ADD_FLOW_LOCATION_PATTERN, flowLocationReferenceProvider, 100.0);
        registrar.registerReferenceProvider(BASE_PATH, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$2", "getReferencesByElement"));
                }
                String text = ElementManipulators.getValueText((PsiElement)element);
                SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)text).filter(item -> item.isDirectory()).endingSlashNotAllowed(false).fromRoot(StringUtil.startsWithChar((CharSequence)text, (char)'/'));
                PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(builder);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, 100.0);
    }

    private static Function<PsiFile, Collection<PsiFileSystemItem>> createBasePathEvaluator(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor", "createBasePathEvaluator"));
        }
        return file -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor", "lambda$createBasePathEvaluator$0"));
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element.getOriginalElement().getParent(), PsiMethod.class);
            if (method == null) {
                return null;
            }
            for (PsiLiteral literal : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)method)).filter(PsiLiteral.class)) {
                if (!BASE_PATH.accepts((Object)literal)) continue;
                return SpringResourcesUtil.getInstance().getResourceItems(literal.getReferences(), Conditions.alwaysTrue());
            }
            return null;
        };
    }
}

