/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.dvlib.DeviceSchema;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.BluetoothProfile;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Meta;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.Network;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.ScreenType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import com.android.utils.XmlUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DeviceParser {
    private static final int MAX_FILE_LENGTH = 655360;
    private static final SAXParserFactory sParserFactory = SAXParserFactory.newInstance();

    public static Table<String, String, Device> parse(File devicesFile) throws SAXException, ParserConfigurationException, IOException {
        if (devicesFile.length() > 655360L) {
            throw new IOException(String.format("%s (%d B) is longer than limit (%d B)", devicesFile.getAbsolutePath(), devicesFile.length(), 655360));
        }
        FileInputStream stream = new FileInputStream(devicesFile);
        return DeviceParser.parseImpl(stream, devicesFile.getAbsoluteFile().getParentFile());
    }

    public static Table<String, String, Device> parse(InputStream devices) throws SAXException, IOException, ParserConfigurationException {
        return DeviceParser.parseImpl(devices, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Table<String, String, Device> parseImpl(InputStream devices, File parentDir) throws SAXException, IOException, ParserConfigurationException {
        try {
            if (!devices.markSupported()) {
                devices = new BufferedInputStream(devices);
            }
            devices.mark(655360);
            int version = DeviceSchema.getXmlSchemaVersion((InputStream)devices);
            SAXParser parser = DeviceParser.getParser(version);
            DeviceHandler dHandler = new DeviceHandler(parentDir);
            devices.reset();
            parser.parse(devices, (DefaultHandler)dHandler);
            Table<String, String, Device> table = dHandler.getDevices();
            return table;
        }
        finally {
            devices.close();
        }
    }

    private static SAXParser getParser(int version) throws ParserConfigurationException, SAXException {
        Schema schema = DeviceSchema.getSchema((int)version);
        if (schema != null) {
            sParserFactory.setSchema(schema);
        }
        return XmlUtils.createSaxParser((SAXParserFactory)sParserFactory);
    }

    static {
        XmlUtils.configureSaxFactory((SAXParserFactory)sParserFactory, (boolean)true, (boolean)false);
    }

    private static class DeviceHandler
    extends DefaultHandler {
        private static final Splitter sSpaceSplitter = Splitter.on((char)' ').omitEmptyStrings();
        private static final String ROUND_BOOT_PROP = "ro.emulator.circular";
        private static final String CHIN_BOOT_PROP = "ro.emu.win_outset_bottom_px";
        private final Table<String, String, Device> mDevices = HashBasedTable.create();
        private final StringBuilder mStringAccumulator = new StringBuilder();
        private final File mParentFolder;
        private Meta mMeta;
        private Hardware mHardware;
        private Software mSoftware;
        private State mState;
        private Device.Builder mBuilder;
        private Camera mCamera;
        private Storage.Unit mUnit;
        private String[] mBootProp;

        public DeviceHandler(File parentFolder) {
            this.mParentFolder = parentFolder;
        }

        public Table<String, String, Device> getDevices() {
            return this.mDevices;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("device".equals(localName)) {
                this.mMeta = null;
                this.mHardware = null;
                this.mSoftware = null;
                this.mState = null;
                this.mCamera = null;
                this.mBuilder = new Device.Builder();
            } else if ("meta".equals(localName)) {
                this.mMeta = new Meta();
            } else if ("hardware".equals(localName)) {
                this.mHardware = new Hardware();
            } else if ("software".equals(localName)) {
                this.mSoftware = new Software();
            } else if ("state".equals(localName)) {
                this.mState = new State();
                this.mHardware = this.mHardware.deepCopy();
                String defaultState = attributes.getValue("default");
                if ("true".equals(defaultState) || "1".equals(defaultState)) {
                    this.mState.setDefaultState(true);
                }
                this.mState.setName(attributes.getValue("name").trim());
            } else if ("camera".equals(localName)) {
                this.mCamera = new Camera();
            } else if ("ram".equals(localName) || "internal-storage".equals(localName) || "removable-storage".equals(localName)) {
                this.mUnit = Storage.Unit.getEnum(attributes.getValue("unit"));
            } else if ("frame".equals(localName)) {
                this.mMeta.setFrameOffsetLandscape(new Point());
                this.mMeta.setFrameOffsetPortrait(new Point());
            } else if ("screen".equals(localName)) {
                this.mHardware.setScreen(new Screen());
            } else if ("boot-prop".equals(localName)) {
                this.mBootProp = new String[2];
            }
            this.mStringAccumulator.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.mStringAccumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("device".equals(localName)) {
                Device device = this.mBuilder.build();
                this.mDevices.put((Object)device.getId(), (Object)device.getManufacturer(), (Object)device);
            } else if ("name".equals(localName)) {
                this.mBuilder.setName(DeviceHandler.getString(this.mStringAccumulator));
            } else if ("id".equals(localName)) {
                this.mBuilder.setId(DeviceHandler.getString(this.mStringAccumulator));
            } else if ("manufacturer".equals(localName)) {
                this.mBuilder.setManufacturer(DeviceHandler.getString(this.mStringAccumulator));
            } else if ("meta".equals(localName)) {
                this.mBuilder.setMeta(this.mMeta);
            } else if ("software".equals(localName)) {
                this.mBuilder.addSoftware(this.mSoftware);
            } else if ("state".equals(localName)) {
                this.mState.setHardware(this.mHardware);
                this.mBuilder.addState(this.mState);
            } else if ("sixty-four".equals(localName)) {
                this.mMeta.setIconSixtyFour(new File(this.mParentFolder, DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("sixteen".equals(localName)) {
                this.mMeta.setIconSixteen(new File(this.mParentFolder, DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("path".equals(localName)) {
                this.mMeta.setFrame(new File(this.mParentFolder, this.mStringAccumulator.toString().trim()));
            } else if ("portrait-x-offset".equals(localName)) {
                this.mMeta.getFrameOffsetPortrait().x = DeviceHandler.getInteger(this.mStringAccumulator);
            } else if ("portrait-y-offset".equals(localName)) {
                this.mMeta.getFrameOffsetPortrait().y = DeviceHandler.getInteger(this.mStringAccumulator);
            } else if ("landscape-x-offset".equals(localName)) {
                this.mMeta.getFrameOffsetLandscape().x = DeviceHandler.getInteger(this.mStringAccumulator);
            } else if ("landscape-y-offset".equals(localName)) {
                this.mMeta.getFrameOffsetLandscape().y = DeviceHandler.getInteger(this.mStringAccumulator);
            } else if ("screen-size".equals(localName)) {
                this.mHardware.getScreen().setSize(ScreenSize.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("diagonal-length".equals(localName)) {
                this.mHardware.getScreen().setDiagonalLength(DeviceHandler.getDouble(this.mStringAccumulator));
            } else if ("pixel-density".equals(localName)) {
                this.mHardware.getScreen().setPixelDensity(Density.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("screen-ratio".equals(localName)) {
                this.mHardware.getScreen().setRatio(ScreenRatio.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("x-dimension".equals(localName)) {
                this.mHardware.getScreen().setXDimension(DeviceHandler.getInteger(this.mStringAccumulator));
            } else if ("y-dimension".equals(localName)) {
                this.mHardware.getScreen().setYDimension(DeviceHandler.getInteger(this.mStringAccumulator));
            } else if ("xdpi".equals(localName)) {
                this.mHardware.getScreen().setXdpi(DeviceHandler.getDouble(this.mStringAccumulator));
            } else if ("ydpi".equals(localName)) {
                this.mHardware.getScreen().setYdpi(DeviceHandler.getDouble(this.mStringAccumulator));
            } else if ("multitouch".equals(localName)) {
                this.mHardware.getScreen().setMultitouch(Multitouch.getEnum(DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("mechanism".equals(localName)) {
                this.mHardware.getScreen().setMechanism(TouchScreen.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("screen-type".equals(localName)) {
                this.mHardware.getScreen().setScreenType(ScreenType.getEnum(DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("networking".equals(localName)) {
                for (String n : DeviceHandler.getStringList(this.mStringAccumulator)) {
                    Network net = Network.getEnum(n);
                    if (net == null) continue;
                    this.mHardware.addNetwork(net);
                }
            } else if ("sensors".equals(localName)) {
                for (String s : DeviceHandler.getStringList(this.mStringAccumulator)) {
                    Sensor sens = Sensor.getEnum(s);
                    if (sens == null) continue;
                    this.mHardware.addSensor(sens);
                }
            } else if ("mic".equals(localName)) {
                this.mHardware.setHasMic(DeviceHandler.getBool(this.mStringAccumulator));
            } else if ("camera".equals(localName)) {
                this.mHardware.addCamera(this.mCamera);
                this.mCamera = null;
            } else if ("location".equals(localName)) {
                CameraLocation location = CameraLocation.getEnum(DeviceHandler.getString(this.mStringAccumulator));
                if (location != null) {
                    this.mCamera.setLocation(location);
                }
            } else if ("autofocus".equals(localName)) {
                this.mCamera.setFlash(DeviceHandler.getBool(this.mStringAccumulator));
            } else if ("flash".equals(localName)) {
                this.mCamera.setFlash(DeviceHandler.getBool(this.mStringAccumulator));
            } else if ("keyboard".equals(localName)) {
                this.mHardware.setKeyboard(Keyboard.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("nav".equals(localName)) {
                this.mHardware.setNav(Navigation.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("ram".equals(localName)) {
                int val = DeviceHandler.getInteger(this.mStringAccumulator);
                this.mHardware.setRam(new Storage(val, this.mUnit));
            } else if ("buttons".equals(localName)) {
                ButtonType buttonType = ButtonType.getEnum(DeviceHandler.getString(this.mStringAccumulator));
                if (buttonType != null) {
                    this.mHardware.setButtonType(buttonType);
                }
            } else if ("internal-storage".equals(localName)) {
                for (String s : DeviceHandler.getStringList(this.mStringAccumulator)) {
                    int val = Integer.parseInt(s);
                    this.mHardware.addInternalStorage(new Storage(val, this.mUnit));
                }
            } else if ("removable-storage".equals(localName)) {
                for (String s : DeviceHandler.getStringList(this.mStringAccumulator)) {
                    if (s == null || s.isEmpty()) continue;
                    int val = Integer.parseInt(s);
                    this.mHardware.addRemovableStorage(new Storage(val, this.mUnit));
                }
            } else if ("cpu".equals(localName)) {
                this.mHardware.setCpu(DeviceHandler.getString(this.mStringAccumulator));
            } else if ("gpu".equals(localName)) {
                this.mHardware.setGpu(DeviceHandler.getString(this.mStringAccumulator));
            } else if ("abi".equals(localName)) {
                for (String s : DeviceHandler.getStringList(this.mStringAccumulator)) {
                    Abi abi = Abi.getEnum(s);
                    if (abi == null) continue;
                    this.mHardware.addSupportedAbi(abi);
                }
            } else if ("dock".equals(localName)) {
                for (String s : DeviceHandler.getStringList(this.mStringAccumulator)) {
                    UiMode d = UiMode.getEnum((String)s);
                    if (d == null) continue;
                    this.mHardware.addSupportedUiMode(d);
                }
            } else if ("power-type".equals(localName)) {
                PowerType type = PowerType.getEnum(DeviceHandler.getString(this.mStringAccumulator));
                if (type != null) {
                    this.mHardware.setChargeType(type);
                }
            } else if ("api-level".equals(localName)) {
                String val = DeviceHandler.getString(this.mStringAccumulator);
                if (val.charAt(0) == '-') {
                    if (val.length() == 1) {
                        this.mSoftware.setMinSdkLevel(0);
                        this.mSoftware.setMaxSdkLevel(Integer.MAX_VALUE);
                    } else {
                        val = val.substring(1).trim();
                        this.mSoftware.setMinSdkLevel(0);
                        this.mSoftware.setMaxSdkLevel(Integer.parseInt(val));
                    }
                } else {
                    int index = val.indexOf(45);
                    if (index > 0) {
                        if (index == val.length() - 1) {
                            val = val.substring(0, val.length() - 1).trim();
                            this.mSoftware.setMinSdkLevel(Integer.parseInt(val));
                            this.mSoftware.setMaxSdkLevel(Integer.MAX_VALUE);
                        } else {
                            String min = val.substring(0, index).trim();
                            String max = val.substring(index + 1);
                            this.mSoftware.setMinSdkLevel(Integer.parseInt(min));
                            this.mSoftware.setMaxSdkLevel(Integer.parseInt(max));
                        }
                    } else {
                        int apiLevel = Integer.parseInt(val);
                        this.mSoftware.setMinSdkLevel(apiLevel);
                        this.mSoftware.setMaxSdkLevel(apiLevel);
                    }
                }
            } else if ("live-wallpaper-support".equals(localName)) {
                this.mSoftware.setLiveWallpaperSupport(DeviceHandler.getBool(this.mStringAccumulator));
            } else if ("bluetooth-profiles".equals(localName)) {
                for (String s : DeviceHandler.getStringList(this.mStringAccumulator)) {
                    BluetoothProfile profile = BluetoothProfile.getEnum(s);
                    if (profile == null) continue;
                    this.mSoftware.addBluetoothProfile(profile);
                }
            } else if ("gl-version".equals(localName)) {
                this.mSoftware.setGlVersion(DeviceHandler.getString(this.mStringAccumulator));
            } else if ("gl-extensions".equals(localName)) {
                this.mSoftware.addAllGlExtensions(DeviceHandler.getStringList(this.mStringAccumulator));
            } else if ("description".equals(localName)) {
                this.mState.setDescription(DeviceHandler.getString(this.mStringAccumulator));
            } else if ("screen-orientation".equals(localName)) {
                this.mState.setOrientation(ScreenOrientation.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("keyboard-state".equals(localName)) {
                this.mState.setKeyState(KeyboardState.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
            } else if ("nav-state".equals(localName)) {
                String navState = DeviceHandler.getString(this.mStringAccumulator);
                if (navState.equals("nonav")) {
                    this.mState.setNavState(NavigationState.HIDDEN);
                } else {
                    this.mState.setNavState(NavigationState.getEnum((String)DeviceHandler.getString(this.mStringAccumulator)));
                }
            } else if ("status-bar".equals(localName)) {
                this.mSoftware.setStatusBar(DeviceHandler.getBool(this.mStringAccumulator));
            } else if ("tag-id".equals(localName)) {
                this.mBuilder.setTagId(DeviceHandler.getString(this.mStringAccumulator));
            } else if ("prop-name".equals(localName)) {
                assert (this.mBootProp != null && this.mBootProp.length == 2);
                this.mBootProp[0] = DeviceHandler.getString(this.mStringAccumulator);
            } else if ("prop-value".equals(localName)) {
                assert (this.mBootProp != null && this.mBootProp.length == 2);
                this.mBootProp[1] = this.mStringAccumulator.toString();
            } else if ("boot-prop".equals(localName)) {
                assert (this.mBootProp != null && this.mBootProp.length == 2 && this.mBootProp[0] != null && this.mBootProp[1] != null);
                this.mBuilder.addBootProp(this.mBootProp[0], this.mBootProp[1]);
                this.checkAndSetIfRound(this.mBootProp[0], this.mBootProp[1]);
                this.mBootProp = null;
            } else if ("skin".equals(localName)) {
                String path = DeviceHandler.getString(this.mStringAccumulator).replace('/', File.separatorChar);
                this.mHardware.setSkinFile(new File(path));
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        private void checkAndSetIfRound(String bootPropKey, String bootPropValue) {
            ScreenRound roundness = null;
            if (ROUND_BOOT_PROP.equals(bootPropKey)) {
                if ("true".equals(bootPropValue)) {
                    roundness = ScreenRound.ROUND;
                } else if ("false".equals(bootPropValue)) {
                    roundness = ScreenRound.NOTROUND;
                }
                for (State state : this.mBuilder.getAllStates()) {
                    state.getHardware().getScreen().setScreenRound(roundness);
                }
            }
            if (CHIN_BOOT_PROP.equals(bootPropKey)) {
                int chin = Integer.parseInt(bootPropValue);
                for (State state : this.mBuilder.getAllStates()) {
                    state.getHardware().getScreen().setChin(chin);
                }
            }
        }

        private static List<String> getStringList(StringBuilder stringAccumulator) {
            ArrayList<String> filteredStrings = new ArrayList<String>();
            for (String s : sSpaceSplitter.split((CharSequence)stringAccumulator)) {
                if (s == null || s.isEmpty()) continue;
                filteredStrings.add(s.trim());
            }
            return filteredStrings;
        }

        private static Boolean getBool(StringBuilder s) {
            return DeviceHandler.equals(s, "true") || DeviceHandler.equals(s, "1");
        }

        private static double getDouble(StringBuilder stringAccumulator) {
            return Double.parseDouble(DeviceHandler.getString(stringAccumulator));
        }

        private static String getString(StringBuilder s) {
            return s.toString().trim();
        }

        private static boolean equals(StringBuilder s, String t) {
            int end;
            int start;
            int length = s.length();
            for (start = 0; start < length && Character.isWhitespace(s.charAt(start)); ++start) {
            }
            if (start == length) {
                return t.isEmpty();
            }
            for (end = length; end > start && Character.isWhitespace(s.charAt(end - 1)); --end) {
            }
            if (t.length() != end - start) {
                return false;
            }
            int i = 0;
            int n = t.length();
            int j = start;
            while (i < n) {
                if (Character.toLowerCase(s.charAt(j)) != Character.toLowerCase(t.charAt(i))) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }

        private static int getInteger(StringBuilder stringAccumulator) {
            return Integer.parseInt(DeviceHandler.getString(stringAccumulator));
        }
    }
}

