/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMVCReference
extends PsiReferenceBase.Poly<PsiElement>
implements EmptyResolveMessageProvider {
    private final ServletMappingInfo myMappingInfo;

    public SpringMVCReference(PsiElement element, int offset, String text, @Nullable ServletMappingInfo mappingInfo, boolean soft) {
        super(element, new TextRange(offset, offset + text.length()), soft);
        TextRange range;
        this.myMappingInfo = mappingInfo;
        if (mappingInfo != null && (range = mappingInfo.getNameRange(text)) != null) {
            this.setRangeInElement(range.shiftRight(offset));
        }
    }

    @Nullable
    private SpringMVCModel getModel() {
        return SpringMVCModelService.getInstance().getModel(this.getElement());
    }

    private String getUrl() {
        String url = this.getValue();
        if (StringUtil.startsWithChar((CharSequence)url, (char)'/')) {
            url = url.substring(1);
        }
        return url;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.myMappingInfo == null) {
            return super.handleElementRename(newElementName);
        }
        String s = this.myMappingInfo.stripMapping(newElementName);
        return super.handleElementRename(s);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (this.myMappingInfo == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        SpringMVCModel model = this.getModel();
        if (model == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String url = this.getUrl();
        Collection elements = model.resolveUrl(url, this.myMappingInfo);
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)elements);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        SpringMVCModel model = this.getModel();
        if (model == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
        ServletMappingInfo mappingInfo = this.myMappingInfo == null ? model.getServletMappingInfo() : null;
        Object[] objectArray = ContainerUtil.map2Array((Collection)model.getAllUrls(), LookupElement.class, variant -> {
            PsiElement resolveElement;
            String lookupString = "/" + variant.getLookupString();
            if (mappingInfo != null && !mappingInfo.matches(lookupString)) {
                lookupString = mappingInfo.addMapping(lookupString);
            }
            LookupElementBuilder builder = (resolveElement = variant.getPsiElementPointer().getPsiElement()) != null ? LookupElementBuilder.create((Object)resolveElement, (String)lookupString).withTypeText(FileUtil.getNameWithoutExtension((String)resolveElement.getContainingFile().getName())) : LookupElementBuilder.create((String)lookupString);
            builder = builder.withIcon(SpringApiIcons.RequestMapping);
            if (variant.getMethod().length > 0) {
                builder = builder.withTailText(" " + RequestMethod.getDisplay((RequestMethod[])variant.getMethod()), true);
            }
            if (variant.isPattern()) {
                return builder.withPresentableText("/" + variant.getPresentation());
            }
            return builder;
        });
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = SpringMvcBundle.message("cannot.resolve.controller.url", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMVCReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

