/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestMappingUtil {
    static RequestMethod[] getAllRequestMethods(RequestMapping.Method requestMapping) {
        Object[] methods = requestMapping.getLocalMethods();
        RequestMapping<PsiClass> classLevelMapping = requestMapping.getClassLevelMapping();
        if (classLevelMapping == null) {
            return methods;
        }
        LinkedHashSet allRequestMethods = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAll((Collection)allRequestMethods, (Object[])classLevelMapping.getMethods());
        ContainerUtil.addAll((Collection)allRequestMethods, (Object[])methods);
        return (RequestMethod[])ArrayUtil.toObjectArray((Collection)allRequestMethods, RequestMethod.class);
    }

    @Nullable
    public static RequestMapping<PsiClass> getClassLevelMapping(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/web/mvc/jam/RequestMappingUtil", "getClassLevelMapping"));
        }
        return (RequestMapping)JamService.getJamService((Project)psiClass.getProject()).getJamElement(RequestMapping.CLASS_JAM_KEY, (PsiElement)psiClass);
    }
}

