/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.navigation;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.ConstantFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcRequestMappingRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final ConstantFunction<PsiElement, String> TOOL_TIP = new ConstantFunction((Object)"Navigate to related views");

    public String getId() {
        return "SpringMvcRequestMappingRelatedItemLineMarkerProvider";
    }

    public String getName() {
        return "Related Views";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.RequestMapping;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null) {
            return;
        }
        if (!SpringMvcLibraryUtil.isSpringMVCEnabled((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement context, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider", "collectNavigationMarkers"));
        }
        if (!(context instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)context;
        if (!SpringControllerClassInfo.isRequestHandlerCandidate(method)) {
            return;
        }
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(psiClass);
        if (!info.isRequestHandler(method)) {
            return;
        }
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(context);
        if (model == null) {
            return;
        }
        Set views = info.getViews(method).keySet();
        if (views.isEmpty()) {
            return;
        }
        List resolvers = model.getViewResolvers();
        LinkedHashSet<PsiFile> resolvedViews = new LinkedHashSet<PsiFile>();
        for (String view : views) {
            for (ViewResolver resolver : resolvers) {
                PsiElement psiElement = resolver.resolveFinalView(view, model);
                if (psiElement == null) continue;
                resolvedViews.add(psiElement.getContainingFile());
            }
        }
        if (resolvedViews.isEmpty()) {
            return;
        }
        result.add(SpringMvcRequestMappingRelatedItemLineMarkerProvider.createLineMarker((PsiElement)nameIdentifier, resolvedViews));
    }

    private static RelatedItemLineMarkerInfo<PsiElement> createLineMarker(PsiElement nameIdentifier, Set<PsiFile> resolvedViews) {
        DefaultGutterIconNavigationHandler<PsiElement> navigationHandler = new DefaultGutterIconNavigationHandler<PsiElement>(resolvedViews, "Spring Views"){

            public void navigate(MouseEvent e, PsiElement elt) {
                super.navigate(e, elt);
                UsageTrigger.trigger((String)"spring.MVCRelatedFilesProvider.fromCode");
            }
        };
        return new RelatedItemLineMarkerInfo(nameIdentifier, nameIdentifier.getTextRange(), SpringApiIcons.RequestMapping, 11, TOOL_TIP, (GutterIconNavigationHandler)navigationHandler, GutterIconRenderer.Alignment.RIGHT, (Collection)GotoRelatedItem.createItems(resolvedViews, (String)"Spring View"));
    }
}

