/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReference;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReferenceProvider;
import com.intellij.spring.web.mvc.pathVariables.MVCRequestMappingReference;
import org.jetbrains.annotations.NotNull;

public class MVCPathVariableInspection
extends BaseJavaLocalInspectionTool {
    private static final PsiJavaElementPattern.Capture<PsiReferenceExpression> REFERENCE_PATTERN = MVCPathVariableReference.createPattern(PsiReferenceExpression.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection", "buildVisitor"));
        }
        Project project = holder.getProject();
        if (!SpringMvcLibraryUtil.isSpringMVCEnabled((Project)project)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiReference[] pathVarReferences;
                boolean hasUnresolvedPathVariables;
                if (REFERENCE_PATTERN.accepts((Object)expression) && (hasUnresolvedPathVariables = this.resolvePathVariables(pathVarReferences = MVCPathVariableReferenceProvider.createMVCPathVariableReferencesForReferenceExpression(expression)))) {
                    holder.registerProblem((PsiElement)expression, "Expression has unresolved @PathVariable", new LocalQuickFix[0]);
                }
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                if (MVCPathVariableReference.PATTERN.accepts((Object)expression)) {
                    this.resolvePathVariables(expression.getReferences());
                } else if (MVCRequestMappingReference.PATTERN.accepts((Object)expression)) {
                    PsiReference[] references;
                    for (PsiReference reference : references = expression.getReferences()) {
                        if (!(reference instanceof MVCRequestMappingReference) || reference.resolve() != null) continue;
                        holder.registerProblem(reference);
                        return;
                    }
                }
            }

            private boolean resolvePathVariables(PsiReference[] references) {
                boolean hasUnresolved = false;
                for (PsiReference reference : references) {
                    if (!(reference instanceof MVCPathVariableReference) || ((MVCPathVariableReference)reference).multiResolve(false).length != 0) continue;
                    hasUnresolved = true;
                    if (holder.getFile() != reference.getElement().getContainingFile()) continue;
                    holder.registerProblem(reference);
                }
                return hasUnresolved;
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getShortName() {
        if ("MVCPathVariableInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection", "getShortName"));
        }
        return "MVCPathVariableInspection";
    }
}

