/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.taglib;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.impl.util.CssInHtmlClassOrIdReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdReferenceProvider;
import com.intellij.spring.references.StaticStringValuesReferenceProvider;
import com.intellij.spring.web.mvc.taglib.FormCommandNameReferenceProvider;
import com.intellij.spring.web.mvc.taglib.FormPathReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SpringFormTaglibReferenceContributor
extends PsiReferenceContributor {
    static final PatternCondition<VirtualFile> JSP_FILE_PATTERN_CONDITION = new PatternCondition<VirtualFile>("jspFileType"){

        public boolean accepts(@NotNull VirtualFile file, ProcessingContext context) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/web/mvc/taglib/SpringFormTaglibReferenceContributor$1", "accepts"));
            }
            FileType fileType = file.getFileType();
            return fileType == StdFileTypes.JSP || fileType == StdFileTypes.JSPX;
        }
    };
    private static final XmlAttributeValuePattern FORM_TAGLIB_PATTERN = (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().with(JSP_FILE_PATTERN_CONDITION))).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withNamespace("http://www.springframework.org/tags/form"));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/web/mvc/taglib/SpringFormTaglibReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"path"}).and((ElementPattern)FORM_TAGLIB_PATTERN)).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName((ElementPattern)StandardPatterns.not((ElementPattern)StandardPatterns.string().oneOf(new String[]{"checkbox", "errors", "label", "radiobutton"})))), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/taglib/SpringFormTaglibReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/taglib/SpringFormTaglibReferenceContributor$2", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new IdReferenceProvider.GlobalAttributeValueSelfReference(element, false)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/taglib/SpringFormTaglibReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"path"}).and((ElementPattern)FORM_TAGLIB_PATTERN)).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName((ElementPattern)StandardPatterns.not((ElementPattern)StandardPatterns.string().equalTo((Object)"label")))), (PsiReferenceProvider)new FormPathReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"cssClass", "cssErrorClass"}).and((ElementPattern)FORM_TAGLIB_PATTERN), (PsiReferenceProvider)new CssInHtmlClassOrIdReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"autocomplete", "disabled", "htmlEscape", "readonly"}).and((ElementPattern)FORM_TAGLIB_PATTERN), (PsiReferenceProvider)new StaticStringValuesReferenceProvider(new String[]{"false", "true"}));
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"dir"}).and((ElementPattern)FORM_TAGLIB_PATTERN), (PsiReferenceProvider)new StaticStringValuesReferenceProvider(new String[]{"auto", "ltr", "rtl"}));
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(FormCommandNameReferenceProvider.FORM_COMMAND_ATTRIBUTE_NAMES).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName("form"))).and((ElementPattern)FORM_TAGLIB_PATTERN), (PsiReferenceProvider)new FormCommandNameReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"enctype"}).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName("form"))).and((ElementPattern)FORM_TAGLIB_PATTERN), (PsiReferenceProvider)new StaticStringValuesReferenceProvider(new String[]{"application/x-www-form-urlencoded", "multipart/form-data"}));
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"method"}).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName("form"))).and((ElementPattern)FORM_TAGLIB_PATTERN), (PsiReferenceProvider)new StaticStringValuesReferenceProvider(new String[]{"get", "post"}));
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"target"}).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName("form"))).and((ElementPattern)FORM_TAGLIB_PATTERN), (PsiReferenceProvider)new StaticStringValuesReferenceProvider(new String[]{"_blank", "_parent", "_self", "_top"}));
    }
}

