/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.labels;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LabelItemSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.labels.ItemAndVersion;
import org.jetbrains.tfsIntegration.core.tfs.labels.LabelItemSpecWithItems;

public class LabelModel {
    private final List<LabelItemSpecWithItems> myLabelSpecs = new ArrayList<LabelItemSpecWithItems>();
    private static final Comparator<LabelItemSpecWithItems> ITEM_SPEC_PARENT_FIRST = (o1, o2) -> VersionControlPath.compareParentToChild(o1.getServerPath(), o2.getServerPath());
    private static final Comparator<LabelItemSpecWithItems> ITEM_SPEC_CHILDREN_FIRST = (o1, o2) -> -VersionControlPath.compareParentToChild(o1.getServerPath(), o2.getServerPath());
    private static final Comparator<ItemAndVersion> ITEM_AND_VERSION_PARENT_FIRST = (o1, o2) -> VersionControlPath.compareParentToChild(o1.getServerPath(), o1.isDirectory(), o2.getServerPath(), o2.isDirectory());

    public void add(@NotNull LabelItemSpecWithItems newSpec) {
        if (newSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSpec", "org/jetbrains/tfsIntegration/core/tfs/labels/LabelModel", "add"));
        }
        Iterator<LabelItemSpecWithItems> iterator = this.myLabelSpecs.iterator();
        while (iterator.hasNext()) {
            LabelItemSpecWithItems existingSpec = iterator.next();
            if (!VersionControlPath.isUnder(newSpec.getServerPath(), existingSpec.getServerPath())) continue;
            iterator.remove();
        }
        this.myLabelSpecs.add(newSpec);
    }

    public void addAll(List<LabelItemSpecWithItems> newSpecs) {
        Collections.sort(newSpecs, ITEM_SPEC_CHILDREN_FIRST);
        for (LabelItemSpecWithItems spec : newSpecs) {
            this.add(spec);
        }
    }

    public List<ItemAndVersion> calculateItemsToDisplay() {
        Collections.sort(this.myLabelSpecs, ITEM_SPEC_PARENT_FIRST);
        ArrayList<ItemAndVersion> result = new ArrayList<ItemAndVersion>();
        for (int i = 0; i < this.myLabelSpecs.size(); ++i) {
            LabelItemSpecWithItems labelSpec = this.myLabelSpecs.get(i);
            for (Item item : labelSpec.getItemsList()) {
                boolean appearsUnderChild = false;
                for (int j = i + 1; j < this.myLabelSpecs.size(); ++j) {
                    if (!VersionControlPath.isUnder(this.myLabelSpecs.get(j).getServerPath(), item.getItem())) continue;
                    appearsUnderChild = true;
                    break;
                }
                if (appearsUnderChild) continue;
                result.add(new ItemAndVersion(item, labelSpec.getLabelItemSpec().getVersion()));
            }
        }
        Collections.sort(result, ITEM_AND_VERSION_PARENT_FIRST);
        return result;
    }

    public List<LabelItemSpec> getLabelItemSpecs() {
        Collections.sort(this.myLabelSpecs, ITEM_SPEC_PARENT_FIRST);
        ArrayList<LabelItemSpec> result = new ArrayList<LabelItemSpec>(this.myLabelSpecs.size());
        for (LabelItemSpecWithItems labelSpec : this.myLabelSpecs) {
            result.add(labelSpec.getLabelItemSpec());
        }
        return result;
    }
}

