/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.operations;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.WaitForProgressToShow;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ChangeType_type0;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LocalVersionUpdate;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.core.tfs.operations.GetOperationsUtil;
import org.jetbrains.tfsIntegration.exceptions.OperationFailedException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class ApplyGetOperations {
    private static LocalConflictHandlingType ourLocalConflictHandlingType = LocalConflictHandlingType.SHOW_MESSAGE;
    private final Project myProject;
    private final WorkspaceInfo myWorkspace;
    private final Collection<GetOperation> myOperations;
    @NotNull
    private final ApplyProgress myProgress;
    @Nullable
    private final UpdatedFiles myUpdatedFiles;
    private final Collection<VcsException> myErrors;
    private final Collection<LocalVersionUpdate> myUpdateLocalVersions;
    private final DownloadMode myDownloadMode;

    private ApplyGetOperations(Project project, WorkspaceInfo workspace, Collection<GetOperation> operations, @NotNull ApplyProgress progress, @Nullable UpdatedFiles updatedFiles, DownloadMode downloadMode) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "org/jetbrains/tfsIntegration/core/tfs/operations/ApplyGetOperations", "<init>"));
        }
        this.myErrors = new ArrayList<VcsException>();
        this.myUpdateLocalVersions = new ArrayList<LocalVersionUpdate>();
        this.myProject = project;
        this.myWorkspace = workspace;
        this.myOperations = operations;
        this.myProgress = progress;
        this.myUpdatedFiles = updatedFiles;
        this.myDownloadMode = downloadMode;
    }

    public static LocalConflictHandlingType getLocalConflictHandlingType() {
        return ourLocalConflictHandlingType;
    }

    public static void setLocalConflictHandlingType(LocalConflictHandlingType type) {
        ourLocalConflictHandlingType = type;
    }

    public static Collection<VcsException> execute(Project project, WorkspaceInfo workspace, Collection<GetOperation> operations, @NotNull ApplyProgress progress, @Nullable UpdatedFiles updatedFiles, DownloadMode downloadMode) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "org/jetbrains/tfsIntegration/core/tfs/operations/ApplyGetOperations", "execute"));
        }
        ApplyGetOperations session = new ApplyGetOperations(project, workspace, operations, progress, updatedFiles, downloadMode);
        session.execute();
        return session.myErrors;
    }

    private void execute() {
        if (this.myOperations.isEmpty()) {
            return;
        }
        ArrayList<GetOperation> sortedOperations = new ArrayList<GetOperation>(this.myOperations);
        try {
            for (int i = 0; i < sortedOperations.size(); ++i) {
                if (this.myProgress.isCancelled()) {
                    throw new ProcessCanceledException();
                }
                GetOperation operationToExecute = (GetOperation)sortedOperations.get(i);
                String currentPath = VersionControlPath.localPathFromTfsRepresentation(operationToExecute.getTlocal() != null ? operationToExecute.getTlocal() : operationToExecute.getSlocal());
                if (currentPath == null) {
                    FilePath unexistingPath = this.myWorkspace.findLocalPathByServerPath(operationToExecute.getTitem(), operationToExecute.getType() == ItemType.Folder, this.myProject);
                    currentPath = unexistingPath.getPresentableUrl();
                }
                this.myProgress.setFraction(i / sortedOperations.size());
                this.myProgress.setText(currentPath);
                if (operationToExecute.getCnflct()) {
                    this.processConflict(operationToExecute);
                    continue;
                }
                if (operationToExecute.getSlocal() == null && operationToExecute.getTlocal() == null) {
                    this.updateLocalVersion(operationToExecute);
                    continue;
                }
                if (operationToExecute.getTlocal() == null) {
                    if (operationToExecute.getType() == ItemType.File) {
                        this.processDeleteFile(operationToExecute);
                        continue;
                    }
                    this.processDeleteFolder(operationToExecute);
                    continue;
                }
                if (operationToExecute.getSlocal() == null) {
                    if (operationToExecute.getType() == ItemType.File) {
                        this.processCreateFile(operationToExecute);
                        continue;
                    }
                    this.processCreateFolder(operationToExecute);
                    continue;
                }
                if (operationToExecute.getType() == ItemType.File) {
                    this.processFileChange(operationToExecute);
                    continue;
                }
                this.processFolderChange(operationToExecute);
                if (operationToExecute.getSlocal().equals(operationToExecute.getTlocal())) continue;
                GetOperationsUtil.updateSourcePaths(sortedOperations, i, operationToExecute);
            }
            this.myWorkspace.getServer().getVCS().updateLocalVersions(this.myWorkspace.getName(), this.myWorkspace.getOwnerName(), this.myUpdateLocalVersions, this.myProject, TFSBundle.message("updating.local.version", new Object[0]));
        }
        catch (TfsException e) {
            this.myErrors.add(new VcsException((Throwable)e));
        }
    }

    private void processDeleteFile(GetOperation operation) throws TfsException {
        File source = VersionControlPath.getFile(operation.getSlocal());
        if (source.isDirectory()) {
            String errorMessage = MessageFormat.format("Cannot delete file ''{0}'' because there is a folder with the same name", source.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return;
        }
        if (source.canWrite() && !this.canOverrideLocalConflictingItem(operation, true)) {
            return;
        }
        boolean exists = source.exists();
        if (!this.deleteFile(source)) {
            return;
        }
        this.updateLocalVersion(operation);
        if (exists) {
            this.addToGroup("REMOVED_FROM_REPOSITORY", source, operation);
        }
    }

    private void processDeleteFolder(GetOperation operation) throws TfsException {
        File source = VersionControlPath.getFile(operation.getSlocal());
        if (source.isFile()) {
            String errorMessage = MessageFormat.format("Cannot delete folder ''{0}'' because there is a file with the same name", source.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return;
        }
        if (!this.canDeleteFolder(source)) {
            String errorMessage = MessageFormat.format("Cannot delete folder ''{0}'' because it is not empty", source.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return;
        }
        boolean exists = source.exists();
        if (!this.deleteFile(source)) {
            return;
        }
        this.updateLocalVersion(operation);
        if (exists) {
            this.addToGroup("REMOVED_FROM_REPOSITORY", source, operation);
        }
    }

    private void processCreateFile(@NotNull GetOperation operation) throws TfsException {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/tfsIntegration/core/tfs/operations/ApplyGetOperations", "processCreateFile"));
        }
        File target = VersionControlPath.getFile(operation.getTlocal());
        if (target.isDirectory()) {
            String errorMessage = MessageFormat.format("Cannot create file ''{0}'' because there is a folder with the same name", target.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return;
        }
        if (target.canWrite()) {
            if (!this.canOverrideLocalConflictingItem(operation, false)) {
                return;
            }
            if (!FileUtil.delete((File)target)) {
                String errorMessage = MessageFormat.format("Cannot overwrite file ''{0}''", target.getPath());
                this.myErrors.add(new VcsException(errorMessage));
                return;
            }
        }
        if (!this.createFolder(target.getParentFile())) {
            return;
        }
        if (this.downloadFile(operation)) {
            this.updateLocalVersion(operation);
            this.addToGroup("CREATED", target, operation);
        }
    }

    private void processCreateFolder(GetOperation operation) throws TfsException {
        File target = VersionControlPath.getFile(operation.getTlocal());
        if (target.isFile() && target.canWrite() && !this.canOverrideLocalConflictingItem(operation, false)) {
            return;
        }
        if (target.isFile() && !FileUtil.delete((File)target)) {
            String errorMessage = MessageFormat.format("Cannot create folder ''{0}'' because there is a folder with the same name", target.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return;
        }
        boolean folderExists = target.exists();
        if (!this.createFolder(target)) {
            return;
        }
        this.updateLocalVersion(operation);
        if (!folderExists) {
            this.addToGroup("CREATED", target, operation);
        }
    }

    private void processFileChange(GetOperation operation) throws TfsException {
        File source = VersionControlPath.getFile(operation.getSlocal());
        File target = VersionControlPath.getFile(operation.getTlocal());
        ChangeTypeMask change = new ChangeTypeMask(operation.getChg());
        if (source.equals(target) && operation.getLver() == operation.getSver() && (change.containsOnly(ChangeType_type0.Rename) || this.myDownloadMode != DownloadMode.FORCE && this.myDownloadMode != DownloadMode.MERGE)) {
            this.updateLocalVersion(operation);
            return;
        }
        if (!source.equals(target) && source.canWrite()) {
            if (this.canOverrideLocalConflictingItem(operation, true)) {
                if (this.myDownloadMode == DownloadMode.FORCE && !this.deleteFile(source)) {
                    return;
                }
            } else {
                return;
            }
        }
        if (!(source.equals(target) || !source.isDirectory() || this.canOverrideLocalConflictingItem(operation, true) && this.deleteFile(source))) {
            return;
        }
        if (target.isDirectory()) {
            String errorMessage = MessageFormat.format("Cannot create file ''{0}'' because there is a folder with same name", target.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return;
        }
        if (target.canWrite() && !target.equals(source) && !this.canOverrideLocalConflictingItem(operation, false)) {
            return;
        }
        if (!this.createFolder(target.getParentFile())) {
            return;
        }
        if (this.myDownloadMode == DownloadMode.FORCE || this.myDownloadMode != DownloadMode.MERGE && operation.getLver() != operation.getSver()) {
            if ((source.equals(target) || this.deleteFile(source)) && (change.contains(ChangeType_type0.Add) || this.downloadFile(operation))) {
                this.updateLocalVersion(operation);
                if (source.equals(target)) {
                    this.addToGroup("UPDATED", target, operation);
                } else {
                    this.addToGroup("REMOVED_FROM_REPOSITORY", source, operation);
                    this.addToGroup("CREATED", target, operation);
                }
            }
            return;
        }
        if (!target.exists()) {
            if (source.exists()) {
                if (this.rename(source, target)) {
                    this.addToGroup("UPDATED", target, operation);
                    this.updateLocalVersion(operation);
                }
            } else if (!(change.contains(ChangeType_type0.Add) && source.equals(target) && operation.getLver() == operation.getSver() || !this.downloadFile(operation))) {
                this.addToGroup("CREATED", target, operation);
                this.updateLocalVersion(operation);
            }
        } else {
            if (!source.equals(target)) {
                this.deleteFile(source);
            }
            if (this.myDownloadMode == DownloadMode.MERGE) {
                this.addToGroup("MERGED", target, operation);
            }
            this.updateLocalVersion(operation);
        }
    }

    private void processFolderChange(GetOperation operation) throws TfsException {
        File source = VersionControlPath.getFile(operation.getSlocal());
        File target = VersionControlPath.getFile(operation.getTlocal());
        ChangeTypeMask change = new ChangeTypeMask(operation.getChg());
        if (source.equals(target) && operation.getLver() == operation.getSver() && (change.containsOnly(ChangeType_type0.Rename) || this.myDownloadMode != DownloadMode.FORCE && this.myDownloadMode != DownloadMode.MERGE)) {
            this.updateLocalVersion(operation);
            return;
        }
        if (!source.equals(target) && source.isFile() && !source.canWrite() && !this.deleteFile(source)) {
            return;
        }
        if (target.isFile() && !target.canWrite() && !this.deleteFile(target)) {
            return;
        }
        if (target.isFile() && target.canWrite() && (!this.canOverrideLocalConflictingItem(operation, false) || !this.deleteFile(target))) {
            return;
        }
        if (!this.createFolder(target.getParentFile())) {
            return;
        }
        if (!target.exists()) {
            if (source.isDirectory()) {
                if (this.rename(source, target)) {
                    this.addToGroup("UPDATED", target, operation);
                    this.updateLocalVersion(operation);
                }
            } else if (!(change.contains(ChangeType_type0.Add) && source.equals(target) && operation.getLver() == operation.getSver() || !this.createFolder(target))) {
                this.addToGroup("CREATED", target, operation);
                this.updateLocalVersion(operation);
            }
        } else {
            if (!source.equals(target)) {
                this.deleteFile(source);
            }
            this.updateLocalVersion(operation);
        }
    }

    private void processConflict(GetOperation operation) {
    }

    private void addToGroup(String groupId, File file, GetOperation operation) {
        if (this.myUpdatedFiles != null) {
            int revisionNumber = operation.getSver() != Integer.MIN_VALUE ? operation.getSver() : 0;
            this.myUpdatedFiles.getGroupById(groupId).add(file.getPath(), TFSVcs.getKey(), (VcsRevisionNumber)new TfsRevisionNumber(revisionNumber));
        }
    }

    private boolean deleteFile(File target) {
        if (this.myDownloadMode != DownloadMode.FORBID && !FileUtil.delete((File)target)) {
            String errorMessage = MessageFormat.format("Cannot delete {0} ''{1}''", target.isFile() ? "file" : "folder", target.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return false;
        }
        return true;
    }

    private boolean canDeleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File child : files) {
                if (child.isFile()) {
                    if (child.canWrite()) {
                        return false;
                    }
                    boolean childWillBeDeletedAnyway = false;
                    for (GetOperation operation : this.myOperations) {
                        if (operation.getSlocal() == null || !VersionControlPath.getFile(operation.getSlocal()).equals(child) || operation.getTlocal() != null) continue;
                        childWillBeDeletedAnyway = true;
                        break;
                    }
                    if (childWillBeDeletedAnyway) continue;
                    return false;
                }
                if (this.canDeleteFolder(child)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean createFolder(File target) {
        if (this.myDownloadMode != DownloadMode.FORBID && !target.exists() && !target.mkdirs()) {
            String errorMessage = MessageFormat.format("Cannot create folder ''{0}''", target.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return false;
        }
        return true;
    }

    private boolean rename(File source, File target) {
        if (this.myDownloadMode != DownloadMode.FORBID && !source.equals(target) && !source.renameTo(target)) {
            String errorMessage = MessageFormat.format("Cannot rename {0} ''{1}'' to ''{2}''", source.isFile() ? "file" : "folder", source.getPath(), target.getPath());
            this.myErrors.add(new VcsException(errorMessage));
            return false;
        }
        return true;
    }

    private boolean downloadFile(final GetOperation operation) throws TfsException {
        TFSVcs.assertTrue(operation.getDurl() != null, "Null download url for " + VersionControlPath.localPathFromTfsRepresentation(operation.getTlocal()));
        if (this.myDownloadMode == DownloadMode.FORBID) {
            return true;
        }
        final File target = VersionControlPath.getFile(operation.getTlocal());
        try {
            TfsFileUtil.setFileContent(target, new TfsFileUtil.ContentWriter(){

                @Override
                public void write(OutputStream outputStream) throws TfsException {
                    ApplyGetOperations.this.myWorkspace.getServer().getVCS().downloadItem(ApplyGetOperations.this.myProject, operation.getDurl(), outputStream, TFSBundle.message("downloading.0", target.getName()));
                }
            });
            if (!target.setReadOnly()) {
                String errorMessage = MessageFormat.format("Cannot write to file ''{0}''", target.getPath());
                this.myErrors.add(new VcsException(errorMessage));
                return false;
            }
            return true;
        }
        catch (IOException e) {
            String errorMessage = MessageFormat.format("Cannot write to file ''{0}'': {1}", target.getPath(), e.getMessage());
            this.myErrors.add(new VcsException(errorMessage));
            return false;
        }
    }

    private boolean canOverrideLocalConflictingItem(GetOperation operation, boolean sourceNotTarget) throws TfsException {
        if (this.myDownloadMode == DownloadMode.FORCE || this.myDownloadMode == DownloadMode.MERGE) {
            return true;
        }
        LocalConflictHandlingType conflictHandlingType = ApplyGetOperations.getLocalConflictHandlingType();
        if (conflictHandlingType == LocalConflictHandlingType.ERROR) {
            throw new OperationFailedException("Local conflict detected for " + VersionControlPath.localPathFromTfsRepresentation(sourceNotTarget ? operation.getSlocal() : operation.getTlocal()));
        }
        if (conflictHandlingType == LocalConflictHandlingType.SHOW_MESSAGE) {
            String path = VersionControlPath.localPathFromTfsRepresentation(sourceNotTarget ? operation.getSlocal() : operation.getTlocal());
            String message = MessageFormat.format("Local conflict detected. Override local item?\n {0}", path);
            String title = "Modify Files";
            Ref result = new Ref();
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(() -> result.set((Object)Messages.showYesNoDialog((String)message, (String)"Modify Files", (Icon)Messages.getQuestionIcon())));
            if ((Integer)result.get() == 0) {
                return true;
            }
            this.reportLocalConflict(operation, sourceNotTarget);
            return false;
        }
        throw new IllegalArgumentException("Unknown conflict handling type: " + (Object)((Object)conflictHandlingType));
    }

    private void reportLocalConflict(GetOperation operation, boolean sourceNotTarget) throws TfsException {
        int reason = sourceNotTarget ? 1 : 3;
        this.myWorkspace.getServer().getVCS().addLocalConflict(this.myWorkspace.getName(), this.myWorkspace.getOwnerName(), operation.getItemid(), operation.getSver(), operation.getPcid() != Integer.MIN_VALUE ? operation.getPcid() : 0, operation.getSlocal(), operation.getTlocal(), reason, this.myProject, TFSBundle.message("reporting.conflict", new Object[0]));
    }

    private void updateLocalVersion(GetOperation operation) {
        this.myUpdateLocalVersions.add(VersionControlServer.getLocalVersionUpdate(operation));
    }

    public static enum LocalConflictHandlingType {
        SHOW_MESSAGE,
        ERROR;

    }

    public static enum DownloadMode {
        FORCE,
        ALLOW,
        FORBID,
        MERGE;

    }
}

