/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.tfs.labels.ItemAndVersion;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;

public class LabelItemsTableModel
extends AbstractTableModel {
    private List<ItemAndVersion> myContent = Collections.emptyList();

    public void setContent(@NotNull List<ItemAndVersion> newContent) {
        if (newContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContent", "org/jetbrains/tfsIntegration/ui/LabelItemsTableModel", "setContent"));
        }
        this.myContent = newContent;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.myContent.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].getName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return Column.values()[columnIndex].getValue(this.getItem(rowIndex));
    }

    public ItemAndVersion getItem(int rowIndex) {
        return this.myContent.get(rowIndex);
    }

    static enum Column {
        Item("Item", 300){

            public Item getValue(ItemAndVersion itemAndVersion) {
                return itemAndVersion.getItem();
            }
        }
        ,
        Version("Version", 100){

            @Override
            public String getValue(ItemAndVersion itemAndVersion) {
                return ((VersionSpecBase)itemAndVersion.getVersionSpec()).getPresentableString();
            }
        };

        private final String myName;
        private final int myWidth;

        private Column(String name, int width) {
            this.myName = name;
            this.myWidth = width;
        }

        public String getName() {
            return this.myName;
        }

        public int getWidth() {
            return this.myWidth;
        }

        public abstract Object getValue(ItemAndVersion var1);
    }
}

