/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.NullNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.checkin.CheckinParameters;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsExecutionUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkItemsCheckinParameters;
import org.jetbrains.tfsIntegration.ui.CheckinParametersForm;
import org.jetbrains.tfsIntegration.ui.WorkItemQueriesTreeBuilder;
import org.jetbrains.tfsIntegration.ui.WorkItemQueriesTreeStructure;
import org.jetbrains.tfsIntegration.ui.WorkItemsQueryResult;
import org.jetbrains.tfsIntegration.ui.WorkItemsTableModel;

public class WorkItemsPanel
implements Disposable {
    private JPanel myMainPanel;
    private TreeTableView myWorkItemsTable;
    private SimpleTree myWorkItemQueriesTree;
    private WorkItemQueriesTreeBuilder myTreeBuilder;
    private WorkItemsTableModel myWorkItemsTableModel;
    private final CheckinParametersForm myForm;

    public WorkItemsPanel(CheckinParametersForm form) {
        this.myForm = form;
        this.$$$setupUI$$$();
        this.myWorkItemsTable.setSelectionMode(0);
        this.myWorkItemsTable.getTree().setRootVisible(false);
        this.myWorkItemsTable.setShowGrid(true);
        this.myWorkItemsTable.setGridColor(UIUtil.getTableGridColor());
        this.myWorkItemsTable.setMaxItemsForSizeCalculation(1);
        new TreeTableSpeedSearch((TreeTable)this.myWorkItemsTable);
        this.setupWorkItemQueries();
    }

    private void setupWorkItemQueries() {
        this.myTreeBuilder = new WorkItemQueriesTreeBuilder((JTree)this.myWorkItemQueriesTree, (SimpleTreeStructure)new SimpleTreeStructure.Impl((SimpleNode)new NullNode()));
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
    }

    public void queryWorkItems(@NotNull TfsExecutionUtil.Process<WorkItemsQueryResult> query) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "org/jetbrains/tfsIntegration/ui/WorkItemsPanel", "queryWorkItems"));
        }
        TfsExecutionUtil.ResultWithError<WorkItemsQueryResult> result = TfsExecutionUtil.executeInBackground("Performing Query", this.getProject(), query);
        String title = "Query Work Items";
        if (result.cancelled || result.showDialogIfError("Query Work Items")) {
            return;
        }
        this.getState().getWorkItems(this.myForm.getSelectedServer()).update((WorkItemsQueryResult)ObjectUtils.assertNotNull(result.result));
        this.updateWorkItemsTable();
    }

    private void updateWorkItemsTable() {
        this.myWorkItemsTableModel.setContent(this.getState().getWorkItems(this.myForm.getSelectedServer()));
        TreeUtil.expandAll((JTree)this.myWorkItemsTable.getTree());
    }

    public void update() {
        this.updateWorkItemsTable();
        this.updateWorkItemQueries();
    }

    private void updateWorkItemQueries() {
        this.clearOldTreeStructure();
        this.setNewTreeStructure();
    }

    private void clearOldTreeStructure() {
        AbstractTreeStructure oldTreeStructure = this.myTreeBuilder.getTreeStructure();
        if (oldTreeStructure instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)oldTreeStructure));
        }
        this.myTreeBuilder.cleanUp();
    }

    private void setNewTreeStructure() {
        WorkItemQueriesTreeStructure newTreeStructure = new WorkItemQueriesTreeStructure(this);
        this.myTreeBuilder.setTreeStructure((AbstractTreeStructure)newTreeStructure);
        Disposer.register((Disposable)this.myTreeBuilder, (Disposable)newTreeStructure);
        this.myTreeBuilder.queueUpdate().doWhenDone(() -> this.myTreeBuilder.expand((Object)newTreeStructure.getPredefinedQueriesGroupNode(), null));
    }

    @NotNull
    public CheckinParameters getState() {
        CheckinParameters checkinParameters = this.myForm.getState();
        if (checkinParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkItemsPanel", "getState"));
        }
        return checkinParameters;
    }

    @NotNull
    public ServerInfo getServer() {
        ServerInfo serverInfo = this.myForm.getSelectedServer();
        if (serverInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkItemsPanel", "getServer"));
        }
        return serverInfo;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myForm.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkItemsPanel", "getProject"));
        }
        return project;
    }

    public void dispose() {
    }

    private void createUIComponents() {
        this.myWorkItemsTableModel = new WorkItemsTableModel(new WorkItemsCheckinParameters());
        this.myWorkItemsTable = new TreeTableView(this.myWorkItemsTableModel){

            protected void onTableChanged(@NotNull TableModelEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/tfsIntegration/ui/WorkItemsPanel$1", "onTableChanged"));
                }
                super.onTableChanged(e);
                this.getTree().setRowHeight(this.calculateRowHeight());
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SimpleTree simpleTree;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Splitter splitter = new Splitter();
        splitter.setOrientation(false);
        splitter.setEnabled(true);
        splitter.setProportion(0.2f);
        splitter.setShowDividerIcon(true);
        jPanel.add((Component)splitter, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        TreeTableView treeTableView = this.myWorkItemsTable;
        jBScrollPane.setViewportView((Component)treeTableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myWorkItemQueriesTree = simpleTree = new SimpleTree();
        simpleTree.setRootVisible(false);
        simpleTree.setShowsRootHandles(true);
        simpleTree.setVisible(true);
        simpleTree.putClientProperty((Object)"JTree.lineStyle", (Object)"Angled");
        jBScrollPane2.setViewportView((Component)simpleTree);
        splitter.setSecondComponent((JComponent)jPanel2);
        splitter.setFirstComponent((JComponent)jBScrollPane2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

