/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemLinkInfo;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.WorkItemsCheckinParameters;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemState;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemType;
import org.jetbrains.tfsIntegration.ui.NoBackgroundBooleanTableCellRenderer;

class WorkItemsTableModel
extends ListTreeTableModelOnColumns {
    private static final Logger LOG = Logger.getInstance(WorkItemsTableModel.class);
    @NotNull
    private final DefaultMutableTreeNode myRoot;
    @NotNull
    private final WorkItemsCheckinParameters myContent;
    static WorkItemFieldColumn<WorkItemType> TYPE = new WorkItemFieldColumn<WorkItemType>("Type", 300){

        @Override
        @Nullable
        public WorkItemType valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$1", "valueOf"));
            }
            return workItem.getType();
        }
    };
    static WorkItemFieldColumn<Integer> ID = new WorkItemFieldColumn<Integer>("Id", 200){

        @Override
        @Nullable
        public Integer valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$2", "valueOf"));
            }
            return workItem.getId();
        }
    };
    static WorkItemFieldColumn<String> TITLE = new WorkItemFieldColumn<String>("Title", 1500){

        @Override
        @Nullable
        public String valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$3", "valueOf"));
            }
            return workItem.getTitle();
        }

        public Class<?> getColumnClass() {
            return TreeTableModel.class;
        }
    };
    static WorkItemFieldColumn<WorkItemState> STATE = new WorkItemFieldColumn<WorkItemState>("State", 300){

        @Override
        @Nullable
        public WorkItemState valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$4", "valueOf"));
            }
            return workItem.getState();
        }
    };

    public WorkItemsTableModel(@NotNull WorkItemsCheckinParameters content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel", "<init>"));
        }
        super(null, new ColumnInfo[]{new CheckBoxColumn(content), TYPE, ID, TITLE, STATE, new CheckInActionColumn(content)});
        this.myContent = content;
        this.myRoot = new DefaultMutableTreeNode();
        this.setRoot(this.myRoot);
    }

    @Nullable
    public CheckinWorkItemAction getAction(@NotNull WorkItem workItem) {
        if (workItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel", "getAction"));
        }
        return this.myContent.getAction(workItem);
    }

    public void setContent(@NotNull WorkItemsCheckinParameters content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel", "setContent"));
        }
        this.myContent.update(content);
        this.myRoot.removeAllChildren();
        this.buildModel();
        this.reload(this.myRoot);
    }

    private void buildModel() {
        List<WorkItemLinkInfo> links = this.myContent.getLinks();
        if (!ContainerUtil.isEmpty(links)) {
            this.buildTreeModel(links);
        } else {
            this.buildFlatModel();
        }
    }

    private void buildTreeModel(@NotNull List<WorkItemLinkInfo> links) {
        if (links == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "links", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel", "buildTreeModel"));
        }
        this.validateLinksStructure(links);
        Map workItemsMap = ContainerUtil.map2Map(this.myContent.getWorkItems(), workItem -> Pair.create((Object)workItem.getId(), (Object)new DefaultMutableTreeNode(workItem)));
        workItemsMap.put(0, this.myRoot);
        for (WorkItemLinkInfo link : links) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)workItemsMap.get(link.getSourceID());
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)workItemsMap.get(link.getTargetID());
            if (parentNode != null && childNode != null) {
                parentNode.add(childNode);
                continue;
            }
            LOG.info("Could not resolve work item link " + link.getSourceID() + "-" + link.getTargetID());
        }
    }

    private void validateLinksStructure(@NotNull List<WorkItemLinkInfo> links) {
        if (links == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "links", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel", "validateLinksStructure"));
        }
        if (links.size() != this.myContent.getWorkItems().size()) {
            String linksValue = StringUtil.join(links, info -> info.getSourceID() + " - " + info.getTargetID(), (String)", ");
            String workItemIdsValue = StringUtil.join(this.myContent.getWorkItems(), workItem -> String.valueOf(workItem.getId()), (String)", ");
            LOG.error("Unknown work item links structure\nLinks: " + linksValue + "\nWork Items: " + workItemIdsValue);
        }
    }

    private void buildFlatModel() {
        for (WorkItem workItem : this.myContent.getWorkItems()) {
            this.myRoot.add(new DefaultMutableTreeNode(workItem));
        }
    }

    public void setValueAt(Object aValue, Object node, int column) {
        super.setValueAt(aValue, node, column);
        this.nodeChanged((TreeNode)node);
    }

    static class CheckInActionColumn
    extends WorkItemFieldColumn<CheckinWorkItemAction> {
        private ComboBox myComboBox;
        private TableCellEditor myCellEditor;
        @NotNull
        private final WorkItemsCheckinParameters myContent;

        public CheckInActionColumn(@NotNull WorkItemsCheckinParameters content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckInActionColumn", "<init>"));
            }
            super("Checkin Action", 400);
            this.myComboBox = new ComboBox((Object[])new CheckinWorkItemAction[]{CheckinWorkItemAction.Resolve, CheckinWorkItemAction.Associate});
            this.myCellEditor = new DefaultCellEditor((JComboBox)this.myComboBox){

                @Override
                @Nullable
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    WorkItem workItem;
                    TreeTable treeTable = (TreeTable)table;
                    WorkItemsTableModel model = (WorkItemsTableModel)treeTable.getTableModel();
                    CheckinWorkItemAction action = model.getAction(workItem = (WorkItem)((DefaultMutableTreeNode)treeTable.getTree().getPathForRow(row).getLastPathComponent()).getUserObject());
                    if (action != null && workItem.isActionPossible(CheckinWorkItemAction.Resolve)) {
                        myComboBox.setSelectedItem((Object)action);
                        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    }
                    return null;
                }
            };
            this.myContent = content;
        }

        @Override
        @Nullable
        public CheckinWorkItemAction valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckInActionColumn", "valueOf"));
            }
            CheckinWorkItemAction action = this.myContent.getAction(workItem);
            return CheckinWorkItemAction.None.equals((Object)action) ? null : action;
        }

        public boolean isCellEditable(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckInActionColumn", "isCellEditable"));
            }
            return true;
        }

        @Nullable
        public TableCellEditor getEditor(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckInActionColumn", "getEditor"));
            }
            return this.myCellEditor;
        }

        @Override
        public void setValue(@NotNull WorkItem workItem, @NotNull CheckinWorkItemAction value) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckInActionColumn", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckInActionColumn", "setValue"));
            }
            this.myContent.setAction(workItem, value);
        }
    }

    static class CheckBoxColumn
    extends WorkItemFieldColumn<Boolean> {
        @NotNull
        private final WorkItemsCheckinParameters myContent;
        private TableCellRenderer myRenderer;

        public CheckBoxColumn(@NotNull WorkItemsCheckinParameters content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckBoxColumn", "<init>"));
            }
            super(" ", 50);
            this.myRenderer = new NoBackgroundBooleanTableCellRenderer();
            this.myContent = content;
        }

        @Override
        @Nullable
        public Boolean valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckBoxColumn", "valueOf"));
            }
            CheckinWorkItemAction action = this.myContent.getAction(workItem);
            return action != null && action != CheckinWorkItemAction.None;
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public boolean isCellEditable(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckBoxColumn", "isCellEditable"));
            }
            return true;
        }

        @Nullable
        public TableCellRenderer getRenderer(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckBoxColumn", "getRenderer"));
            }
            return this.myRenderer;
        }

        @Override
        public void setValue(@NotNull WorkItem workItem, @NotNull Boolean value) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckBoxColumn", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckBoxColumn", "setValue"));
            }
            if (value == Boolean.TRUE) {
                CheckinWorkItemAction action = workItem.isActionPossible(CheckinWorkItemAction.Resolve) ? CheckinWorkItemAction.Resolve : CheckinWorkItemAction.Associate;
                this.myContent.setAction(workItem, action);
            } else {
                this.myContent.removeAction(workItem);
            }
        }
    }

    static abstract class WorkItemFieldColumn<Aspect>
    extends ColumnInfo<DefaultMutableTreeNode, Aspect> {
        private final int myWidth;

        public WorkItemFieldColumn(@NotNull String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$WorkItemFieldColumn", "<init>"));
            }
            super(name);
            this.myWidth = width;
        }

        @Nullable
        public String getPreferredStringValue() {
            return "";
        }

        public int getAdditionalWidth() {
            return this.myWidth;
        }

        @Nullable
        public Aspect valueOf(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$WorkItemFieldColumn", "valueOf"));
            }
            Object userObject = node.getUserObject();
            return userObject instanceof WorkItem ? (Aspect)this.valueOf((WorkItem)userObject) : null;
        }

        public void setValue(@NotNull DefaultMutableTreeNode node, @NotNull Aspect value) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$WorkItemFieldColumn", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$WorkItemFieldColumn", "setValue"));
            }
            if (node.getUserObject() instanceof WorkItem) {
                this.setValue((WorkItem)node.getUserObject(), value);
            }
        }

        public void setValue(@NotNull WorkItem workItem, @NotNull Aspect value) {
            if (workItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$WorkItemFieldColumn", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$WorkItemFieldColumn", "setValue"));
            }
        }

        @Nullable
        public abstract Aspect valueOf(@NotNull WorkItem var1);
    }
}

