/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossConfigProcessor;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.javaee.oss.util.ConfigFileWrapper;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;

public class JBoss7HttpConnectorConfig
extends CachedConfig<JBossLocalModel> {
    private static final Map<CachedConfig.Key, JBoss7HttpConnectorConfig> ourCache = new HashMap<CachedConfig.Key, JBoss7HttpConnectorConfig>();
    private static final JBossHttpsFactoryBase STANDALONE_HTTP_CONNECTOR = new JBossHttpsFactoryBase("Standalone"){

        @Override
        protected String[] getXPath(JBossLocalModel data) {
            return new String[]{"/ns:server/ns:profile/*[local-name()='subsystem']/*[local-name()='server']/*[local-name()='http-listener'][@*[local-name()='socket-binding' and .='http']]", "/ns:server/ns:profile/*[local-name()='subsystem']/*[local-name()='connector'][@*[local-name()='socket-binding' and .='http']]"};
        }

        @Override
        protected File getConfigFile(JBossLocalModel data) {
            return JBossVersion7Handler.getConfigFile(data);
        }
    };
    private static final JBossHttpsFactoryBase DOMAIN_HTTP_CONNECTOR = new JBossHttpsFactoryBase("Domain"){

        @Override
        protected String[] getXPath(JBossLocalModel data) {
            String[] stringArray;
            String profileName = (String)new JBossConfigProcessor<String>("/ns:domain/ns:server-groups/ns:server-group[@name='" + data.getServerGroup() + "']/@profile", "full"){

                @Override
                protected String process(XPath xpath, Document doc) throws JDOMException, IOException {
                    Attribute attribute = (Attribute)xpath.selectSingleNode((Object)doc);
                    return attribute == null ? null : attribute.getValue();
                }
            }.get(JBossVersion7Handler.getDomainConfigFile(data));
            if (profileName == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "/ns:domain/ns:profiles/ns:profile[@name='" + profileName + "']/*[local-name()='subsystem']/*[local-name()='server']/*[local-name()='http-listener'][@*[local-name()='socket-binding' and .='http']]";
                stringArray = stringArray2;
                stringArray2[1] = "/ns:domain/ns:profiles/ns:profile[@name='" + profileName + "']/*[local-name()='subsystem']/*[local-name()='connector'][@*[local-name()='socket-binding' and .='http']]";
            }
            return stringArray;
        }

        @Override
        protected File getConfigFile(JBossLocalModel data) {
            return JBossVersion7Handler.getDomainConfigFile(data);
        }
    };
    private Boolean myHttpConnectorExist;
    private final JBossHttpsFactoryBase myFactory;
    private final File myConfigFile;

    protected static boolean get(JBossHttpsFactoryBase factory, JBossLocalModel model) {
        return Optional.ofNullable(JBoss7HttpConnectorConfig.get(ourCache, (CachedConfig.Factory)factory, (Object)((Object)model))).map(config -> config.myHttpConnectorExist).orElse(true);
    }

    public static boolean isHttpConnectorExist(JBossLocalModel model) {
        return JBoss7HttpConnectorConfig.get(model.isDomain() ? DOMAIN_HTTP_CONNECTOR : STANDALONE_HTTP_CONNECTOR, model);
    }

    public JBoss7HttpConnectorConfig(JBossHttpsFactoryBase factory, File configFile) {
        this.myFactory = factory;
        this.myConfigFile = configFile;
    }

    protected long getStamp(JBossLocalModel data) {
        return JBoss7HttpConnectorConfig.getStamp((File)this.myConfigFile);
    }

    protected void update(final JBossLocalModel data) {
        this.myHttpConnectorExist = (Boolean)new ConfigFileWrapper<Boolean>(){

            @NotNull
            protected Boolean doGet(Document doc) throws JDOMException, IOException {
                for (String xPathText : JBoss7HttpConnectorConfig.this.myFactory.getXPath(data)) {
                    XPath xPath = XPath.newInstance((String)xPathText);
                    xPath.addNamespace("ns", doc.getRootElement().getNamespaceURI());
                    if (xPath.selectSingleNode((Object)doc) == null) continue;
                    Boolean bl = true;
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/JBoss7HttpConnectorConfig$3", "doGet"));
                    }
                    return bl;
                }
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/JBoss7HttpConnectorConfig$3", "doGet"));
                }
                return bl;
            }
        }.get(this.myConfigFile);
    }

    private static abstract class JBossHttpsFactoryBase
    implements Factory {
        private final String myModeKindKey;

        public JBossHttpsFactoryBase(String modeKindKey) {
            this.myModeKindKey = modeKindKey;
        }

        @NotNull
        public CachedConfig.Key createKey(JBossLocalModel data) {
            Object[] keyParts = new String[]{data.getHome(), this.myModeKindKey};
            CachedConfig.Key key = new CachedConfig.Key((String[])(data.isDomain() ? (String[])ArrayUtil.append((Object[])keyParts, (Object)data.getServerGroup()) : keyParts));
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/JBoss7HttpConnectorConfig$JBossHttpsFactoryBase", "createKey"));
            }
            return key;
        }

        @NotNull
        public JBoss7HttpConnectorConfig createConfig(JBossLocalModel data) {
            JBoss7HttpConnectorConfig jBoss7HttpConnectorConfig = new JBoss7HttpConnectorConfig(this, this.getConfigFile(data));
            if (jBoss7HttpConnectorConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/JBoss7HttpConnectorConfig$JBossHttpsFactoryBase", "createConfig"));
            }
            return jBoss7HttpConnectorConfig;
        }

        protected abstract String[] getXPath(JBossLocalModel var1);

        protected abstract File getConfigFile(JBossLocalModel var1);
    }

    protected static interface Factory
    extends CachedConfig.Factory<JBossLocalModel, JBoss7HttpConnectorConfig> {
    }
}

