/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class SpringBootModelConfigFileContributor {
    public static final Key<CustomSetting.STRING> SPRING_CONFIG_NAME_CUSTOM_SETTING_ID = Key.create((String)"spring_boot_spring_config_name");
    public static final String SPRING_CONFIG_NAME_DEFAULT = "application";
    public static final Key<CustomSetting.STRING> SPRING_CONFIG_CUSTOM_FILES_ID = Key.create((String)"spring_boot_spring_config_custom_files");
    public static final ExtensionPointName<SpringBootModelConfigFileContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelConfigFileContributor");
    private static final Comparator<VirtualFile> VF_BY_NAME_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
    private static final boolean OUR_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private final FileType myFileType;
    private static boolean USE_RESOURCE_ROOTS_FOR_TESTS = false;

    protected SpringBootModelConfigFileContributor(FileType fileType) {
        this.myFileType = fileType;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    public List<VirtualFile> getConfigurationFiles(Module module, boolean includeTestScope) {
        return ContainerUtil.concat(this.getDefaultConfigurationFiles(module, includeTestScope), this.getUserConfigurationFiles(module, includeTestScope));
    }

    public List<VirtualFile> getDefaultConfigurationFiles(Module module, boolean includeTestScope) {
        return this.findApplicationConfigFiles(module, includeTestScope, "bootstrap");
    }

    public List<VirtualFile> getUserConfigurationFiles(Module module, boolean includeTestScope) {
        String springConfigName = SpringBootModelConfigFileContributor.getSpringConfigName(module);
        List<VirtualFile> userConfigurationFiles = this.findApplicationConfigFiles(module, includeTestScope, springConfigName);
        return ContainerUtil.concat(userConfigurationFiles, SpringBootModelConfigFileContributor.findCustomConfigFiles(module));
    }

    private static List<VirtualFile> findCustomConfigFiles(Module module) {
        SpringFacet springFacet = SpringBootModelConfigFileContributor.getRelevantFacet(module);
        if (springFacet == null) {
            return Collections.emptyList();
        }
        CustomSetting.STRING setting = (CustomSetting.STRING)springFacet.findSetting(SPRING_CONFIG_CUSTOM_FILES_ID);
        assert (setting != null);
        String value = setting.getStringValue();
        if (value == null) {
            return Collections.emptyList();
        }
        List urls = StringUtil.split((String)value, (String)";");
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(urls.size());
        for (String url : urls) {
            VirtualFile configFile = VirtualFileManager.getInstance().findFileByUrl(url);
            ContainerUtil.addIfNotNull(files, (Object)configFile);
        }
        return files;
    }

    @NotNull
    private static String getSpringConfigName(Module module) {
        SpringFacet springFacet = SpringBootModelConfigFileContributor.getRelevantFacet(module);
        if (springFacet == null) {
            if (SPRING_CONFIG_NAME_DEFAULT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor", "getSpringConfigName"));
            }
            return SPRING_CONFIG_NAME_DEFAULT;
        }
        CustomSetting.STRING setting = (CustomSetting.STRING)springFacet.findSetting(SPRING_CONFIG_NAME_CUSTOM_SETTING_ID);
        assert (setting != null);
        String string = StringUtil.notNullize((String)setting.getStringValue(), (String)setting.getDefaultValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor", "getSpringConfigName"));
        }
        return string;
    }

    @Nullable
    private static SpringFacet getRelevantFacet(Module module) {
        if (module.isDisposed()) {
            return null;
        }
        SpringFacet facet = SpringBootModelConfigFileContributor.findSpringBootApplicationFacet(module);
        if (facet != null) {
            return facet;
        }
        for (Module dependentModule : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            SpringFacet dependentFacet = SpringBootModelConfigFileContributor.findSpringBootApplicationFacet(dependentModule);
            if (dependentFacet == null) continue;
            return dependentFacet;
        }
        return null;
    }

    @Nullable
    private static SpringFacet findSpringBootApplicationFacet(Module module) {
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        List<PsiClass> applications = SpringBootApplicationUtil.getSpringApplications(module);
        return applications.isEmpty() ? null : springFacet;
    }

    public List<VirtualFile> findApplicationConfigFiles(Module module, boolean includeTestScope, @NotNull String baseName) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor", "findApplicationConfigFiles"));
        }
        List<VirtualFile> productionConfigFiles = this.findConfigFilesInScope(module, false, baseName);
        if (!includeTestScope) {
            return productionConfigFiles;
        }
        List<VirtualFile> testConfigFiles = this.findConfigFilesInScope(module, true, baseName);
        return ContainerUtil.concat(productionConfigFiles, testConfigFiles);
    }

    private List<VirtualFile> findConfigFilesInScope(Module module, boolean testScope, @NotNull String baseName) {
        GlobalSearchScope searchScope;
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor", "findConfigFilesInScope"));
        }
        GlobalSearchScope configFileSearchScope = this.getConfigFileSearchScope(module, testScope);
        if (configFileSearchScope == null) {
            return Collections.emptyList();
        }
        Collection<VirtualFile> baseNameConfigFiles = this.findBaseNameConfigFiles(baseName, configFileSearchScope);
        if (baseNameConfigFiles.size() > 1) {
            return Collections.emptyList();
        }
        VirtualFile baseNameConfigFile = (VirtualFile)ContainerUtil.getFirstItem(baseNameConfigFiles);
        boolean foundNonProfileConfig = baseNameConfigFile != null;
        SmartList result = new SmartList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)baseNameConfigFile);
        if (foundNonProfileConfig) {
            VirtualFile parentDirectory = baseNameConfigFile.getParent();
            if (parentDirectory == null) {
                return result;
            }
            searchScope = GlobalSearchScopesCore.directoryScope((Project)module.getProject(), (VirtualFile)parentDirectory, (boolean)false);
        } else {
            searchScope = configFileSearchScope;
        }
        Collection allByTypeInScope = FileTypeIndex.getFiles((FileType)this.myFileType, (GlobalSearchScope)searchScope);
        String fileNamePrefix = baseName + '-';
        List matching = ContainerUtil.filter((Collection)allByTypeInScope, file -> {
            if (baseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor", "lambda$findConfigFilesInScope$1"));
            }
            return !foundNonProfileConfig && Comparing.equal((String)baseName, (String)file.getNameWithoutExtension()) || StringUtil.startsWith((CharSequence)file.getNameWithoutExtension(), (CharSequence)fileNamePrefix);
        });
        Collections.sort(matching, VF_BY_NAME_COMPARATOR);
        result.addAll(matching);
        return result;
    }

    @NotNull
    private Collection<VirtualFile> findBaseNameConfigFiles(String baseName, GlobalSearchScope configFileSearchScope) {
        Collection allFiles = FileTypeIndex.getFiles((FileType)this.myFileType, (GlobalSearchScope)configFileSearchScope);
        List list = ContainerUtil.filter((Collection)allFiles, file -> Comparing.equal((String)baseName, (String)file.getNameWithoutExtension()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor", "findBaseNameConfigFiles"));
        }
        return list;
    }

    @Nullable
    public GlobalSearchScope getConfigFileSearchScope(Module module, boolean testScope) {
        if (OUR_TEST_MODE && !USE_RESOURCE_ROOTS_FOR_TESTS) {
            return module.getModuleScope(false);
        }
        if (module.isDisposed()) {
            return null;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List resourceRoots = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)(testScope ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE));
        if (resourceRoots.isEmpty()) {
            return null;
        }
        return GlobalSearchScopesCore.directoriesScope((Project)module.getProject(), (boolean)true, (VirtualFile[])resourceRoots.toArray(new VirtualFile[resourceRoots.size()]));
    }

    @Nullable
    public abstract ConfigurationValueResult findConfigurationValue(PsiFile var1, SpringBootApplicationMetaConfigKey var2, boolean var3, @Nullable Set<String> var4);

    static void setUseResourceRootsForTests(boolean useResourceRootsForTests) {
        USE_RESOURCE_ROOTS_FOR_TESTS = useResourceRootsForTests;
    }

    public static class ConfigurationValueResult {
        @Nullable
        public PsiElement keyElement;
        @Nullable
        public PsiElement valueElement;
        @Nullable
        public String valueText;

        public ConfigurationValueResult(@Nullable PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText) {
            this.keyElement = keyElement;
            this.valueElement = valueElement;
            this.valueText = valueText;
        }
    }
}

