/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.util.net.NetUtils;

public class SpringBootApplicationOpenInBrowserAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        RunProfile runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE);
        if (!(runProfile instanceof SpringBootApplicationRunConfiguration)) {
            return;
        }
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        ProcessHandler handler = SpringBootApplicationOpenInBrowserAction.getProcessHandler(e);
        if (handler == null) {
            return;
        }
        String url = SpringBootApplicationOpenInBrowserAction.getApplicationUrl((SpringBootApplicationRunConfiguration)runProfile, project, handler);
        if (url != null) {
            BrowserUtil.browse((String)url);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        RunProfile runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE);
        if (!(runProfile instanceof SpringBootApplicationRunConfiguration)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        ProcessHandler handler = SpringBootApplicationOpenInBrowserAction.getProcessHandler(e);
        if (handler == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (!SpringBootApplicationLifecycleManager.getInstance((Project)project).isLifecycleManagementEnabled(handler)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        String url = SpringBootApplicationOpenInBrowserAction.getApplicationUrl((SpringBootApplicationRunConfiguration)runProfile, project, handler);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(url != null);
        } else {
            presentation.setVisible(true);
        }
        presentation.setEnabled(url != null);
        if (url == null) {
            presentation.setDescription(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.open.in.browser.action.description", new Object[0]));
        } else {
            presentation.setDescription(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.open.url", url));
        }
    }

    private static ProcessHandler getProcessHandler(AnActionEvent e) {
        RunContentDescriptor descriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        return descriptor != null ? descriptor.getProcessHandler() : null;
    }

    private static String getApplicationUrl(SpringBootApplicationRunConfiguration runConfiguration, Project project, ProcessHandler handler) {
        String mappingPath;
        SpringBootApplicationInfo info = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfo(handler);
        if (info == null) {
            return null;
        }
        int serverPort = SpringBootApplicationOpenInBrowserAction.getServerPort(info);
        if (serverPort <= 0) {
            return null;
        }
        String path = "";
        String scheme = "http";
        String address = NetUtils.getLocalHostString();
        SpringBootApplicationServerConfiguration serverConfiguration = (SpringBootApplicationServerConfiguration)info.getServerConfiguration().getValue();
        if (serverConfiguration != null) {
            String serverAddress;
            String servletPath;
            String contextPath;
            if (serverConfiguration.isSslEnabled()) {
                scheme = "https";
            }
            if ((contextPath = serverConfiguration.getContextPath()) != null) {
                path = path + contextPath;
            }
            if ((servletPath = serverConfiguration.getServletPath()) != null) {
                path = path + servletPath;
            }
            if (StringUtil.isNotEmpty((String)(serverAddress = serverConfiguration.getAddress()))) {
                address = serverAddress;
            }
        }
        if ((mappingPath = runConfiguration.getUrlPath()) == null) {
            mappingPath = "/";
        } else if (!mappingPath.startsWith("/")) {
            mappingPath = "/" + mappingPath;
        }
        path = path + mappingPath;
        return scheme + "://" + address + ":" + serverPort + path;
    }

    private static int getServerPort(SpringBootApplicationInfo info) {
        if (!Boolean.TRUE.equals(info.getReadyState().getValue())) {
            return -1;
        }
        Integer serverPort = (Integer)info.getServerPort().getValue();
        return serverPort == null ? -1 : serverPort;
    }
}

