/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootRunUsagesCollector
extends AbstractApplicationUsagesCollector {
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Spring Boot Run");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/SpringBootRunUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootRunUsagesCollector", "getProjectUsages"));
        }
        HashSet usages = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> SpringBootRunUsagesCollector.lambda$getProjectUsages$1(project, (Set)usages));
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/SpringBootRunUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    private static void recordRunConfigBoolean(Set<UsageDescriptor> usages, String name, boolean value) {
        String key = "RunConfig_" + name + "_" + (value ? "ON" : "OFF");
        usages.add(new UsageDescriptor(key));
    }

    private static /* synthetic */ void lambda$getProjectUsages$1(@NotNull Project project, Set usages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootRunUsagesCollector", "lambda$getProjectUsages$1"));
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return;
        }
        List runnerAndConfigurationSettings = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
        usages.add(new UsageDescriptor("RunConfigsPerProject_" + runnerAndConfigurationSettings.size()));
        boolean showRunDashboard = false;
        HashMap mainClassCounter = new HashMap();
        for (RunnerAndConfigurationSettings settings : runnerAndConfigurationSettings) {
            RunConfiguration configuration = settings.getConfiguration();
            if (!(configuration instanceof SpringBootApplicationRunConfiguration)) continue;
            SpringBootApplicationRunConfiguration sbRunConfig = (SpringBootApplicationRunConfiguration)configuration;
            showRunDashboard = showRunDashboard || sbRunConfig.isShowInDashboard();
            mainClassCounter.merge(sbRunConfig.getSpringBootMainClass(), 1, (integer, integer2) -> integer + 1);
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "ActiveProfilesSet", StringUtil.isNotEmpty((String)sbRunConfig.getActiveProfiles()));
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "HideBanner", sbRunConfig.isHideBanner());
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "DebugMode", sbRunConfig.isDebugMode());
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "EnableLaunchOptimization", sbRunConfig.isEnableLaunchOptimization());
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "EnableJmxAgent", sbRunConfig.isEnableJmxAgent());
            List<SpringBootAdditionalParameter> parameters = sbRunConfig.getAdditionalParameters();
            int additionalParamsSize = parameters.size();
            usages.add(new UsageDescriptor("RunConfig_AdditionalParams_Total_" + additionalParamsSize));
            if (additionalParamsSize <= 0) continue;
            long enabledParams = parameters.stream().filter(SpringBootAdditionalParameter::isEnabled).count();
            usages.add(new UsageDescriptor("RunConfig_AdditionalParams_Enabled_" + enabledParams));
            usages.add(new UsageDescriptor("RunConfig_AdditionalParams_Disabled_" + ((long)additionalParamsSize - enabledParams)));
        }
        usages.add(new UsageDescriptor("RunDashboardInProject_" + (showRunDashboard ? "ON" : "OFF")));
        for (Integer integer3 : mainClassCounter.values()) {
            usages.add(new UsageDescriptor("RunConfig_MainClass_Count_" + integer3));
        }
    }
}

