/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootActuatorConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootJmxConnector;
import org.jetbrains.annotations.Nullable;

abstract class EndpointLiveProperty<T>
extends AsyncLiveProperty<T> {
    private final LiveProperty<Boolean> myActuatorsEnabled;
    private final String myEndpointId;
    private final String myEndpointName;

    EndpointLiveProperty(String endpointId, String endpointName, LiveProperty<Boolean> actuatorsEnabled, int jmxPort, LifecycleErrorHandler errorHandler, Disposable parent) {
        super(jmxPort, errorHandler, parent);
        this.myEndpointId = endpointId;
        this.myEndpointName = endpointName;
        this.myActuatorsEnabled = actuatorsEnabled;
    }

    @Override
    public T doCompute() throws LifecycleException {
        Throwable throwable;
        SpringBootJmxConnector connector;
        if (Boolean.FALSE.equals(this.myActuatorsEnabled.getValue())) {
            return null;
        }
        String endpointDomain = "org.springframework.boot";
        String endpointDisabledMessage = null;
        try {
            connector = new SpringBootApplicationConnector(this.getJmxPort());
            throwable = null;
            try {
                if (!((SpringBootApplicationConnector)connector).getBooleanProperty("endpoints.jmx.enabled", true)) {
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.property.is.set.to.false", "endpoints.jmx.enabled");
                } else {
                    boolean endpointsEnabled = ((SpringBootApplicationConnector)connector).getBooleanProperty("endpoints.enabled", true);
                    boolean endpointEnabled = ((SpringBootApplicationConnector)connector).getBooleanProperty(String.format("endpoints.%s.enabled", this.myEndpointId), endpointsEnabled);
                    if (!endpointEnabled) {
                        String propertyName = endpointsEnabled ? String.format("endpoints.%s.enabled", this.myEndpointId) : "endpoints.enabled";
                        endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.property.is.set.to.false", propertyName);
                    } else {
                        Object o = ((SpringBootApplicationConnector)connector).getProperty("endpoints.jmx.domain");
                        if (o instanceof String) {
                            endpointDomain = (String)o;
                        } else {
                            o = ((SpringBootApplicationConnector)connector).getProperty("spring.jmx.default-domain");
                            if (o instanceof String) {
                                endpointDomain = (String)o;
                            }
                        }
                    }
                }
            }
            catch (Throwable endpointsEnabled) {
                throwable = endpointsEnabled;
                throw endpointsEnabled;
            }
            finally {
                if (connector != null) {
                    if (throwable != null) {
                        try {
                            connector.close();
                        }
                        catch (Throwable endpointsEnabled) {
                            throwable.addSuppressed(endpointsEnabled);
                        }
                    } else {
                        connector.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", this.myEndpointId, e.getLocalizedMessage()), e);
        }
        if (endpointDisabledMessage != null) {
            throw new LifecycleException(null, new Exception(endpointDisabledMessage));
        }
        connector = new SpringBootActuatorConnector(this.getJmxPort(), endpointDomain, this.myEndpointName);
        throwable = null;
        try {
            T endpointsEnabled = this.parseData(((SpringBootActuatorConnector)connector).getData());
            return endpointsEnabled;
        }
        catch (Exception e) {
            try {
                throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", this.myEndpointId, e.getLocalizedMessage()), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            if (connector != null) {
                if (throwable != null) {
                    try {
                        connector.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    connector.close();
                }
            }
        }
    }

    protected abstract T parseData(@Nullable Object var1);
}

