/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.mappings;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveHandlerMethodImpl
implements LiveHandlerMethod {
    private static final Set<String> MODIFIERS = ContainerUtil.immutableSet((Object[])PsiModifier.MODIFIERS);
    @NotNull
    private final String myRawMethod;
    private String myClassName;
    private String myMethodName;
    private final List<String> myParameters;

    LiveHandlerMethodImpl(@NotNull String rawMethod) {
        int nameEnd;
        int modifiersEnd;
        if (rawMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawMethod", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "<init>"));
        }
        this.myClassName = "";
        this.myMethodName = "";
        this.myParameters = ContainerUtil.newSmartList();
        this.myRawMethod = rawMethod;
        rawMethod = rawMethod.replaceAll(",\\s", ",");
        String[] parts = rawMethod.split("\\s");
        for (modifiersEnd = 0; modifiersEnd < parts.length && LiveHandlerMethodImpl.isModifier(parts[modifiersEnd]); ++modifiersEnd) {
        }
        if (parts.length >= modifiersEnd + 2 && (nameEnd = (rawMethod = parts[modifiersEnd + 1]).indexOf(40)) >= 0) {
            String parameters;
            int methodEnd;
            int nameStart = rawMethod.lastIndexOf(46, nameEnd);
            if (nameStart >= 0) {
                this.myClassName = rawMethod.substring(0, nameStart);
                this.myMethodName = rawMethod.substring(nameStart + 1, nameEnd);
            }
            if ((methodEnd = rawMethod.lastIndexOf(41)) > nameEnd && !(parameters = rawMethod.substring(nameEnd + 1, methodEnd)).isEmpty()) {
                this.myParameters.addAll(Arrays.asList(parameters.split(",")));
            }
        }
    }

    @NotNull
    public String getRawMethod() {
        String string = this.myRawMethod;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getRawMethod"));
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getClassName"));
        }
        return string;
    }

    @NotNull
    public String getMethodName() {
        String string = this.myMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getMethodName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        if (this.myClassName.isEmpty() || this.myMethodName.isEmpty()) {
            String string = this.myRawMethod;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getDisplayName"));
            }
            return string;
        }
        String className = this.myClassName;
        int classNameIndex = className.lastIndexOf(46);
        if (classNameIndex >= 0 && classNameIndex < className.length() - 1) {
            className = className.substring(classNameIndex + 1);
        }
        String string = className + "#" + this.myMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public PsiClass getContainingClass(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getContainingClass"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getContainingClass"));
        }
        return JavaExecutionUtil.findMainClass((Project)project, (String)this.myClassName, (GlobalSearchScope)searchScope);
    }

    @Nullable
    public PsiMethod getMethod(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        PsiMethod[] methods;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getMethod"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/mappings/LiveHandlerMethodImpl", "getMethod"));
        }
        PsiClass psiClass = this.getContainingClass(project, searchScope);
        if (psiClass == null) {
            return null;
        }
        for (PsiMethod method : methods = psiClass.findMethodsByName(this.myMethodName, false)) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != this.myParameters.size()) continue;
            boolean matched = true;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                String liveParameter = this.myParameters.get(i);
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null) {
                    matched = false;
                    break;
                }
                if (liveParameter.equals(typeElement.getType().getCanonicalText())) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return method;
        }
        return methods.length > 0 ? methods[0] : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveHandlerMethodImpl) {
            return this.myRawMethod.equals(((LiveHandlerMethodImpl)obj).myRawMethod);
        }
        return false;
    }

    public int hashCode() {
        return this.myRawMethod.hashCode();
    }

    public String toString() {
        return this.myRawMethod;
    }

    private static boolean isModifier(String string) {
        return MODIFIERS.contains(string);
    }
}

