/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.mappings;

import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingImpl;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModelImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class LiveRequestMappingsParser {
    private static final String BEAN_ATTRIBUTE = "bean";
    private static final String METHOD_ATTRIBUTE = "method";

    @NotNull
    public LiveRequestMappingsModel parse(Map<?, ?> mappings) {
        if (mappings == null) {
            LiveRequestMappingsModelImpl liveRequestMappingsModelImpl = new LiveRequestMappingsModelImpl(Collections.emptyList());
            if (liveRequestMappingsModelImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingsParser", "parse"));
            }
            return liveRequestMappingsModelImpl;
        }
        ArrayList liveMappings = new ArrayList();
        mappings.forEach((key, details) -> {
            if (key instanceof String && details instanceof Map) {
                liveMappings.addAll(LiveRequestMappingsParser.parse((String)key, (Map)details));
            }
        });
        LiveRequestMappingsModelImpl liveRequestMappingsModelImpl = new LiveRequestMappingsModelImpl(liveMappings);
        if (liveRequestMappingsModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingsParser", "parse"));
        }
        return liveRequestMappingsModelImpl;
    }

    @NotNull
    private static List<LiveRequestMapping> parse(@NotNull String mappingKey, @NotNull Map<?, ?> detailsMap) {
        if (mappingKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappingKey", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingsParser", "parse"));
        }
        if (detailsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsMap", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingsParser", "parse"));
        }
        Object beanValue = detailsMap.get(BEAN_ATTRIBUTE);
        String bean = beanValue == null ? null : beanValue.toString();
        Object methodValue = detailsMap.get(METHOD_ATTRIBUTE);
        String method = methodValue == null ? null : methodValue.toString();
        String fullPath = LiveRequestMappingsParser.extractPath(mappingKey);
        String[] paths = fullPath.split(Pattern.quote("||"));
        List<LiveRequestMapping> list = Arrays.stream(paths).map(path -> {
            if (mappingKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappingKey", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingsParser", "lambda$parse$1"));
            }
            return new LiveRequestMappingImpl(mappingKey, path.trim(), bean, method);
        }).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingsParser", "parse"));
        }
        return list;
    }

    private static String extractPath(String key) {
        if (key.startsWith("{[")) {
            int start = 2;
            int end = key.indexOf(93);
            if (end >= start) {
                return key.substring(start, end);
            }
        }
        return key;
    }
}

