/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class HealthTreeStructure
extends SimpleTreeStructure {
    static final String STATUS_UP = "UP";
    static final String STATUS_DOWN = "DOWN";
    static final String STATUS_OUT_OF_SERVICE = "OUT_OF_SERVICE";
    static final String STATUS_UNKNOWN = "UNKNOWN";
    static final String APPLICATION_NODE_NAME = "application";
    static final String STATUS_KEY = "status";
    @NotNull
    private final SimpleNode myRootNode;
    private StatusNode myApplicationStatusNode;

    HealthTreeStructure(Project project) {
        this.myRootNode = new SimpleNode(project){

            public SimpleNode[] getChildren() {
                if (HealthTreeStructure.this.myApplicationStatusNode == null) {
                    return NO_CHILDREN;
                }
                return new SimpleNode[]{HealthTreeStructure.this.myApplicationStatusNode};
            }
        };
    }

    public Object getRootElement() {
        return this.myRootNode;
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        return true;
    }

    void setHealth(Map health) {
        this.myApplicationStatusNode = health == null ? null : new StatusNode(this.myRootNode.getProject(), this.myRootNode, APPLICATION_NODE_NAME, health);
    }

    private static class DetailsNode
    extends SimpleNode {
        DetailsNode(Project project, SimpleNode parent, String key, Object value) {
            super(project, (NodeDescriptor)parent);
            this.myName = key;
            PresentationData presentationData = this.getTemplatePresentation();
            presentationData.addText(key + ": ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            String valueString = value.toString();
            if (value instanceof Number) {
                try {
                    valueString = NumberFormat.getInstance().format(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            presentationData.addText(valueString, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        public SimpleNode[] getChildren() {
            return NO_CHILDREN;
        }

        public boolean isAlwaysLeaf() {
            return true;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myName, this.getParent()};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTreeStructure$DetailsNode", "getEqualityObjects"));
            }
            return objectArray;
        }
    }

    private static class StatusNode
    extends SimpleNode {
        private final Map<?, ?> myDetails;
        private SimpleNode[] myChildren;

        StatusNode(Project project, SimpleNode parent, String name, Map<?, ?> details) {
            super(project, (NodeDescriptor)parent);
            this.myName = name;
            this.myDetails = details;
            PresentationData presentationData = this.getTemplatePresentation();
            presentationData.addText(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Object status = details.get(HealthTreeStructure.STATUS_KEY);
            if (status instanceof String) {
                presentationData.setTooltip(SpringBootRunBundle.message("spring.boot.application.endpoints.health.status", status));
                if (HealthTreeStructure.STATUS_UP.equals(status)) {
                    this.setIcon(AllIcons.RunConfigurations.TestPassed);
                } else if (HealthTreeStructure.STATUS_DOWN.equals(status)) {
                    this.setIcon(AllIcons.RunConfigurations.TestFailed);
                } else if (HealthTreeStructure.STATUS_OUT_OF_SERVICE.equals(status)) {
                    this.setIcon(AllIcons.RunConfigurations.TestError);
                } else if (HealthTreeStructure.STATUS_UNKNOWN.equals(status)) {
                    this.setIcon(AllIcons.RunConfigurations.TestUnknown);
                } else {
                    presentationData.addText(" [" + status + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.setIcon(AllIcons.RunConfigurations.TestCustom);
                }
            }
        }

        public SimpleNode[] getChildren() {
            if (this.myChildren != null) {
                return this.myChildren;
            }
            ArrayList children = new ArrayList();
            this.myDetails.forEach((key, value) -> {
                if (key == null || value == null || HealthTreeStructure.STATUS_KEY.equals(key)) {
                    return;
                }
                if (value instanceof Map && !((Map)value).isEmpty()) {
                    children.add(new StatusNode(this.getProject(), this, key.toString(), (Map)value));
                } else {
                    children.add(new DetailsNode(this.getProject(), this, key.toString(), value));
                }
            });
            Collections.sort(children, (o1, o2) -> {
                if (o1 instanceof StatusNode) {
                    if (o2 instanceof DetailsNode) {
                        return 1;
                    }
                    return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
                }
                if (o2 instanceof StatusNode) {
                    return -1;
                }
                return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            });
            this.myChildren = children.toArray(NO_CHILDREN);
            return this.myChildren;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myName, this.getParent()};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTreeStructure$StatusNode", "getEqualityObjects"));
            }
            return objectArray;
        }

        public boolean isAutoExpandNode() {
            return !(this.getParent() instanceof StatusNode);
        }
    }
}

