/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveContext;
import com.intellij.spring.boot.run.lifecycle.tabs.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveResourcesPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import icons.SpringApiIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveContextsPanel
extends LifecycleFinderRecursivePanel<LiveContext> {
    private static final String LIVE_CONTEXTS_PANEL_GROUP_ID = "LiveContextsPanel";

    LiveContextsPanel(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/tabs/LiveContextsPanel", "<init>"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/lifecycle/tabs/LiveContextsPanel", "<init>"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/spring/boot/run/lifecycle/tabs/LiveContextsPanel", "<init>"));
        }
        super(project, null, LIVE_CONTEXTS_PANEL_GROUP_ID, runConfiguration, processHandler);
    }

    @NotNull
    protected List<LiveContext> getListItems() {
        LiveBeansModel model = this.getModel();
        if (model == null) {
            List<LiveContext> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LiveContextsPanel", "getListItems"));
            }
            return list;
        }
        List contexts = model.getContexts();
        Collections.sort(contexts, Comparator.comparing(LiveContext::getName, NaturalComparator.INSTANCE));
        List list = contexts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LiveContextsPanel", "getListItems"));
        }
        return list;
    }

    @NotNull
    protected String getItemText(LiveContext context) {
        String string = context.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LiveContextsPanel", "getItemText"));
        }
        return string;
    }

    protected boolean hasChildren(LiveContext context) {
        return true;
    }

    @Nullable
    protected Icon getItemIcon(LiveContext context) {
        return SpringApiIcons.FileSet;
    }

    @Nullable
    protected JComponent createRightComponent(LiveContext context) {
        if (SpringBootEndpointsTabSettings.getInstance(this.getProject()).isShowFiles()) {
            return new LiveResourcesPanel(this.getProject(), this, this.getGroupId(), this.getRunConfiguration(), this.getProcessHandler(), context);
        }
        return new LiveBeansPanel(this.getProject(), this, this.getGroupId(), this.getRunConfiguration(), this.getProcessHandler(), context, null);
    }

    protected boolean isEditable() {
        return false;
    }

    @Nullable
    protected String getItemTooltipText(LiveContext context) {
        if (context.getParent() == null) {
            return SpringBootRunBundle.message("spring.boot.application.endpoints.root.context", new Object[0]);
        }
        return SpringBootRunBundle.message("spring.boot.application.endpoints.parent.context", context.getParent().getName());
    }
}

