/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.LiveResource;
import com.intellij.spring.boot.run.lifecycle.tabs.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.ui.FinderRecursivePanel;
import icons.SpringApiIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveResourcesPanel
extends LifecycleFinderRecursivePanel<LiveResourceItem> {
    private static final String LIVE_RESOURCES_PANEL_GROUP_ID = "LiveResourcesPanel";
    private final LiveContext myContext;

    LiveResourcesPanel(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "<init>"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "<init>"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "<init>"));
        }
        this(project, null, LIVE_RESOURCES_PANEL_GROUP_ID, runConfiguration, processHandler, null);
    }

    LiveResourcesPanel(@NotNull Project project, @Nullable FinderRecursivePanel parent, @Nullable String groupId, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler, @Nullable LiveContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "<init>"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "<init>"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "<init>"));
        }
        super(project, parent, groupId, runConfiguration, processHandler);
        this.myContext = context;
    }

    @NotNull
    protected List<LiveResourceItem> getListItems() {
        List resources;
        if (this.myContext != null) {
            resources = this.myContext.getResources();
        } else {
            LiveBeansModel model = this.getModel();
            if (model == null) {
                List<LiveResourceItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "getListItems"));
                }
                return list;
            }
            resources = model.getResources();
        }
        Collections.sort(resources, Comparator.comparing(LiveResource::getDisplayName, NaturalComparator.INSTANCE));
        SpringBootApplicationRunConfiguration runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)this.getRunConfiguration().getConfigurationModule()).getSearchScope();
        List<LiveResourceItem> list = resources.stream().map(resource -> new LiveResourceItem(this.getProject(), (LiveResource)resource, module, mainClass, searchScope)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "getListItems"));
        }
        return list;
    }

    @NotNull
    protected String getItemText(LiveResourceItem item) {
        String string = item.getResource().getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "getItemText"));
        }
        return string;
    }

    protected boolean hasChildren(LiveResourceItem item) {
        return true;
    }

    @Nullable
    protected Icon getItemIcon(LiveResourceItem item) {
        Navigatable navigatable = item.getNavigatable();
        if (navigatable instanceof PsiFile) {
            return ((PsiFile)navigatable).getIcon(0);
        }
        Icon icon = item.getResource().getIcon();
        return icon == null ? SpringApiIcons.SpringJavaConfig : icon;
    }

    @Nullable
    protected JComponent createRightComponent(LiveResourceItem item) {
        return new LiveBeansPanel(this.getProject(), this, this.getGroupId(), this.getRunConfiguration(), this.getProcessHandler(), null, item.getResource());
    }

    @Nullable
    protected String getItemTooltipText(LiveResourceItem item) {
        if (item.getResource().hasDescription()) {
            return item.getResource().getDescription();
        }
        return item.getResource().getDisplayName();
    }

    @Nullable
    protected VirtualFile getContainingFile(LiveResourceItem item) {
        Navigatable navigatable = item.getNavigatable();
        if (!(navigatable instanceof PsiElement)) {
            return null;
        }
        PsiElement psiElement = (PsiElement)navigatable;
        if (psiElement.isValid() && psiElement.getContainingFile() != null) {
            return psiElement.getContainingFile().getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        LiveResourceItem selectedValue = (LiveResourceItem)this.getSelectedValue();
        if (selectedValue != null) {
            Navigatable navigatable = selectedValue.getNavigatable();
            if (CommonDataKeys.NAVIGATABLE.is(dataId) || CommonDataKeys.PSI_ELEMENT.is(dataId) && navigatable instanceof PsiElement) {
                return navigatable;
            }
            if (CommonDataKeys.PSI_FILE.is(dataId) && navigatable instanceof PsiElement) {
                return ((PsiElement)navigatable).getContainingFile();
            }
        }
        return super.getData(dataId);
    }

    @Override
    protected boolean doUpdateItem(@NotNull LiveResourceItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "doUpdateItem"));
        }
        SpringBootApplicationRunConfiguration runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)this.getRunConfiguration().getConfigurationModule()).getSearchScope();
        return item.updateItem(module, mainClass, searchScope);
    }

    @Override
    protected String getEditActionHintMessage(@NotNull LiveResourceItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel", "getEditActionHintMessage"));
        }
        return SpringBootRunBundle.message("spring.boot.application.endpoints.config.file.not.found", new Object[0]);
    }

    static class LiveResourceItem {
        @NotNull
        private final Project myProject;
        @NotNull
        private final LiveResource myResource;
        @Nullable
        private Navigatable myNavigatable;

        LiveResourceItem(@NotNull Project project, @NotNull LiveResource resource, @Nullable Module module, @Nullable PsiClass mainClass, @NotNull GlobalSearchScope searchScope) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel$LiveResourceItem", "<init>"));
            }
            if (resource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel$LiveResourceItem", "<init>"));
            }
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel$LiveResourceItem", "<init>"));
            }
            this.myProject = project;
            this.myResource = resource;
            this.updateItem(module, mainClass, searchScope);
        }

        @NotNull
        public LiveResource getResource() {
            LiveResource liveResource = this.myResource;
            if (liveResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel$LiveResourceItem", "getResource"));
            }
            return liveResource;
        }

        @Nullable
        public Navigatable getNavigatable() {
            return DumbService.isDumb((Project)this.myProject) ? null : this.myNavigatable;
        }

        public boolean updateItem(@Nullable Module module, @Nullable PsiClass mainClass, @NotNull GlobalSearchScope searchScope) {
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel$LiveResourceItem", "updateItem"));
            }
            Navigatable navigatable = this.myResource.getResourceNavigatable(this.myProject, module, (PsiElement)mainClass, searchScope);
            boolean changed = !Comparing.equal((Object)this.myNavigatable, (Object)navigatable);
            this.myNavigatable = navigatable;
            return changed;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LiveResourceItem) {
                return this.myResource.equals(((LiveResourceItem)obj).myResource);
            }
            return false;
        }

        public int hashCode() {
            return this.myResource.hashCode();
        }
    }
}

