/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.tools.resources.AbstractContainer;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ResourceSpace;
import org.w3c.tools.resources.SpaceEntry;
import org.w3c.tools.resources.SpaceEntryImpl;
import org.w3c.tools.resources.event.StructureChangedEvent;
import org.w3c.tools.resources.store.ResourceStoreManager;

public class ContainerResource
extends AbstractContainer {
    public static boolean debug = false;
    protected static int ATTR_KEY = -1;
    protected boolean acquired = false;

    public Object getClone(Object[] objectArray) {
        objectArray[ContainerResource.ATTR_KEY] = null;
        return super.getClone(objectArray);
    }

    public Integer getKey() {
        Integer n = (Integer)this.unsafeGetValue(ATTR_KEY, null);
        if (n == null) {
            n = new Integer(this.getIdentifier().hashCode() ^ new Date().hashCode());
            if (debug) {
                System.out.println("*** new key is: " + n);
            }
            ResourceStoreManager resourceStoreManager = this.getServer().getResourceStoreManager();
            while (!resourceStoreManager.checkKey(n)) {
                n = new Integer((int)(1.9 * (Math.random() - 0.5) * 2.147483647E9));
                if (!debug) continue;
                System.out.println("*** updated key is: " + n);
            }
            this.setValue(ATTR_KEY, (Object)n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SpaceEntry getSpaceEntry() {
        ResourceReference resourceReference = this.getParent();
        if (resourceReference == null) {
            return new SpaceEntryImpl(this);
        }
        try {
            ContainerResource containerResource = (ContainerResource)resourceReference.lock();
            SpaceEntryImpl spaceEntryImpl = new SpaceEntryImpl(containerResource);
            return spaceEntryImpl;
        }
        catch (InvalidResourceException invalidResourceException) {
            System.out.println(invalidResourceException.getMessage());
            invalidResourceException.printStackTrace();
            SpaceEntry spaceEntry = null;
            return spaceEntry;
        }
        finally {
            resourceReference.unlock();
        }
    }

    protected SpaceEntry getChildrenSpaceEntry() {
        return new SpaceEntryImpl(this);
    }

    public void resourceModified(StructureChangedEvent structureChangedEvent) {
        if (!this.isUnloaded()) {
            super.resourceModified(structureChangedEvent);
        }
    }

    public void resourceCreated(StructureChangedEvent structureChangedEvent) {
        if (!this.isUnloaded()) {
            super.resourceCreated(structureChangedEvent);
        }
    }

    public void resourceRemoved(StructureChangedEvent structureChangedEvent) {
        if (!this.isUnloaded()) {
            super.resourceRemoved(structureChangedEvent);
        }
    }

    protected ResourceContext updateDefaultChildAttributes(Hashtable hashtable) {
        String string;
        ResourceContext resourceContext = super.updateDefaultChildAttributes(hashtable);
        if (resourceContext == null) {
            resourceContext = new ResourceContext(this.getContext());
            hashtable.put(co, resourceContext);
        }
        if ((string = (String)hashtable.get(id)) != null) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(this.getURLPath());
            stringBuffer.append(URLEncoder.encode(string));
            hashtable.put(ur, stringBuffer.toString());
        }
        return resourceContext;
    }

    public synchronized Enumeration enumerateResourceIdentifiers(boolean bl) {
        ResourceSpace resourceSpace = this.getSpace();
        this.acquireChildren();
        return resourceSpace.enumerateResourceIdentifiers(this.getChildrenSpaceEntry());
    }

    public ResourceReference createDefaultResource(String string) {
        return null;
    }

    protected int getMatchingCharsCount(String string, String string2) {
        int n = -1;
        int n2 = 0;
        if (string == null || string2 == null || (n = string.length()) != string2.length()) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i))) {
                ++n2;
                continue;
            }
            if ((c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c))) continue;
            return -1;
        }
        return n2;
    }

    public ResourceReference lookup(String string) {
        this.acquireChildren();
        SpaceEntry spaceEntry = this.getChildrenSpaceEntry();
        ResourceSpace resourceSpace = this.getSpace();
        ResourceReference resourceReference = this.internalLookup(string, spaceEntry, resourceSpace);
        if (resourceReference == null && !this.getServer().checkFileSystemSensitivity()) {
            Enumeration enumeration = resourceSpace.enumerateResourceIdentifiers(spaceEntry);
            int n = -1;
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                int n2 = this.getMatchingCharsCount(string, string3);
                if (n2 <= n) continue;
                n = n2;
                string2 = string3;
            }
            if (string2 != null) {
                resourceReference = this.internalLookup(string2, spaceEntry, resourceSpace);
            }
        }
        return resourceReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceReference internalLookup(String string, SpaceEntry spaceEntry, ResourceSpace resourceSpace) {
        ResourceReference resourceReference = resourceSpace.lookupResource(spaceEntry, string);
        if (resourceReference != null) {
            return resourceReference;
        }
        ContainerResource containerResource = this;
        synchronized (containerResource) {
            resourceReference = resourceSpace.lookupResource(spaceEntry, string);
            if (resourceReference != null) {
                return resourceReference;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
            hashtable.put(id, string);
            ResourceContext resourceContext = this.updateDefaultChildAttributes(hashtable);
            resourceReference = resourceSpace.loadResource(spaceEntry, string, hashtable);
            if (resourceReference != null) {
                resourceContext.setResourceReference(resourceReference);
                try {
                    Resource resource = resourceReference.lock();
                    if (resource instanceof FramedResource) {
                        FramedResource framedResource = (FramedResource)resource;
                        framedResource.addStructureChangedListener(this);
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                finally {
                    resourceReference.unlock();
                }
            }
        }
        return resourceReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        if (super.lookup(lookupState, lookupResult)) {
            return true;
        }
        String string = lookupState.getNextComponent();
        ResourceReference resourceReference = null;
        resourceReference = this.lookup(string);
        if (resourceReference == null) {
            lookupResult.setTarget(null);
            return false;
        }
        try {
            lookupResult.setTarget(resourceReference);
            FramedResource framedResource = (FramedResource)resourceReference.lock();
            boolean bl = framedResource != null ? framedResource.lookup(lookupState, lookupResult) : false;
            return bl;
        }
        catch (InvalidResourceException invalidResourceException) {
            boolean bl = false;
            return bl;
        }
        finally {
            resourceReference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String string) throws MultipleLockException {
        ResourceReference resourceReference = null;
        resourceReference = this.lookup(string);
        if (resourceReference != null) {
            try {
                ResourceReference resourceReference2 = resourceReference;
                synchronized (resourceReference2) {
                    Resource resource = resourceReference.lock();
                    if (resource instanceof FramedResource) {
                        ((FramedResource)resource).removeStructureChangedListener(this);
                    }
                    resource.delete();
                }
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            finally {
                resourceReference.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replace(DirectoryResource directoryResource) throws MultipleLockException {
        Enumeration enumeration = this.enumerateResourceIdentifiers();
        ResourceReference resourceReference = null;
        Resource resource = null;
        while (enumeration.hasMoreElements()) {
            resourceReference = this.lookup((String)enumeration.nextElement());
            if (resourceReference == null) continue;
            try {
                resource = resourceReference.lock();
                ResourceContext resourceContext = new ResourceContext(directoryResource.getContext());
                resource.setContext(resourceContext, true);
                if (!(resource instanceof FramedResource)) continue;
                ((FramedResource)resource).removeStructureChangedListener(this);
                ((FramedResource)resource).addStructureChangedListener(directoryResource);
            }
            catch (InvalidResourceException invalidResourceException) {}
            continue;
            finally {
                resourceReference.unlock();
            }
        }
        super.delete();
    }

    public synchronized void delete() throws MultipleLockException {
        this.disableEvent();
        ResourceSpace resourceSpace = this.getSpace();
        this.acquireChildren();
        this.deleteChildren();
        this.disableEvent();
        SpaceEntry spaceEntry = this.getChildrenSpaceEntry();
        super.delete();
        resourceSpace.deleteChildren(spaceEntry);
    }

    protected synchronized void deleteChildren() throws MultipleLockException {
        this.disableEvent();
        this.acquireChildren();
        Enumeration enumeration = this.enumerateResourceIdentifiers();
        while (enumeration.hasMoreElements()) {
            this.delete((String)enumeration.nextElement());
        }
        this.enableEvent();
    }

    public void notifyUnload() {
        super.notifyUnload();
    }

    protected synchronized void acquireChildren() {
        if (!this.acquired) {
            ResourceSpace resourceSpace = this.getSpace();
            resourceSpace.acquireChildren(this.getChildrenSpaceEntry());
            this.acquired = true;
        }
    }

    protected synchronized ResourceReference addResource(Resource resource, Hashtable hashtable) {
        this.acquireChildren();
        ResourceReference resourceReference = this.getSpace().addResource(this.getChildrenSpaceEntry(), resource, hashtable);
        resource.getContext().setResourceReference(resourceReference);
        if (resource instanceof FramedResource) {
            FramedResource framedResource = (FramedResource)resource;
            framedResource.addStructureChangedListener(this);
        }
        this.markModified();
        this.postStructureChangedEvent(resourceReference, 1002);
        return resourceReference;
    }

    public void registerResource(String string, Resource resource, Hashtable hashtable) throws InvalidResourceException {
        ResourceReference resourceReference;
        this.acquireChildren();
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>(4);
        }
        hashtable.put(id, string);
        ResourceContext resourceContext = this.updateDefaultChildAttributes(hashtable);
        if (resourceContext != null) {
            resource.initialize(hashtable);
            resourceReference = this.getSpace().addResource(this.getChildrenSpaceEntry(), resource, hashtable);
            resourceContext.setResourceReference(resourceReference);
            if (resource instanceof FramedResource) {
                FramedResource framedResource = (FramedResource)resource;
                framedResource.addStructureChangedListener(this);
            }
        } else {
            throw new InvalidResourceException(this.getIdentifier(), string, "unable to get context");
        }
        this.markModified();
        this.postStructureChangedEvent(resourceReference, 1002);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.disableEvent();
        String string = this.getURLPath();
        if (string != null && !string.endsWith("/")) {
            this.setValue(ATTR_URL, (Object)(string + "/"));
        }
        this.acquired = false;
        this.enableEvent();
    }

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.ContainerResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("key", null, 1);
        ATTR_KEY = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }
}

