/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.io.Serializable;
import java.util.Vector;
import org.w3c.www.mime.MimeTypeFormatException;

public class MimeType
implements Serializable,
Cloneable {
    public static MimeType TEXT_HTML = null;
    public static MimeType APPLICATION_POSTSCRIPT = null;
    public static MimeType TEXT_PLAIN = null;
    public static MimeType APPLICATION_X_WWW_FORM_URLENCODED = null;
    public static MimeType APPLICATION_OCTET_STREAM = null;
    public static MimeType MULTIPART_FORM_DATA = null;
    public static MimeType APPLICATION_X_JAVA_AGENT = null;
    public static MimeType MESSAGE_HTTP = null;
    public static MimeType TEXT_CSS = null;
    public static MimeType TEXT_XML = null;
    public static MimeType APPLICATION_XML = null;
    public static MimeType TEXT = null;
    public static MimeType APPLICATION_RDF_XML = null;
    public static MimeType APPLICATION_XHTML_XML = null;
    public static String star = "*".intern();
    public static final int NO_MATCH = -1;
    public static final int MATCH_TYPE = 1;
    public static final int MATCH_SPECIFIC_TYPE = 2;
    public static final int MATCH_SUBTYPE = 3;
    public static final int MATCH_SPECIFIC_SUBTYPE = 4;
    protected String type = null;
    protected String subtype = null;
    protected String[] pnames = null;
    protected String[] pvalues = null;
    protected String external = null;

    public int match(MimeType mimeType) {
        int n = -1;
        if (this.type == star || mimeType.type == star) {
            return 1;
        }
        if (this.type != mimeType.type) {
            return -1;
        }
        n = 2;
        if (this.subtype == star || mimeType.subtype == star) {
            n = 3;
        } else {
            if (this.subtype != mimeType.subtype) {
                return -1;
            }
            n = 4;
        }
        return n;
    }

    public boolean equiv(MimeType mimeType) {
        if (this.match(mimeType) == 4) {
            return true;
        }
        return !(this.match(TEXT_XML) != 4 && this.match(APPLICATION_XML) != 4 || mimeType.match(TEXT_XML) != 4 && mimeType.match(APPLICATION_XML) != 4);
    }

    public String toString() {
        if (this.external == null) {
            StringBuffer stringBuffer = new StringBuffer(this.type);
            stringBuffer.append('/');
            stringBuffer.append(this.subtype);
            if (this.pnames != null) {
                for (int i = 0; i < this.pnames.length; ++i) {
                    stringBuffer.append(';');
                    stringBuffer.append(this.pnames[i]);
                    if (this.pvalues[i] == null) continue;
                    stringBuffer.append('=');
                    stringBuffer.append(this.pvalues[i]);
                }
            }
            this.external = stringBuffer.toString().intern();
        }
        return this.external;
    }

    public boolean hasParameter(String string) {
        if (string != null && this.pnames != null) {
            String string2 = string.toLowerCase();
            for (int i = 0; i < this.pnames.length; ++i) {
                if (!this.pnames[i].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getParameterValue(String string) {
        if (string != null && this.pnames != null) {
            String string2 = string.toLowerCase();
            for (int i = 0; i < this.pnames.length; ++i) {
                if (!this.pnames[i].equals(string2)) continue;
                return this.pvalues[i];
            }
        }
        return null;
    }

    public void addParameters(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray2.length != stringArray.length) {
            return;
        }
        if (this.pnames == null) {
            this.pnames = stringArray;
            this.pvalues = stringArray2;
        } else {
            String[] stringArray3 = new String[this.pnames.length + stringArray.length];
            String[] stringArray4 = new String[this.pvalues.length + stringArray2.length];
            System.arraycopy(this.pnames, 0, stringArray3, 0, this.pnames.length);
            System.arraycopy(stringArray, 0, stringArray3, this.pnames.length, stringArray.length);
            System.arraycopy(this.pvalues, 0, stringArray4, 0, this.pvalues.length);
            System.arraycopy(stringArray2, 0, stringArray4, this.pvalues.length, stringArray2.length);
            this.pnames = stringArray3;
            this.pvalues = stringArray4;
        }
        for (int i = 0; i < this.pnames.length; ++i) {
            this.pnames[i] = this.pnames[i].toLowerCase();
        }
        this.external = null;
    }

    public MimeType getClone() {
        try {
            return (MimeType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void addParameter(String string, String string2) {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        stringArray[0] = string;
        stringArray2[0] = string2;
        this.addParameters(stringArray, stringArray2);
    }

    public void setParameter(String string, String string2) {
        if (this.pnames == null) {
            this.addParameter(string, string2);
        } else {
            String string3 = string.toLowerCase();
            for (int i = 0; i < this.pnames.length; ++i) {
                if (!this.pnames[i].equals(string3)) continue;
                this.pvalues[i] = string2;
                return;
            }
            this.addParameter(string3, string2);
        }
    }

    public MimeType(String string) throws MimeTypeFormatException {
        int n;
        int n2 = string.length();
        int n3 = -1;
        for (n = 0; n < n2 && string.charAt(n) <= ' '; ++n) {
        }
        while (n2 > n && string.charAt(n2 - 1) <= ' ') {
            --n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < n2) {
            char c = string.charAt(n);
            n3 = c;
            if (c == '/') break;
            stringBuffer.append(Character.toLowerCase((char)n3));
            ++n;
        }
        if (n3 != 47) {
            throw new MimeTypeFormatException(string);
        }
        this.type = stringBuffer.toString().intern();
        ++n;
        stringBuffer.setLength(0);
        while (n < n2) {
            char c = string.charAt(n);
            n3 = c;
            if (c <= ' ' || n3 == 59) break;
            stringBuffer.append(Character.toLowerCase((char)n3));
            ++n;
        }
        this.subtype = stringBuffer.toString().intern();
        while (n < n2) {
            char c = string.charAt(n);
            n3 = c;
            if (c > ' ') break;
            ++n;
        }
        if (n < n2) {
            if (string.charAt(n) != ';') {
                throw new MimeTypeFormatException(string);
            }
            ++n;
            Vector<String> vector = new Vector<String>(4);
            Vector<String> vector2 = new Vector<String>(4);
            while (n < n2) {
                while (n < n2 && string.charAt(n) <= ' ') {
                    ++n;
                }
                stringBuffer.setLength(0);
                while (n < n2) {
                    char c = string.charAt(n);
                    n3 = c;
                    if (c <= ' ' || n3 == 61) break;
                    stringBuffer.append(Character.toLowerCase((char)n3));
                    ++n;
                }
                String string2 = stringBuffer.toString();
                while (n < n2 && string.charAt(n) <= ' ') {
                    ++n;
                }
                if (string.charAt(n) != '=') {
                    throw new MimeTypeFormatException(string);
                }
                ++n;
                while (n < n2 && (string.charAt(n) == '\"' || string.charAt(n) <= ' ')) {
                    ++n;
                }
                stringBuffer.setLength(0);
                while (n < n2) {
                    char c = string.charAt(n);
                    n3 = c;
                    if (c <= ' ' || n3 == 59 || n3 == 34) break;
                    stringBuffer.append((char)n3);
                    ++n;
                }
                while (n < n2 && string.charAt(n) != ';') {
                    ++n;
                }
                ++n;
                String string3 = stringBuffer.toString();
                vector.addElement(string2);
                vector2.addElement(string3);
            }
            this.pnames = new String[vector.size()];
            vector.copyInto(this.pnames);
            this.pvalues = new String[vector2.size()];
            vector2.copyInto(this.pvalues);
        }
    }

    public MimeType(String string, String string2, String[] stringArray, String[] stringArray2) {
        this.type = string.toLowerCase().intern();
        this.subtype = string2.toLowerCase().intern();
        this.pnames = stringArray;
        this.pvalues = stringArray2;
    }

    public MimeType(String string, String string2) {
        this.type = string.toLowerCase().intern();
        this.subtype = string2.toLowerCase().intern();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            MimeType mimeType = null;
            try {
                mimeType = new MimeType(stringArray[0]);
            }
            catch (MimeTypeFormatException mimeTypeFormatException) {
                // empty catch block
            }
            if (mimeType != null) {
                System.out.println(mimeType);
                if (mimeType.getClone().match(mimeType) == 4) {
                    System.out.println("Clone OK");
                } else {
                    System.out.println("Cloning failed");
                }
            } else {
                System.out.println("Invalid mime type specification.");
            }
        } else {
            System.out.println("Usage: java MimeType <type-to-parse>");
        }
    }

    static {
        try {
            TEXT_HTML = new MimeType("text/html");
            APPLICATION_POSTSCRIPT = new MimeType("application/postscript");
            TEXT_PLAIN = new MimeType("text/plain");
            APPLICATION_X_WWW_FORM_URLENCODED = new MimeType("application/x-www-form-urlencoded");
            APPLICATION_OCTET_STREAM = new MimeType("application/octet-stream");
            MULTIPART_FORM_DATA = new MimeType("multipart/form-data");
            APPLICATION_X_JAVA_AGENT = new MimeType("application/x-java-agent");
            MESSAGE_HTTP = new MimeType("message/http");
            TEXT_CSS = new MimeType("text/css");
            TEXT_XML = new MimeType("text/xml");
            TEXT = new MimeType("text/*");
            APPLICATION_RDF_XML = new MimeType("application/rdf+xml");
            APPLICATION_XHTML_XML = new MimeType("application/xhtml+xml");
            APPLICATION_XML = new MimeType("application/xml");
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            System.out.println("httpd.MimeType: invalid static init.");
            System.exit(1);
        }
    }
}

