/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.util.IntObjectMap;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmaCoverageRunner
extends JavaCoverageRunner {
    private static final Logger LOG = Logger.getInstance(EmmaCoverageRunner.class);

    public boolean isJdk7Compatible() {
        return false;
    }

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite coverageSuite) {
        if (sessionDataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionDataFile", "com/intellij/coverage/EmmaCoverageRunner", "loadCoverageData"));
        }
        ProjectData projectInfo = new ProjectData();
        try {
            IMergeable[] data = DataFactory.load((File)sessionDataFile);
            IMetaData metaData = (IMetaData)data[0];
            ICoverageData coverageData = (ICoverageData)data[1];
            if (metaData == null || coverageData == null) {
                return projectInfo;
            }
            for (ClassDescriptor descriptor : metaData) {
                ICoverageData.DataHolder coverage = coverageData.getCoverage(descriptor);
                if (coverage == null) continue;
                String classVMName = descriptor.getClassVMName();
                ClassData classInfo = projectInfo.getOrCreateClassData(classVMName.replace('/', '.'));
                MethodDescriptor[] methodDescriptors = descriptor.getMethods();
                if (methodDescriptors.length > coverage.m_coverage.length) {
                    LOG.info("broken data for " + classVMName + " - descriptors: " + methodDescriptors.length + "; gathered coverage: " + coverage.m_coverage.length);
                    continue;
                }
                for (int i = 0; i < methodDescriptors.length; ++i) {
                    MethodDescriptor methodDescriptor = methodDescriptors[i];
                    boolean[] methodCoverage = coverage.m_coverage[i];
                    IntObjectMap lineMap = methodDescriptor.getLineMap();
                    if (lineMap == null) continue;
                    int[] lines = lineMap.keys();
                    int maxLine = 0;
                    for (int line : lines) {
                        if (line <= maxLine) continue;
                        maxLine = line;
                    }
                    LineData[] lDatum = new LineData[maxLine + 1];
                    for (int line : lines) {
                        LineData lineData = new LineData(line, methodDescriptor.getName() + methodDescriptor.getDescriptor());
                        lineData.setStatus(EmmaCoverageRunner.calcStatus(methodCoverage, lineMap, lineData));
                        classInfo.registerMethodSignature(lineData);
                        lDatum[line] = lineData;
                    }
                    classInfo.setLines(lDatum);
                }
            }
        }
        catch (IOException e) {
            return projectInfo;
        }
        return projectInfo;
    }

    private static byte calcStatus(boolean[] methodCoverage, IntObjectMap lineMap, LineData lineInfo) {
        if (methodCoverage == null) {
            return 0;
        }
        int[] blocks = (int[])lineMap.get(lineInfo.getLineNumber());
        boolean isCoveredBlock = false;
        boolean isUncoveredBlock = false;
        for (int block : blocks) {
            if (block < methodCoverage.length && methodCoverage[block]) {
                isCoveredBlock = true;
                if (!isUncoveredBlock) continue;
                break;
            }
            if (block >= methodCoverage.length) {
                LOG.info("emma: inconsistent coverage data for line: " + lineInfo.getMethodSignature());
            }
            isUncoveredBlock = true;
            if (isCoveredBlock) break;
        }
        if (isCoveredBlock) {
            lineInfo.setHits(1);
            return isUncoveredBlock ? (byte)1 : 2;
        }
        return 0;
    }

    public void appendCoverageArgument(String sessionDataFilePath, String[] patterns, SimpleJavaParameters javaParameters, boolean collectLineInfo, boolean isSampling) {
        StringBuffer argument = new StringBuffer("-javaagent:");
        String agentJar = "emma-agent.jar";
        String agentPath = PathManager.getHomePath() + File.separator + "plugins" + File.separator + "emma" + File.separator + "lib" + File.separator + "emma-agent.jar";
        String path = EmmaCoverageRunner.handleSpacesInPath((String)agentPath) + File.separator + "emma-agent.jar";
        argument.append(path).append("=");
        try {
            File tempFile = EmmaCoverageRunner.createTempFile();
            tempFile.deleteOnExit();
            if (patterns != null && patterns.length > 0) {
                EmmaCoverageRunner.write2file((File)tempFile, (String)"-f");
                StringBuffer patternsBuf = new StringBuffer();
                for (int i = 0; i < patterns.length; ++i) {
                    if (i > 0) {
                        patternsBuf.append(",");
                    }
                    String pattern = patterns[i];
                    if (!(pattern = pattern.replace('.', '/')).endsWith("/*")) {
                        patternsBuf.append(pattern).append(",").append(pattern).append("$*");
                        continue;
                    }
                    patternsBuf.append(pattern);
                }
                EmmaCoverageRunner.write2file((File)tempFile, (String)patternsBuf.toString());
            }
            EmmaCoverageRunner.write2file((File)tempFile, (String)"-o");
            EmmaCoverageRunner.write2file((File)tempFile, (String)sessionDataFilePath);
            argument.append(tempFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOG.info("Coverage was not enabled", (Throwable)e);
            return;
        }
        javaParameters.getVMParametersList().add(argument.toString());
        javaParameters.getVMParametersList().add("-Demma.rt.control=false");
    }

    public String getPresentableName() {
        return "Emma";
    }

    @NonNls
    public String getId() {
        return "emma";
    }

    @NonNls
    public String getDataFileExtension() {
        return "es";
    }
}

