/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopAnnotationPattern;
import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPatternContainer;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.NotPattern;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopNotExpression
extends AopElementBase
implements PsiPointcutExpression,
AopTypeExpression,
AopAnnotationPattern {
    public AopNotExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopNotExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "AopNotExpression";
    }

    @Nullable
    public AopPatternContainer getInnerExpression() {
        return (AopPatternContainer)this.findChildByClass(AopPatternContainer.class);
    }

    @NotNull
    public PsiElement getNotToken() {
        PsiElement psiElement = this.findChildByType(AopElementTypes.AOP_NOT);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopNotExpression", "getNotToken"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        AopPatternContainer expression = this.getInnerExpression();
        PointcutMatchDegree pointcutMatchDegree = expression instanceof PsiPointcutExpression ? PointcutMatchDegree.not(((PsiPointcutExpression)expression).acceptsSubject(context, member)) : PointcutMatchDegree.FALSE;
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopNotExpression", "acceptsSubject"));
        }
        return pointcutMatchDegree;
    }

    @NotNull
    public Collection<AopPsiTypePattern> getInnerPatterns() {
        AopPatternContainer typeExpression = this.getInnerExpression();
        if (typeExpression != null) {
            Collection<AopPsiTypePattern> collection = typeExpression.getPatterns();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopNotExpression", "getInnerPatterns"));
            }
            return collection;
        }
        List<AopPsiTypePattern> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopNotExpression", "getInnerPatterns"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        List list = ContainerUtil.map2List(this.getInnerPatterns(), aopPsiTypePattern -> new NotPattern((AopPsiTypePattern)aopPsiTypePattern));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopNotExpression", "getPatterns"));
        }
        return list;
    }

    @Override
    public String getTypePattern() {
        AopPatternContainer expression = this.getInnerExpression();
        if (expression instanceof AopTypeExpression) {
            String pattern = ((AopTypeExpression)expression).getTypePattern();
            if (pattern == null) {
                return null;
            }
            return "'_:[!is(\"" + pattern + "\")]";
        }
        return null;
    }
}

